# CiviCRM 5.0.0

Released April 4, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-21659](https://issues.civicrm.org/jira/browse/CRM-21659) Add hook to
  CRM_Utils_System::redirect ([11519](https://github.com/civicrm/civicrm-core/pull/11519))**

  Adds a hook (hook_civicrm_alterRedirect) when the browser is being redirected. This allows extensions to
  override the destination of an HTTP redirect.

  The UriInterface from PSR-7 is included; the concrete implementation of Uri is loaded from Guzzle v6.3+.

- **[civicrm/civicrm-setup#1](https://github.com/civicrm/civicrm-setup/issues/1)
  Simplify SQL and translation pipeline (preliminary work)
  [11699](https://github.com/civicrm/civicrm-core/pull/11699),
  [11682](https://github.com/civicrm/civicrm-core/pull/11682), and
  [11677](https://github.com/civicrm/civicrm-core/pull/11677)**

  Along with a handful of supporting changes, these changes allow strings to be
  translated without needing CiviCRM to be operating.  This sets the stage for
  generating basic CiviCRM data in the appropriate language as part of the
  CiviCRM installation process.

- **Fix relationshipType, paymentProcessorType, Note & jobLog apis to support
  custom data ([11721](https://github.com/civicrm/civicrm-core/pull/11721))**

  Updates the relationshipType, paymentProcessorType & jobLog apis to support
  custom data.

- **Fix more entities to support custom fields (via api)
  ([11688](https://github.com/civicrm/civicrm-core/pull/11688))**

  This change moves us closer to the goal of being able to define custom data on 'any
  entity'. It takes us from a limited list of entities that work to a longer list of
  ones that still don't work

- **[dev/core#12](https://lab.civicrm.org/dev/core/issues/12) Improvement: for
  crmUiWizard-driven workflows, scroll back to top between steps
  ([11790](https://github.com/civicrm/civicrm-core/pull/11790))**

  Adds auto-scroll-up functionality between steps in a wizard-driven workflow.

- **Fix style glitches ([11792](https://github.com/civicrm/civicrm-core/pull/11792))**

  This change adds a space after the x between the form input for a phone number
  and the form input for the extension to improve user experience.

- **Update minimum php version to 5.5
  ([11453](https://github.com/civicrm/civicrm-core/pull/11453))**

  This change bumps up the minimum version to follow the schedule laid out in
  https://civicrm.org/blog/totten/end-of-zombies-php-53-and-54

- **Fixed template structure issues
  ([11766](https://github.com/civicrm/civicrm-core/pull/11766))**

  Moves help section outside block and adds missing label.

- **[CRM-21823](https://issues.civicrm.org/jira/browse/CRM-21823) Change
  position of help div and fix structure glitches
  ([11750](https://github.com/civicrm/civicrm-core/pull/11750))**

  This standardizes the markup structure for the date settings, localization,
  and memberships admin pages so that the help section sits outside the form
  block, inline CSS is removed, and buttons are wrapped with the correct wrapper
  class.

- **[CRM-21817](https://issues.civicrm.org/jira/browse/CRM-21817) Move help
  section outside crm block as per other pages
  ([11738](https://github.com/civicrm/civicrm-core/pull/11738))**

  This change moves help section for word replacement page, outside crm block
  to preserve consistency.

- **CKEditor Advanced Options - Better validation of options
  ([11752](https://github.com/civicrm/civicrm-core/pull/11752))**

  In the "Advanced Options" of the CKEditor Configurator, API options can be
  selected. This tweaks the UI to prevent the same option from being selected
  twice, which would not make sense.

- **Update to PHPWord 0.14.0
  ([11696](https://github.com/civicrm/civicrm-core/pull/11696))**

   Updates PHPWord from 0.13.0 to 0.14.0. PHPWord 0.14.0 fixes a number of bugs
   and adds some new features, more information on PHPWord 0.14.0 can be found
   [here](https://github.com/PHPOffice/PHPWord/releases/tag/0.14.0).

- **[dev/release#1](https://lab.civicrm.org/dev/release/issues/1) 5.x - Update
  version-numbering pattern
  ([11731](https://github.com/civicrm/civicrm-core/pull/11731))**

  The utility, tools/bin/scripts/set-version.php, is used to generate
  boilerplate files for incremental updates. This change improves compatibility
  with the version realignment (5.x.x).

- **[CRM-21810](https://issues.civicrm.org/jira/browse/CRM-21810) improve
  changelog search panel UI
  ([11729](https://github.com/civicrm/civicrm-core/pull/11729))**

  This change improves the change log panel in Advanced Search UI. It places the
  added/modified radio buttons at the top and moves the two search fields side by
  side to make the layout more logical and to make better use of the space.

- **[CRM-21765](https://issues.civicrm.org/jira/browse/CRM-21765) Commit files
  to git which are static but are generated from CodeGen like DAO files
  ([11667](https://github.com/civicrm/civicrm-core/pull/11667))**

  This change adds SchemaStructure.php and langs.php files (which are static but
  generated from CodeGen) to git, reducing the need to run GenCode.

### CiviCase

- **[CRM-21558](https://issues.civicrm.org/jira/browse/CRM-21558) Add batch
  update via profile to cases
  ([11411](https://github.com/civicrm/civicrm-core/pull/11411))**

  This change adds a "Update Multiple Cases" option to search tasks and allows
  you to batch update multiple cases in the same way as other entities.

### CiviContribute

- **[CRM-20610](https://issues.civicrm.org/jira/browse/CRM-20610) Replace
  payment details block with editable payment list on 'Edit Contribution' form
  ([11748](https://github.com/civicrm/civicrm-core/pull/11748)) (preliminary
  work)**

  This change makes it possible via hook or by changing core to switch to using
  the payment form on the 'Edit Contribution' form for payments without actually
  making that change.

- **Fix transaction template
  ([11811](https://github.com/civicrm/civicrm-core/pull/11811))**

  Updated transaction template to make them match other templates for
  consistency.

- **[CRM-21693](https://issues.civicrm.org/jira/browse/CRM-21693) show Display
  Name in online pay now UI
  ([11571](https://github.com/civicrm/civicrm-core/pull/11571))**

  Before this change using the special constructed PayNow link it was not clear
  which person the payment was for. This change makes it so the Online Pay Now
  form shows the Display Name of the person the contribution belongs to.

### CiviEvent

- **[CRM-21803](https://issues.civicrm.org/jira/browse/CRM-21803) Standardise
  ParticipantPayment api to support custom data
  ([11718](https://github.com/civicrm/civicrm-core/pull/11718))**

  The ParticipantPayment API now uses the standard api function, this has the
  added bonus of allowing this api to support custom data.

- **[CRM-21805](https://issues.civicrm.org/jira/browse/CRM-21805) Fix structure
  for search pages in find participant
  ([11723](https://github.com/civicrm/civicrm-core/pull/11723))**

  This change restructures the Participant search pages so that the labels are
  above the inputs for consistency and improved user experience.

### CiviMail

- **[CRM-21576](https://issues.civicrm.org/jira/browse/CRM-21576) Implement Send
  SMS permission ([11590](https://github.com/civicrm/civicrm-core/pull/11590))**

  This change adds a permission to Send SMS. More specifically, it: Adds the Send SMS
  permission to CRM_Core_Permissions::getCorePermissions, ensures that all
  navigation menu entries ('Find SMS' and 'New SMS') respect the new permission,
  Ensures that all paths (civicrm/sms/send, civicrm/activity/sms/add,
  civicrm/mailing) respect the new permission, Only show 'Outbound SMS' action
  from the action menu on the contact screen to users with the send SMS
  permission, and only shows 'SMS - schedule/send' from the advanced search
  actions to users with the send SMS permission.

- **[CRM-21140](https://issues.civicrm.org/jira/browse/CRM-21140) Agree & (if
  applicable) implement approach to storing extension data for entities / tables
  ([11608](https://github.com/civicrm/civicrm-core/pull/11608))**

  This change makes it possible to extend Mailing with Custom data by making it
  so the Mailing api supports custom data. This is primarily for the benefit of
  extension writers.

- **[CRM-21405](https://issues.civicrm.org/jira/browse/CRM-21405) Allow
  "Outbound SMS" when Mobile is not primary phone number
  ([11252](https://github.com/civicrm/civicrm-core/pull/11252))**

  This change makes it so when a contact has a mobile phone number but it is not
  the primary number the "Outbound SMS" action is allowed, and usees the first
  available mobile number from the contact.

- **Add 'huge' class to html textarea to match plaintext textarea
  ([11770](https://github.com/civicrm/civicrm-core/pull/11770))**

  This change makes it so that the HTML Format input and the Plain Text Format
  input On the Message Template editor screen match.

- **[CRM-21244](https://issues.civicrm.org/jira/browse/CRM-21244) Enhancements
  to "FROM email addresses"
  ([11914](https://github.com/civicrm/civicrm-core/pull/11914)) (continues
  previous work)**

  Help text now adjusts according to whether the logged-in user's email is
  allowed as a From address option.

### CiviMember

- **[CRM-21733](https://issues.civicrm.org/jira/browse/CRM-21733) Allow
  overriding membership status temporarily until specific date
  ([11722](https://github.com/civicrm/civicrm-core/pull/11722) and
  [11622](https://github.com/civicrm/civicrm-core/pull/11622))**

  When overriding a membership status this change provides extra options to allow
  a temporary status override.

  Instead of having a checkbox called (Override Status?) in membership
  add/edit/renew form, it is replaced with a select box that allow the user to
  choose one of three options: No, Override Permanently or Override until selected
  date.

  If the first option is selected, then the membership will behave as if the old
  (Override Status?) is *unchecked*, which means that the membership is subject to
  membership status rules.

  If the 2nd option is selected, then the membership will behave as if the old
  (Override Status?) is *checked*, which mean that the membership status is
  overridden and is not subject to the membership statues rules.

  If the 3rd option is selected, then a new field will appear allowing the user to
  choose a date, in this status, the membership will behave similar to option 2,
  but when today date is equal or less than the selected date, then the "Update
  Membership Statuses" scheduled job will automatically convert its status back to
  *No*, which means that the membership status is overridden temporarily only for
  the selected date and after that it will revert back and be subject to
  membership status rules.

### Drupal Integration

- **[civicrm/civicrm-setup#11](https://github.com/civicrm/civicrm-setup/pull/11)
  Implement D8 initialization for civicrm-setup
  [11695](https://github.com/civicrm/civicrm-core/pull/11695)**

  This removes references to `templates/CRM/common/version.tpl` which will not
  be created as part of the new Drupal 8 installer.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-21830](https://issues.civicrm.org/jira/browse/CRM-21830) State/Province
  tokens are not working as expected in address settings for billing address
  ([11776](https://github.com/civicrm/civicrm-core/pull/11776))**

  When the 'state_province_name' token was used (in address settings), the
  state/province was empty when 'Billing Address' was displayed. This change
  makes it so when the 'state_province_name' token is used in address settings
  the token is populated when the billing address is displayed

- **[CRM-21781](https://issues.civicrm.org/jira/browse/CRM-21781) Don't crash if
  contact ID not found when viewing contact
  ([11690](https://github.com/civicrm/civicrm-core/pull/11690))**

  In various situations if one ended up at civicrm/contact/view without URL
  parameters (for example logging back in after session expiry) a fatal error was
  thrown.

  This change makes it so that instead of throwing a fatal error one is bounced
  back to the Civi dashboard.

- **[CRM-21826](https://issues.civicrm.org/jira/browse/CRM-21826) Default FROM
  Email Address (for system-generated emails) link incorrect in System Status
  Screen ([11756](https://github.com/civicrm/civicrm-core/pull/11756))**

  This updates the System Status Screen to have separate links for Domain Name and From
  Email Address.

- **/civicrm/upgrade - On finish screen, display actual version number
  ([11705](https://github.com/civicrm/civicrm-core/pull/11705))**

  The upgrade finish screen was hard-coded to always display the message "Thank
  you for upgrading to 4.7...". This change makes it dynamic, plugging in the
  actual version number.

- **Activity Form - Fix recently introduced warning
  ([11815](https://github.com/civicrm/civicrm-core/pull/11815))**

  Fixes a code warning thrown on the activity form.

- **[CRM-21667](https://issues.civicrm.org/jira/browse/CRM-21667) Bad timezone
  hand-off from CMS to CRM
  ([11800](https://github.com/civicrm/civicrm-core/pull/11800))**

  This change resolves errors resulting from representation of timezone data in different
  formats. Now timezone data is converted from GMT offset in seconds to region
  string, as expected by related methods. This fixes takes into account daylight
  savings time.

- **CKEditorConfig - Fix double-escaped slashes
  ([11747](https://github.com/civicrm/civicrm-core/pull/11747))**

  The "Advanced Options" section of the CKEditor configurator allows user-input
  strings. Slashes were being escaped multiple times in that input. This fixes
  it.

- **CiviReport - Check for trueish values of the parameter 'required'
  ([11725](https://github.com/civicrm/civicrm-core/pull/11725))**

  The value of the parameter required is not evaluated to define whether the
  field should be shown as required or not. See previous discussion at
  [civicrm/civicrm-dev-docs#480](https://github.com/civicrm/civicrm-dev-docs/pull/480)

- **Fix wrong tag defintion
  ([11698](https://github.com/civicrm/civicrm-core/pull/11698))**

  This change fixes some broken HTML in the Data Source help notification pop-up.

- **Fix GroupNesting, GroupOrganization, Domain to work with singleValueAlter
  ([11689](https://github.com/civicrm/civicrm-core/pull/11689))**

  This change standardizes the apis for GroupNesting, GroupOrganization, and
  Domain and extends unit testing to cover them

- **composer.json - De-fork dependency, marcj/topsort
  ([11687](https://github.com/civicrm/civicrm-core/pull/11687))**

  When this dependency was originally added, we needed a few patches (for PHP
  5.3 compatibility) and initially used a forked version of library. Of course,
  it's undesirable to use a fork in the long term (e.g. harder to apply
  upgrades; harder to merge into other build processes).

  In the intervening period, upstream has merged the patches for PHP 5.3, and
  we've politely asked downstream to get over PHP 5.3, so we're covered on both
  ends. This change switches back to the mainline branch for marcj/topsort.

- **Ignore errors when upgrade step already took place
  ([11685](https://github.com/civicrm/civicrm-core/pull/11685))**

- **Add/Edit Contact - Fix inconsistent capitalization
  ([11675](https://github.com/civicrm/civicrm-core/pull/11675))**

  On the "Add/Edit Contact" screen, there are several similar links: "Add another
  phone number", "Add another IM", "Add another website". This change makes it so
  that they are all capitalized according the same rules (e.g. standard sentence
  case).

- **[CRM-21708](https://issues.civicrm.org/jira/browse/CRM-21708) Make structure
  proper by adding/removing appropriate classes
  ([11585](https://github.com/civicrm/civicrm-core/pull/11585))**

  This change fixes class structure for a handful of pages to make them
  consistent in preparation for common styling and to improve user experience.

- **[CRM-21391](https://issues.civicrm.org/jira/browse/CRM-21391) Refactor tasks
  to use a base class
  ([11808](https://github.com/civicrm/civicrm-core/pull/11808),
  [11761](https://github.com/civicrm/civicrm-core/pull/11761),
  [11762](https://github.com/civicrm/civicrm-core/pull/11762),
  [11763](https://github.com/civicrm/civicrm-core/pull/11763),
  [11760](https://github.com/civicrm/civicrm-core/pull/11760),
  [11759](https://github.com/civicrm/civicrm-core/pull/11759),
  [11758](https://github.com/civicrm/civicrm-core/pull/11758),
  [11692](https://github.com/civicrm/civicrm-core/pull/11692), and
  [11693](https://github.com/civicrm/civicrm-core/pull/11693))**

  Refactors all the component tasks so they are extend a new base class
  CRM_Core_Task.

  This change cleans up the code and uses shared code where possible. It also
  fixes a few bugs specifically, there were a number of issues with the "Advanced
  Search" when switching between component types where the task list would be
  populated with the wrong list of tasks, but the keys would trigger an action on
  the selected component and an unexpected action may occur and there was also a
  bug where when saving group_type mailing_list was always being checked.

- **[CRM-21777](https://issues.civicrm.org/jira/browse/CRM-21777) Improve the
  messaging related to Directories and Resources
  ([11802](https://github.com/civicrm/civicrm-core/pull/11802) and
  [11680](https://github.com/civicrm/civicrm-core/pull/11680))**

  This change makes it so when on the admin page "Directory Preference" or
  "Resource URL" fields initialized in civicrm.settings.php are loaded as
  readonly. Prior to this change the fields were being loaded as editable but
  the values were not being saved because they were being overridden by the
  values in the civicrm.settings.php file). This change also adds a warning
  which lets the user know that some fields are already set (overridden) in
  settings file.

- **[CRM-21837](https://issues.civicrm.org/jira/browse/CRM-21837) Missing states
  for Gabon ([11793](https://github.com/civicrm/civicrm-core/pull/11793))**

  This change adds missing states definition for Gabon based on current ISO
  standard.

- **[CRM-21766](https://issues.civicrm.org/jira/browse/CRM-21766) Dedupe screen
  gives inappropriate confirm message when clicking on batch dedupe
  ([11670](https://github.com/civicrm/civicrm-core/pull/11670))**

  After doing a batch merge which resulted in a screen of conflicts, if you were
  to click on 'refresh list' you got a 'Do you want to leave this site? Changes
  you made may not be saved.' popup. This change removes that popup as there was
  nothing to edit.

- **[CRM-21773](https://issues.civicrm.org/jira/browse/CRM-21773) CRM-20858
  breaks merging multi-value custom groups
  ([11691](https://github.com/civicrm/civicrm-core/pull/11691))**

  This change fixes a bug where Multi-value custom fields were being ignored
  during the merge process, so that Multi-value fields are migrated if required.

- **[CRM-20554](https://issues.civicrm.org/jira/browse/CRM-20554) Error when
  running activity report
  ([11630](https://github.com/civicrm/civicrm-core/pull/11630))**

  On the Activity Detail report, a series of warnings and notices were being
  thrown, this change fixes the parameters of the select and from function so that
  no errors are thrown.

- **[CRM-21809](https://issues.civicrm.org/jira/browse/CRM-21809) 'Advance
  search' group by issue
  ([11728](https://github.com/civicrm/civicrm-core/pull/11728))**

  This fixes a bug where when doing an advanced search (with MySQL
  FULL_GROUP_BY_MODE enabled), when one choose any activity type and searched the
  actual number of rows listed and the row count per page differed so that the
  count is now accurate.

- **[CRM-21806](https://issues.civicrm.org/jira/browse/CRM-21806) Search builder
  returns no results
  ([11769](https://github.com/civicrm/civicrm-core/pull/11769),
  [11751](https://github.com/civicrm/civicrm-core/pull/11751), and
  [11746](https://github.com/civicrm/civicrm-core/pull/11746))**

  This change fixes a bug when using a profile in Search Views and attempting to
  search using one of the columns from the profile the advanced search
  incorrectly showed no results.

- **[CRM-21792](https://issues.civicrm.org/jira/browse/CRM-21792) Regression:
  Extension API cannot filter on status in get request
  ([11709](https://github.com/civicrm/civicrm-core/pull/11709))**

- **[CRM-21841](https://issues.civicrm.org/jira/browse/CRM-21841) objectType
  empty in hook_civicrm_searchTasks
  ([11861](https://github.com/civicrm/civicrm-core/pull/11861))**

- **Fix regression on CiviRules search due to exception handling
  ([11829](https://github.com/civicrm/civicrm-core/pull/11829))**

- **Revert "CRM-8140: Not possible to select fields for export when using Custom
  Searches" ([11828](https://github.com/civicrm/civicrm-core/pull/11828))**

### CiviCampaign

- **Add pre and post hooks to the Survey entity
  ([11813](https://github.com/civicrm/civicrm-core/pull/11813))**

  This change makes it so `hook_civicrm_pre` and `hook_civicrm_post` are invoked
  when a survey is saved.

- **[CRM-21797](https://issues.civicrm.org/jira/browse/CRM-21797) Change
  Structure for Campaign search forms
  ([11714](https://github.com/civicrm/civicrm-core/pull/11714))**

### CiviCase

- **[dev/core#8](https://lab.civicrm.org/dev/core/issues/8) Fatal error on
  Print/Merge Document for Cases
  ([11932](https://github.com/civicrm/civicrm-core/pull/11932))**

- **[CRM-21789](https://issues.civicrm.org/jira/browse/CRM-21789) 'Find Case'
  group by issue ([11706](https://github.com/civicrm/civicrm-core/pull/11706))**

  This ensures that when searching cases the count of cases found is accurate.

- **Re Add CRM_Case_Form_Task::PreProcessCommon()
  ([11928](https://github.com/civicrm/civicrm-core/pull/11928))**

### CiviContribute

- **Fix upgrade failures from zero value `trxn_date`
  ([11745](https://github.com/civicrm/civicrm-core/pull/11745))**

  Some longstanding CiviCRM installations would have upgrade failures going to
  4.7.19 or higher with the database error: "Incorrect datetime value:
  '0000-00-00 00:00:00' for column 'trxn_date'" This change fixes those values
  to be NULL prior to the query that causes the problem.

- **Add test for api money, fix net_amount calc
  ([11801](https://github.com/civicrm/civicrm-core/pull/11801))**

  Money values 5.000,77 & 5,000.77 were not being handled, they were being
  converted to '5' by mysql insert. This change handles these values by cleaning
  the money values in the api layer.

- **[CRM-20608](https://issues.civicrm.org/jira/browse/CRM-20608) IPN
  thinks Paypal Pro is Standard
  ([11777](https://github.com/civicrm/civicrm-core/pull/11777))**

  This fixes an issue where the CiviCRM interprets IPN messages from PayPal Pro
  as if they're Paypal Standard, causing problems for recurring payments. The
  fix makes it so that all incoming PayPal Pro IPN notifications for recurring
  contributions are correctly recorded as payments in CiviCRM.

- **[CRM-21756](https://issues.civicrm.org/jira/browse/CRM-21756) Editing
  Contribution (total_amount) does -not- update LineItem (line_total)
  ([11780](https://github.com/civicrm/civicrm-core/pull/11780))**

  Before this fix when we change the total amount of membership payment (or
  event registration), it doesn't update the corresponding line-item data,
  causing a data integrity issue. This fix makes it so that when editing a
  contribution for a membership payment or event registration the Total amount
  field is frozen and there is help text beside this field that provides
  instruction to perform the same task either by recreating the membership (or
  participant record) or using Lineitem Editor.

- **[CRM-21819](https://issues.civicrm.org/jira/browse/CRM-21819) Do not load
  "Submit Credit Card Contribution" button for invalid processors.
  ([11757](https://github.com/civicrm/civicrm-core/pull/11757))**

  Fixes a recent regression where the 'submit credit card' shows back office when
  it should not

- **[dev/core#7](https://lab.civicrm.org/dev/core/issues/7) recurring authorize
  IPN results in contribution with incorrect payment_instrument_id
  ([11768](https://github.com/civicrm/civicrm-core/pull/11768))**

- **ensure pdfFilename is set
  ([11702](https://github.com/civicrm/civicrm-core/pull/11702))**

  Before this change when downloading a PDF file receipt, the name you were
  prompted to save it as is not properly set. If it simply set to `.pdf`.
  This change makes it so the downloaded file name is named after the invoice id.

- **Throw exception instead of using fatal
  ([11719](https://github.com/civicrm/civicrm-core/pull/11719))**

  This change makes it so an exception is thrown instead of a fatal error when
  one starts doing a contribution, stops the browser half way through, and then
  tries to re-submit.

- **[dev/financial#5](https://lab.civicrm.org/dev/financial/issues/5) If a
  currency has been disabled allow the form to be submitted
  ([11795](https://github.com/civicrm/civicrm-core/pull/11795))**

- **Fix fatal on topDonor report
  ([11919](https://github.com/civicrm/civicrm-core/pull/11919))**

- **[CRM-21831](https://issues.civicrm.org/jira/browse/CRM-21831) and
  [dev/report#1](https://lab.civicrm.org/dev/report/issues/1) Fix regressions in
  contribution detail report relating to soft credits
  ([11917](https://github.com/civicrm/civicrm-core/pull/11917))**

### CiviEvent

- **[CRM-21764](https://issues.civicrm.org/jira/browse/CRM-21764) Recurring
  Events without Price Set fail to save
  ([11837](https://github.com/civicrm/civicrm-core/pull/11837))**

- **[CRM-21639](https://issues.civicrm.org/jira/browse/CRM-21639) Event pages
  should be set to NoIndex when event is not public or in the past
  ([11496](https://github.com/civicrm/civicrm-core/pull/11496) and
  [11498](https://github.com/civicrm/civicrm-core/pull/11498))**

  This change makes it so that the CiviCRM Print Preview pages are not indexed
  by search engines and this change makes sure Event Info pages are not indexed
  by search engines when the event is not public.

- **[CRM-21814](https://issues.civicrm.org/jira/browse/CRM-21814) Add proper
  container to text
  ([11735](https://github.com/civicrm/civicrm-core/pull/11735))**

  This change adds wrapper to dangling text without any wrapper in event configure
  tabs, there is no visual change for now.

- **[CRM-21770](https://issues.civicrm.org/jira/browse/CRM-21770) Change
  position of help div in export participants
  ([11678](https://github.com/civicrm/civicrm-core/pull/11678))**

  This changes the position of the help div on the Export page to be outside the
  form block to be consistent with other pages.

- **[CRM-21771](https://issues.civicrm.org/jira/browse/CRM-21771) error when
  viewing event registration with linked contribution
  ([11707](https://github.com/civicrm/civicrm-core/pull/11707))**

  Fixes a fatal error on the Fees section of the View Event Registration Page.

### CiviMail

- **[CRM-21848](https://issues.civicrm.org/jira/browse/CRM-21848) Mailing no
  longer filters out email addresses on hold from recipient group
  ([11846](https://github.com/civicrm/civicrm-core/pull/11846) and
  [11848](https://github.com/civicrm/civicrm-core/pull/11848))**

- **[dev/mail#5](https://lab.civicrm.org/dev/mail/issues/5) "New Mailing"
  prematurely schedules blasts
  ([11904](https://github.com/civicrm/civicrm-core/pull/11904))**

  This resolves a regression in 4.7.31 where previewing a mailing after setting
  the scheduled date and time would end up actually scheduling the mailing.

- **[dev/mail#7](https://lab.civicrm.org/dev/mail/issues/7) On 'New Mailing'
  review page, it doesn't show recipients count
  ([11911](https://github.com/civicrm/civicrm-core/pull/11911))**

- **Ensure consistancy with previous behavior where user emails are first then
  system from emails
  ([11905](https://github.com/civicrm/civicrm-core/pull/11905))**

  This resolves a regression in 4.7.31 where a user's own email would appear
  below system From emails rather than as the first and default option.

- **[dev/mail#6](https://lab.civicrm.org/dev/mail/issues/6) On multilingual
  mode, choosing mailing group doesn't affect recipient count and list
  ([11906](https://github.com/civicrm/civicrm-core/pull/11906))**

### CiviMember

- **[CRM-20421](https://issues.civicrm.org/jira/browse/CRM-20421) Inherited
  memberships are converted to individual memberships when the "parent" for the
  membership is merged with another contact
  ([11154](https://github.com/civicrm/civicrm-core/pull/11154))**

  This change fixes a bug where inherited memberships were being converted to
  individual memberships when the "parent" for the membership was merged with
  another contact so that inherited memberships get removed while merging the
  contact if we chose not to transfer the memberships.

- **CiviMember: use `fa-ban`, proper `crm-i` class for canceled auto-renew
  [11775](https://github.com/civicrm/civicrm-core/pull/11775)**

### Drupal Integration

- **[CRM-21778](https://issues.civicrm.org/jira/browse/CRM-21778) Contact image
  uploaded from drupal webform don't render on summary page
  ([11681](https://github.com/civicrm/civicrm-core/pull/11681))**

   This change fixes a bug where if a contact image was uploaded from a webform,
   it was not displayed on the contact summary page and a notice was thrown so
   that the image loads correctly without any notice errors.

- **[CRM-21795](https://issues.civicrm.org/jira/browse/CRM-21795) Fatal error:
  civicrm/CRM/Utils/System/Drupal.php on line 857
  ([11712](https://github.com/civicrm/civicrm-core/pull/11712))**

  Fixes fatal error - CRM/Utils/System/Drupal.php on line 857 that occurs on
  error.log when navigating thru a Drupal site by adding a "onCiviExit()".

### WordPress Integration

- **[dev/core#21](https://lab.civicrm.org/dev/core/issues/21) Regression:
  Public-facing contribution pages appearance changes on 4.7.31
  ([11827](https://github.com/civicrm/civicrm-core/pull/11827))**

  Reverses formatting change that caused a regression in 4.7.31 for the display
  of contribution pages in wordpress.

## <a name="misc"></a>Miscellany

- **[dev/release/1](https://lab.civicrm.org/dev/release/issues/1) - Change
  numbering to 5.x.x
  ([11704](https://github.com/civicrm/civicrm-core/pull/11704))**

- **[CRM-21720](https://issues.civicrm.org/jira/browse/CRM-21720) Cleanup search
  classes to use enumerators instead of hardcoded values
  ([11600](https://github.com/civicrm/civicrm-core/pull/11600))**

- **Fix html template structure with classes, divs & tags
  ([11796](https://github.com/civicrm/civicrm-core/pull/11796))**

- **[CRM-21739](https://issues.civicrm.org/jira/browse/CRM-21739) Create unit
  test for getRecipients include/exclude recipient groups
  ([11642](https://github.com/civicrm/civicrm-core/pull/11642))**

- **[CRM-21787](https://issues.civicrm.org/jira/browse/CRM-21787) Simplify
  CRM_Utils_System::version() to fetch version directly from xml/version.xml
  ([11700](https://github.com/civicrm/civicrm-core/pull/11700))**

- **(NFC) Update copyright header for 2018
  ([522](https://github.com/civicrm/civicrm-drupal/pull/522))**

- **(NFC) Update copyright header for 2018
  ([124](https://github.com/civicrm/civicrm-wordpress/pull/124))**

- **(NFC) Update copyright header for 2018
  ([45](https://github.com/civicrm/civicrm-joomla/pull/45))**

- **(NFC) Remove redundant line, improve docblocks
  ([11742](https://github.com/civicrm/civicrm-core/pull/11742))**

- **(NFC) remove starting whitespace in ts about installments
  ([11701](https://github.com/civicrm/civicrm-core/pull/11701))**

- **(NFC) Rename fiterable fields param in _civicrm_api3_basic_array_get …
  ([11711](https://github.com/civicrm/civicrm-core/pull/11711))**

- **(NFC) Update copyright header for 2018
  ([11713](https://github.com/civicrm/civicrm-core/pull/11713))**

- **(NFC) MembershipRenewal.php - Fix civilint error
  ([11717](https://github.com/civicrm/civicrm-core/pull/11717))**

- **(NFC) Update `xml/templates/*` headers
  ([11740](https://github.com/civicrm/civicrm-core/pull/11740))**

- **NFC - Minor code cleanup in CKEditorConfig.php
  ([11774](https://github.com/civicrm/civicrm-core/pull/11774))**

- **Remove hacks from CRM_Core_Menu for old unsupported versions
  ([11781](https://github.com/civicrm/civicrm-core/pull/11781))**

- **E-notice fix.
  ([11799](https://github.com/civicrm/civicrm-core/pull/11799))**

- **Update test to NOT accept a failure in the api call.
  ([11798](https://github.com/civicrm/civicrm-core/pull/11798))**

- **Make template structure proper
  ([11788](https://github.com/civicrm/civicrm-core/pull/11788))**

- **Fix template structure
  ([11779](https://github.com/civicrm/civicrm-core/pull/11779))**

- **Move towards standardising website.create function.
  ([11694](https://github.com/civicrm/civicrm-core/pull/11694))**

- **Deduper - Pass arrays rather than strings to construct URLs
  ([11671](https://github.com/civicrm/civicrm-core/pull/11671))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andrew Hunt; Agileware - Alok Patel; Australian Greens - Seamus
Lee; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; CompuCorp -
Mukesh Ram, Omar Abu Hussein, René Olivo, Vinu Varshith Sekar; Coop SymbioTIC -
Samuel Vanhove; Davis Media Access - Darrick Servis; Fuzion - Jitendra Purohit;
Ginkgo Street Labs - Frank Gómez; JMA Consulting - Monish Deb; John Kingsnorth;
Joinery - Allen Shaw; Left Join Labs - Sean Madsen; Lighthouse Design and
Consulting - Brian Shaughnessy; Łukasz Krutul; MJW Consulting - Matthew Wire;
myDropWizard - David Snopek; Oxfam Germany - Thomas Schüttler; Progressive
Technology Project - Jamie McClelland; Systopia - Björn Endres; Tadpole
Collective - Kevin Cristiano; Third Sector Design - Michael McAndrew; Wikimedia
Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Agileware Team; Artful Robot - Rich Lott; Blackfly Solutions - Alan
Dixon; CiviDesk - Nicolas Ganivet; CompuCorp - Jamie Novick; Coop SymbioTIC -
Mathieu Lutfy; Daniël van Vuuren; DevApp - Adam Kwiatkowski; Formatux - Gérard
Ernaelsten; Freeform Solutions - Herb van den Dool; Fuzion - Peter Davis; JMA
Consulting - Joe Murray; Kristine Chan; MC3 - Graham Mitchell; Matthias
Bärnthaler; Megaphone Technology Consulting - Jon Goldberg; Paul Treadaway;
Richard van Oosterhout; Semper IT - Karin Gerritsen

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please login to https://chat.civicrm.org/civicrm
and contact `@agh1`.
