# CiviCRM 5.14.0

Released June 5, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     | **yes** |
| Alter the API?                                                  | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     | **yes** |
| Introduce features?                                             | **yes** |
| Fix bugs?                                                       | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Minimum supported PHP version is 7.0
  ([14437](https://github.com/civicrm/civicrm-core/pull/14437), [14459](https://github.com/civicrm/civicrm-core/pull/14459))**

  CiviCRM now requires PHP 7.0 or higher.  While sites running PHP 5.6 will be
  able to upgrade to CiviCRM 5.14.0, they will see an error message saying it is
  no longer supported.  Upcoming changes to CiviCRM will not be evaluated with
  regard to PHP 5.6 compatibility, and new sites installing CiviCRM must have
  PHP 7.0 or higher.

- **civi.api.prepare - Allow dynamic wrappers (preliminary work for
  [dev/core#873](https://lab.civicrm.org/dev/core/issues/873):
  [14047](https://github.com/civicrm/civicrm-core/pull/14047))**

  This furthers the goal of allowing users to A/B test subject lines in Mosaico
  by allowing extension developers to dynamically wrap an API using a listener
  for the new civi.api.prepare event.

- **Make DAO fields more consistent
  ([14072](https://github.com/civicrm/civicrm-core/pull/14072))**

  This PR makes it so the 'where' field is populated regardless of whether
  import or export is set. The goal of this pull request is to simplify some of
  the metadata based magic by trying to get the meaning of import & export
  closer to the original intent.

- **Hook to alter menubar css variables & fix breakpoint in WP
  ([14135](https://github.com/civicrm/civicrm-core/pull/14135) and
  [14420](https://github.com/civicrm/civicrm-core/pull/14420))**

  A new hook, `hook_civicrm_getAssetUrl()`, allows modifying parameters for a
  semi-static asset like a CSS file that takes certain parameters.  The result
  is that the menu bar is more flexible and configurable, and this fixes a
  couple of issues with it in WordPress at certain widths.

- **Replace jcalendar instances with datepicker (continues
  [dev/core#561](https://lab.civicrm.org/dev/core/issues/561):
  [14150](https://github.com/civicrm/civicrm-core/pull/14150) and
  [14099](https://github.com/civicrm/civicrm-core/pull/14099))**

  The campaign search form and pledge forms now use datepicker instead of the
  deprecated jcalendar for choosing dates.

- **Result filter criteria doesn't show IS NULL/IS NOT NULL for operations
  ([dev/core#865](https://lab.civicrm.org/dev/core/issues/865):
  [14028](https://github.com/civicrm/civicrm-core/pull/14028))**

  Allow users to access to the operations `IS NULL` and `IS NOT NULL` when
  choosing report filters for multiselect fields.

- **Allow url to set IS NULL/ NOT NULL in report for operations
  ([dev/core#876](https://lab.civicrm.org/dev/core/issues/876):
  [14052](https://github.com/civicrm/civicrm-core/pull/14052))**

  Makes it so that the newly added filter options IS NULL/ NOT NULL (added
  above) can be passed via URL.

- **Convert dedupe select to select 2 and remove not-used var
  ([14161](https://github.com/civicrm/civicrm-core/pull/14161))**

  On the Dedupe rules form, the "Field" drop-downs are converted to Select2
  fields.

- **Add function filterLinks to return an array of links for an entity that can
  be used by the API / form layer to generate a link
  ([14112](https://github.com/civicrm/civicrm-core/pull/14112))**

  Adds the function filterLinks (CRM_Core_Action::filterLinks()) which can be
  used to generate link html client-side. This function is currently unused,
  added in preparation for CiviCase link refactoring.

- **Add serialize metadata to tag used_for field
  ([14096](https://github.com/civicrm/civicrm-core/pull/14096))**

  Add schema metadata to the Tag `used_for` field, which is a comma separated
  list.

- **Cron Status Check - Better hyperlinks
  ([14085](https://github.com/civicrm/civicrm-core/pull/14085))**

  Improves the System Status check "Cron Not Running" by including a link to
  most up to date documentation.

- **Add pseudoconstant to UFField dao
  ([14041](https://github.com/civicrm/civicrm-core/pull/14041))**

  Improves the UFField API by exposing the option list for the field
  `fieldname`, before this change it was displayed as a text field instead of a
  select.

- **CQ: Switch core forms to be Entity Forms (continues
  [dev/core#818](https://lab.civicrm.org/dev/core/issues/818):
  [13887](https://github.com/civicrm/civicrm-core/pull/13887))**

  The group settings form now relies upon a standard entity form for the most
  part, with most fields defined by metadata.  This removes boilerplate code
  from the specific form function, standardizing the form and facilitating later
  form improvements that can be made across the board.

### CiviContribute

- **CQ: Refactor Recurring Contribution Forms (continues
  [dev/core#846](https://lab.civicrm.org/dev/core/issues/846):
  [13994](https://github.com/civicrm/civicrm-core/pull/13994) and
  [13993](https://github.com/civicrm/civicrm-core/pull/13993)))**

  This begins the process of converting recurring contribution forms to use
  entity forms.  It standardizes the way in which the payment processor is
  loaded in the 3 forms that update subscriptions.

- **Call Payment.create from Payment.cancel
  ([13689](https://github.com/civicrm/civicrm-core/pull/13689))**

  This change improves the Payment.create API by adding handling for negative
  amounts and moves the Payment.cancel API to use the Payment.create API instead
  of a bespoke function.

- **Switch to using ContributionRecur.cancel API from CancelSubscription form
  ([14033](https://github.com/civicrm/civicrm-core/pull/14033))**

  This change makes it so the CancelSubscription Form uses the
  ContributionRecur.cancel API instead of a bespoke function.

- **Update MasterCard icon to match branding guidelines
  ([14078](https://github.com/civicrm/civicrm-core/pull/14078))**

  Updates the MasterCard icon to match the MasterCard branding guidelines:
  https://brand.mastercard.com/brandcenter/mastercard-brand-mark/downloads.html

### CiviEvent

- **Event Cart: add support for the Credit Card type icons
  ([14175](https://github.com/civicrm/civicrm-core/pull/14175))**

  Adds support for the Credit Card type icons (Amex, visa etc.) to Event Cart
  registration forms.

### Drupal Integration

- **Drupal Views : relationships for standard groups
  ([CRM-20006](https://issues.civicrm.org/jira/browse/CRM-20006):
  [507](https://github.com/civicrm/civicrm-drupal/pull/507))**

  Adds relationships for standard groups to the CiviCRM/Drupal Views
  integration.

- **Enable contribution views to filter on empty Receipt and Thank You dates
  ([573](https://github.com/civicrm/civicrm-drupal/pull/573))**

  Adds a view filter on "Thank You date" and "Receipt Date" for empty/not empty
  which can be used to create a view showing contributions that
  have/have not been thanked.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Email processor filing all emails as .unknown attachments
  ([dev/core#940](https://lab.civicrm.org/dev/core/issues/940):
  [14208](https://github.com/civicrm/civicrm-core/pull/14208))**

  Fixes a regression where emails being sent to the email-to-activity mailbox
  were being saved with a `.unknown` extension and no content.

- **.ics files should be whitelisted as file types for upload
  ([dev/core#974](https://lab.civicrm.org/dev/core/issues/974):
  [14531](https://github.com/civicrm/civicrm-core/pull/14351))**

- **Regression - faster activity tab in 5.13 won't sort by source_name now
  ([dev/core#934](https://lab.civicrm.org/dev/core/issues/934):
  [14194](https://github.com/civicrm/civicrm-core/pull/14194) and
  [14204](https://github.com/civicrm/civicrm-core/pull/14204))**

- **Search displaying Related Contacts produces fatal error
  ([dev/core#1002](https://lab.civicrm.org/dev/core/issues/1002):
  [14409](https://github.com/civicrm/civicrm-core/pull/14409))**

- **Error randomly appearing when Financial type ACL is enabled
  ([dev/core#918](https://lab.civicrm.org/dev/core/issues/918):
  [14165](https://github.com/civicrm/civicrm-core/pull/14165) and
  [14168](https://github.com/civicrm/civicrm-core/pull/14168))**

  Fixes an undefined index error `Undefined index: status in
  CRM_Utils_Check_Component_FinancialTypeAcls::checkFinancialAclReport()` when a
  site has a Financial Type ACL enabled.

- **utf8mb4 warning keeps coming back up
  ([dev/core#880](https://lab.civicrm.org/dev/core/issues/880):
  [14123](https://github.com/civicrm/civicrm-core/pull/14123))**

  This change makes it so users only receive the Mysql utf8mb4 status check
  once, before this change the status check would show up whenever apache was
  restarted.

- **Fix import primary phone, primary email, add tests
  ([14043](https://github.com/civicrm/civicrm-core/pull/14043))**

  Fixes a bug where importing a phone (or email) & choosing 'Primary' as the
  location type resulted in the creation of a duplicate, sometimes with no
  location type.

- **Fix upgrade message db setting location
  ([14083](https://github.com/civicrm/civicrm-core/pull/14083))**

  Updates the upgrade message "This database uses InnoDB Full Text Search for
  optimized searching. The upgrade procedure has not been tested with this
  feature. You should disable (and later re-enable) the feature by navigating
  to..." to point to the right settings form "Administer => Customize Data and
  Screens => Search Preferences" instead of "Administer => System Settings =>
  Miscellaneous".

- **Fix getAddressColumns() to respect tableAlias
  ([14014](https://github.com/civicrm/civicrm-core/pull/14014))**

  Fixes `CRM_Report_Form::getAddressColumns()` function so that it no longer
  returns an error when used twice.

- **Ensure edit tooltip is always initially hidden in contact summary block
  ([14065](https://github.com/civicrm/civicrm-core/pull/14065))**

  Ensures when a user does not have permission to edit a contact summary block,
  the little "Edit" tooltip is hidden.

- **Skip adding core resources when building assets
  ([14010](https://github.com/civicrm/civicrm-core/pull/14010))**

- **Advanced Search - Mailing column headers out of alignment
  ([dev/core#248](https://lab.civicrm.org/dev/core/issues/248):
  [14134](https://github.com/civicrm/civicrm-core/pull/14134))**

- **Validate queue_id is a positive integer before passing to the BAO
  ([14355](https://github.com/civicrm/civicrm-core/pull/14355))**

-  **Fixes issue where contact's display name did not show on membership edit
   If there was no registered email address
   ([dev/core#1000](https://lab.civicrm.org/dev/core/issues/1000):
   [14438](https://github.com/civicrm/civicrm-core/pull/14438))**

### CiviCase

- **Case activity query performs poorly on large databases
  ([dev/core#832](https://lab.civicrm.org/dev/core/issues/832):
  [14086](https://github.com/civicrm/civicrm-core/pull/14086) and
  [14139](https://github.com/civicrm/civicrm-core/pull/14139))**

  This change enhances performance of CiviCase by streamlining the Case Activity
  Query which was crashing the server for some sites with large databases by
  producing too many temporary files.

- **Make `hook_civicrm_pre()` and `hook_civicrm_post()` fire on CaseContacts
  ([14030](https://github.com/civicrm/civicrm-core/pull/14030))**

### CiviContribute

- **Always bootstrap CRM_Utils_System on legacy IPN endpoint
  ([dev/drupal#66](https://lab.civicrm.org/dev/drupal/issues/66),
  [dev/core#973](https://lab.civicrm.org/dev/core/issues/973), and
  [dev/core#1017](https://lab.civicrm.org/dev/core/issues/1017):
  [14406](https://github.com/civicrm/civicrm-core/pull/14406) and
  [14430](https://github.com/civicrm/civicrm-core/pull/14430))**

  This fixes a recent regression where recurring payments would fail to be
  recorded in CiviCRM if the contribution was set to notify the legacy IPN URL.

- **Fix checksum failure when editing recuring contributions
  ([14407](https://github.com/civicrm/civicrm-core/pull/14407))**

  Fixes a fatal error where checksum users were not able to cancel or update
  recurring contributions.

- **Fix error when exporting soft credits ([dev/core#1015](https://lab.civicrm.org/dev/core/issues/1015): [14453](https://github.com/civicrm/civicrm-core/pull/14453))**

### CiviEvent

- **Event Cart: Pass the contactID to fix payment on Stripe
  ([14173](https://github.com/civicrm/civicrm-core/pull/14173))**

  Fixes a bug where a user could not complete an Event Registration using Event
  Cart and the Stripe payment processor.

- **Event Cart: Fix sending of email receipts
  ([14170](https://github.com/civicrm/civicrm-core/pull/14170))**

  Fixes fatal error being thrown when an email receipt was sent from an Event
  Cart registration.

- **Event Cart: Honor the allow_same_participant_emails setting
  ([14174](https://github.com/civicrm/civicrm-core/pull/14174))**

  Ensures the Event Cart Checkout process honors the "allow participants with
  the same email address".

- **Event Cart: Fix start_date formatting in line items during checkout
  ([14169](https://github.com/civicrm/civicrm-core/pull/14169))**

  Ensures start dates are formatted according to the site's localization
  preference during the Event Cart checkout process.

- **When creating a new event using a template, the new event screen is
  taking the default values directly from the custom fields, and not from what's
  saved in the event template.
  ([CRM-18570](https://issues.civicrm.org/jira/browse/CRM-18570), [dev/core#553](https://lab.civicrm.org/dev/core/issues/553):
  [14063](https://github.com/civicrm/civicrm-core/pull/14063))**

### CiviMail

- **Fixed double protocol being added in link by CKEditor.
  ([14128](https://github.com/civicrm/civicrm-core/pull/14128))**

  Fixes a bug where adding action tokens using the CKEditor link interface, and
  then editing them could cause double protocols (ex: http://https:// or
  http://http://).

- **Fix ts() usage in CRM_SMS_Form_Schedule
  ([14111](https://github.com/civicrm/civicrm-core/pull/14111))**

  Allows translation of the "Send Mass SMS" form.

### CiviMember

- **Batch update membership type
  ([dev/core#338](https://lab.civicrm.org/dev/core/issues/338):
  [14064](https://github.com/civicrm/civicrm-core/pull/14064))**

  Fixes a regression when batch updating membership types and copying values
  down the column.

- **Membership status processor ignoring records where is_override=0
  ([dev/core#881](https://lab.civicrm.org/dev/core/issues/881):
  [14059](https://github.com/civicrm/civicrm-core/pull/14059) and
  [14073](https://github.com/civicrm/civicrm-core/pull/14073))**

- **Back-office membership renewals don't display an on-screen notification
  ([dev/membership#9](https://lab.civicrm.org/dev/membership/issues/9):
  [14088](https://github.com/civicrm/civicrm-core/pull/14088))**

- **Fix test / possible live error on submitting credit card renewals
  ([14412](https://github.com/civicrm/civicrm-core/pull/14412))**

  This resolves intermittent errors in unit tests when renewing memberships due
  to the `receive_date` not being set.

- **Fixed auto populate of contact reference field on membership signup form
  ([14077](https://github.com/civicrm/civicrm-core/pull/14077))**

### Drupal Integration

- **Civi 5.12.1 renders Quicksearch unreadable on Drupal 8
  ([dev/drupal#56](https://lab.civicrm.org/dev/drupal/issues/56):
  [14080](https://github.com/civicrm/civicrm-core/pull/14080))**

  Fixes a regression where the text in the Quicksearch box was too light to read
  so that it is darker and easier to read.

- **Don't render an empty mailto link for empty email addresses
  ([540](https://github.com/civicrm/civicrm-drupal/pull/540))**

  Fixes a bug in Views where an "email address" field set to output as a
  `mailto:` link would still make a link if no email exists.

- **Column next_sched_contribution should be next_sched_contribution_date for
  Views integration
  ([dev/drupal#48](https://lab.civicrm.org/dev/drupal/issues/48):
  [578](https://github.com/civicrm/civicrm-drupal/pull/578))**

### Joomla Integration

- **Fix bug preventing affecting `cv --user` on Joomla
  ([13890](https://github.com/civicrm/civicrm-core/pull/13890))**

## <a name="misc"></a>Miscellany

- **Bump PHP version to match core requirements
  ([567](https://github.com/civicrm/civicrm-drupal/pull/567))**

- **CiviUnitTestCase - Extract traits to facilitate extension testing
  (preliminary work for
  [dev/core#873](https://lab.civicrm.org/dev/core/issues/873):
  [14044](https://github.com/civicrm/civicrm-core/pull/14044))**

- **Refactor dedupe merger (preliminary work for
  [dev/core#723](https://lab.civicrm.org/dev/core/issues/723):
  [14144](https://github.com/civicrm/civicrm-core/pull/14144) and
  [14146](https://github.com/civicrm/civicrm-core/pull/14146))**

- **Replace all instances of CRM_Core_Fatal with throw new CRM_Core_Exception
  (continues [dev/core#560](https://lab.civicrm.org/dev/core/issues/560):
  [14143](https://github.com/civicrm/civicrm-core/pull/14143))**

- **(Partial) Towards fixing E2E_Core_AssetBuilderTest on WordPress
  ([14212](https://github.com/civicrm/civicrm-core/pull/14212/),
  [14201](https://github.com/civicrm/civicrm-core/pull/14201))**

- **(REF) Add unit tests on contribution recur trxn_id, contribution recur
  processor id (preparation for
  [dev/core#830](https://lab.civicrm.org/dev/core/issues/830):
  [14119](https://github.com/civicrm/civicrm-core/pull/14119))**

- **Remove instances of $dao->free (continues
  [dev/core#562](https://lab.civicrm.org/dev/core/issues/562):
  [14070](https://github.com/civicrm/civicrm-core/pull/14070),
  [14071](https://github.com/civicrm/civicrm-core/pull/14071) and
  [14037](https://github.com/civicrm/civicrm-core/pull/14037))**

- **(NFC) Add tests of retreiving notes for display on a contact record a…
  ([14094](https://github.com/civicrm/civicrm-core/pull/14094))**

- **(NFC) Update CRM/Contact to match new coder style
  ([14022](https://github.com/civicrm/civicrm-core/pull/14022))**

- **(NFC) Minor code style fixes
  ([14015](https://github.com/civicrm/civicrm-core/pull/14015))**

- **(NFC) Add in unit test checking that E2E test returns sensible contac…
  ([14076](https://github.com/civicrm/civicrm-core/pull/14076))**

- **(NFC) Whitespace formatting for formButtons.tpl
  ([14107](https://github.com/civicrm/civicrm-core/pull/14107))**

- **(NFC) Expand unit test to show off double protocol error
  ([14141](https://github.com/civicrm/civicrm-core/pull/14141))**

- **(REF) Move gathering of location info to relevant function (towards
  dev/core#723) ([14142](https://github.com/civicrm/civicrm-core/pull/14142))**

- **(REF) Move the qfbug handling to it's own function (towards dev/core#723)
  ([14140](https://github.com/civicrm/civicrm-core/pull/14140))**

- **(REF) Use events for CMS resource loading
  ([14131](https://github.com/civicrm/civicrm-core/pull/14131))**

- **(REF) Extract getConflicts function
  ([14148](https://github.com/civicrm/civicrm-core/pull/14148))**

- **(REF) Extract get cfields function
  ([14151](https://github.com/civicrm/civicrm-core/pull/14151))**

- **(REF) Use variable for menubar height
  ([14122](https://github.com/civicrm/civicrm-core/pull/14122))**

- **(REF) Clean up CRM_Contribute_Form_SearchTest
  ([14068](https://github.com/civicrm/civicrm-core/pull/14068))**

- **(REF) Extract formatLocationBlock from import parsing
  ([14040](https://github.com/civicrm/civicrm-core/pull/14040))**

- **(REF) Function extraction in dedupe code
  ([14157](https://github.com/civicrm/civicrm-core/pull/14157))**

- **(REF) cleanup input parameters on extracted function
  ([14050](https://github.com/civicrm/civicrm-core/pull/14050))**

- **(REF) Fix accepted params in CustomValueTable::setValues
  ([14079](https://github.com/civicrm/civicrm-core/pull/14079))**

- **(REF) Fix unnecessary required param in contact BAO update
  ([14075](https://github.com/civicrm/civicrm-core/pull/14075))**

- **(REF) Reduce redundant code in CRM_Utils_Type::validate
  ([14011](https://github.com/civicrm/civicrm-core/pull/14011))**

- **(REF) Replace hardcoded IDs with pseudoconstants in activity form
  ([14108](https://github.com/civicrm/civicrm-core/pull/14108))**

- **(REF) Standardize UFField create function
  ([14084](https://github.com/civicrm/civicrm-core/pull/14084))**

- **(REF) Call formatLocationBlock from parent function.
  ([14105](https://github.com/civicrm/civicrm-core/pull/14105))**

- **(REF; dev/core#873) MailingAB - Migrate "copy winner" logic from JS to PHP
  ([14045](https://github.com/civicrm/civicrm-core/pull/14045))**

- **(REF) Don't pass activity object to addCaseActivityLinks
  ([14110](https://github.com/civicrm/civicrm-core/pull/14110))**

- **(REF) Use shared function to check inbound email permissions
  ([14109](https://github.com/civicrm/civicrm-core/pull/14109))**

- **(REF) Follow up tidy up on import fixes
  ([14117](https://github.com/civicrm/civicrm-core/pull/14117))**

- **Readability cleanup on EventIncome report (towards bringing it under
  testing) ([13963](https://github.com/civicrm/civicrm-core/pull/13963))**

- **Remove deprecated function
  ([14039](https://github.com/civicrm/civicrm-core/pull/14039))**

- **Revert "dev/core#553: Creating new event takes value from default value not
  from saved template for custom fields"
  ([14121](https://github.com/civicrm/civicrm-core/pull/14121))**

- **Update docblock for doPayment function
  ([13844](https://github.com/civicrm/civicrm-core/pull/13844))**

- **(Cleanup) Remove CRM_Report_Form_Extended
  ([14149](https://github.com/civicrm/civicrm-core/pull/14149))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; Agileware - Alok Patel; Australian
Greens - Seamus Lee; Christian Wach; CiviCRM - Coleman Watts, Tim Otten;
CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy; Dave D; Electronic
Frontier Foundation - Mark Burdett; Freeform Solutions - Herb van den Dool;
Fuzion - Luke Stewart; Guillaume Rischard; JMA Consulting - Monish Deb; John
Kingsnorth; Korlon - Stuart Gaston; Lighthouse Design and Consulting - Brian
Shaughnessy; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting -
Matthew Wire; Pradeep Nayak; Squiffle Consulting - Aidan Saunders; Tadpole
Collective - Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Tommy Bobo; DevApp - Adam Kwiatkowski; Fuzion - Jitendra
Purohit; JMA Consulting - Joe Murray; Nicol Wistreich; Palante - Morgan
Robinson; Skvare - Mark Hanna; Tapash Datta

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
