      SUBROUTINE GFUNP(N,IDEG,PDG,QDG,X,
     $ XDGM1,XDG,PXDGM1,PXDG,G,DG)
C
C GFUNP  EVALUATES THE START EQUATION "G".
C
C ON INPUT:
C
C N  IS THE NUMBER OF VARIABLES.
C
C IDEG(J)  IS THE DEGREE OF THE J-TH EQUATION.
C
C PDG(1,J), PDG(2,J)  ARE THE REAL AND IMAGINARY PARTS
C   OF THE POWERS OF P USED TO DEFINE G.
C
C QDG(1,J), QDG(2,J)  ARE THE REAL AND IMAGINARY PARTS
C   OF THE POWERS OF Q USED TO DEFINE G.
C
C X(1,J), X(2,J)  ARE THE REAL AND IMAGINARY PARTS OF THE
C   J-TH INDEPENDENT VARIABLE.
C
C XDGM1,XDG,PXDGM1,PXDG ARE WORKSPACE ARRAYS.
C
C ON OUTPUT:
C
C N,IDEG,PDG,QDG, AND X  ARE UNCHANGED.
C
C G(1,J),G(2,J)  ARE THE REAL AND IMAGINARY PARTS OF THE
C   J-TH START EQUATION.
C
C DG(1,J),DG(2,J)  ARE THE REAL AND IMAGINARY PARTS OF THE
C   PARTIAL DERIVATIVES OF THE J-TH START EQUATION WITH RESPECT TO THE
C   J-TH INDEPENDENT VARIABLE.
C
C SUBROUTINE:  MULP.
C
C DECLARATION OF INPUT AND OUTPUT:
      INTEGER N,IDEG
      DOUBLE PRECISION PDG,QDG,X,XDGM1,XDG,PXDGM1,PXDG,G,DG
      DIMENSION IDEG(N),PDG(2,N),QDG(2,N),X(2,N),
     $  XDGM1(2,N),XDG(2,N),PXDGM1(2,N),PXDG(2,N),
     $  G(2,N),DG(2,N)
C
C DECLARATION OF VARIABLES
      INTEGER I,J
C
C COMPUTE THE (IDEG-1)-TH AND IDEG-TH POWER OF X
      DO 5 J=1,N
        CALL POWP(IDEG(J)-1,X(1,J), XDGM1(1,J))
        CALL MULP(X(1,J),XDGM1(1,J), XDG(1,J))
  5   CONTINUE
C
C COMPUTE THE PRODUCT OF PDG AND XDGM1
      DO 10 J=1,N
          CALL MULP( PDG(1,J), XDGM1(1,J), PXDGM1(1,J) )
  10  CONTINUE
C
C COMPUTE THE PRODUCT OF PDG AND XDG
      DO 20 J=1,N
          CALL MULP( PDG(1,J), XDG(1,J), PXDG(1,J) )
  20  CONTINUE
      DO 30 J=1,N
      DO 30 I=1,2
          G(I,J)=PXDG(I,J) - QDG(I,J)
          DG(I,J)= IDEG(J)*PXDGM1(I,J)
  30  CONTINUE
      RETURN
      END
