      SUBROUTINE POWP(NNNN,XXXX,YYYY)
C
C THIS SUBROUTINE TAKES A NON-NEGATIVE POWER OF A COMPLEX NUMBER:
C YYYY = XXXX**NNNN USING DE MOIVRE'S FORMULA:
C
C     YYYY = R**NNNN * (COS(NNNN*THETA),SIN(NNNN*THETA)),
C
C WHERE R=DNRM2(2,XXXX,1) AND THETA=ATAN2(XXXX(2),XXXX(1)).
C
C NOTE: POWP SETS 0**0 EQUAL TO 1.
C
C ON INPUT:
C
C NNNN  IS A NON-NEGATIVE INTEGER.
C
C XXXX  IS AN ARRAY OF LENGTH TWO REPRESENTING A COMPLEX
C       NUMBER, WHERE XXXX(1) = REAL PART OF XXXX AND XXXX(2) =
C       IMAGINARY PART OF XXXX.
C
C ON OUTPUT:
C
C YYYY  IS AN ARRAY OF LENGTH TWO REPRESENTING THE RESULT OF
C       THE POWER, YYYY = XXXX**NNNN, WHERE YYYY(1) =
C       REAL PART OF YYYY AND YYYY(2) = IMAGINARY PART OF YYYY.
C
C SUBROUTINES: COS, SIN, ATAN2, DNRM2
C
C DECLARATION OF INPUT
      INTEGER NNNN
      DOUBLE PRECISION XXXX
      DIMENSION XXXX(2)
C
C DECLARATION OF OUTPUT
      DOUBLE PRECISION YYYY
      DIMENSION YYYY(2)
C
C DECLARATION OF VARIABLES
      DOUBLE PRECISION R,RR,T,TT
C
C DECLARATION OF FUNCTIONS
      DOUBLE PRECISION  DNRM2
C
      IF (NNNN .EQ. 0) THEN
          YYYY(1)=1.
          YYYY(2)=0.
          RETURN
      ENDIF
      IF (NNNN .EQ. 1) THEN
          YYYY(1)=XXXX(1)
          YYYY(2)=XXXX(2)
          RETURN
      ENDIF
      R = DNRM2(2,XXXX,1)
      IF (R .EQ. 0.0) THEN
          YYYY(1)=0.0
          YYYY(2)=0.0
          RETURN
      END IF
      RR= R**NNNN
      T = ATAN2(XXXX(2),XXXX(1))
      TT= NNNN*T
      YYYY(1) = RR*COS(TT)
      YYYY(2) = RR*SIN(TT)
      RETURN
      END
