(in-package :common-lisp-user)

(defpackage "APP"
  (:use :clim :clim-lisp)
  (:export "APP-MAIN"))

(in-package :app)

(define-application-frame superapp ()
  ()
  (:pointer-documentation t)
  (:panes
    (app :application :height 600 :width 600)
    (int :interactor :height 200 :width 600))
  (:layouts
    (default (vertically () app int))))

(defun app-main ()
  (run-frame-top-level (make-application-frame 'superapp)))

(define-superapp-command com-quit ()
  (frame-exit *application-frame*))

(define-superapp-command com-parity ((number 'integer))
  (format t "~a is ~a~%" number
	  (if (oddp number)
	      "odd"
	      "even")))
