;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10 -*-
;;;; *************************************************************************
;;;; FILE IDENTIFICATION
;;;;
;;;; Name:     clsql.asd
;;;; Purpose:  System definition for CLSQL-CLASSIC
;;;; Authors:  Marcus Pearce and Kevin M. Rosenberg
;;;; Created:  March 2004
;;;;
;;;; $Id: clsql.asd 10612 2005-07-06 00:50:20Z kevin $
;;;;
;;;; CLSQL users are granted the rights to distribute and use this software
;;;; as governed by the terms of the Lisp Lesser GNU Public License
;;;; (http://opensource.franz.com/preamble.html), also known as the LLGPL.
;;;; *************************************************************************

(in-package #:cl-user)
(defpackage #:clsql-system (:use #:asdf #:cl))
(in-package #:clsql-system)

(defsystem clsql
    :name "CLSQL"
    :author "Kevin Rosenberg <kevin@rosenberg.net>"
    :maintainer "Kevin M. Rosenberg <kmr@debian.org>"
    :licence "Lessor Lisp General Public License"
    :description "Common Lisp SQL Interface library"
    :long-description "A Common Lisp interface to SQL RDBMS based on
the Xanalys CommonSQL interface for Lispworks. It depends on the
low-level database interfaces as well as a functional and an object
oriented interface."
    :components
    ((:module sql
	      :components
	      ((:module base
			:pathname ""
			:components
			((:file "cmucl-compat")
			 (:file "package")
			 (:file "kmr-mop" :depends-on ("package"))
			 (:file "base-classes" :depends-on ("package"))
                         (:file "conditions" :depends-on ("base-classes"))
                         (:file "db-interface" :depends-on ("conditions"))
			 (:file "time" :depends-on ("package" "conditions"))
			 (:file "utils" :depends-on ("package" "db-interface"))
                         (:file "generics" :depends-on ("package"))))
               (:module database
                        :pathname ""
                        :components
                        ((:file "initialize")
			 (:file "database" :depends-on ("initialize"))
			 (:file "recording" :depends-on ("database"))
			 (:file "pool"))
                        :depends-on (base))
	       (:module syntax
			:pathname ""
			:components ((:file "expressions")
				     (:file "operations"
                                            :depends-on ("expressions"))
				     (:file "syntax" :depends-on ("operations")))
			:depends-on (database))
	       (:module functional
			:pathname ""
			:components ((:file "fdml")
                                     (:file "transaction" :depends-on ("fdml"))
                                     (:file "loop-extension"
                                            :depends-on ("fdml"))
				     (:file "fddl" :depends-on ("fdml")))
			:depends-on (syntax))
	       (:module object
			:pathname ""
			:components ((:file "metaclasses")
				     (:file "ooddl" :depends-on ("metaclasses"))
				     (:file "oodml" :depends-on ("ooddl")))
			:depends-on (functional))
	       (:module generic
			:pathname ""
			:components ((:file "generic-postgresql")
				     (:file "generic-odbc")
				     (:file "sequences"))
			:depends-on (functional))))))


(defmethod perform ((o test-op) (c (eql (find-system 'clsql))))
  (operate 'load-op 'clsql-tests)
  (operate 'test-op 'clsql-tests :force t))

(defmethod perform :after ((o load-op) (c (eql (find-system 'clsql))))
  (when (probe-file "/etc/clsql-init.lisp")
    (load "/etc/clsql-init.lisp")))

