# Packaged by Dave M for fedora extras compatibility.
# This is Dag's clamtk spec file.

%{?dist: %{expand: %%define %dist 1}}

%{?rh7:%define _without_freedesktop 1}
%{?el2:%define _without_freedesktop 1}

%define desktop_vendor misc

Summary: Easy to use front-end for ClamAV
Name: clamtk
Version: 2.06
Release: 1.fc4
License: Artistic
Group: Applications/File
URL: http://clamtk.sourceforge.net/

Packager: Dave M

Source: http://dl.sf.net/clamtk/clamtk-2.06.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

%{!?_without_freedesktop:BuildRequires: desktop-file-utils}
Requires: perl-Gtk2, perl-File-Find-Rule, perl-Date-Calc, perl-libwww-perl
Requires: clamav >= 0.83, clamav-data, clamav-update

%description
ClamTk is a frontend for ClamAV on Fedora Core systems.
It is meant to be lightweight and easy to use.

%prep
%setup -q

%{__cat} <<EOF >clamtk.desktop
[Desktop Entry]
Name=ClamTk Virus Scanner
Comment=Scan your system for viruses.
Exec=clamtk
Icon=clam.xpm
Terminal=false
Type=Application
Categories=Application;Utility;
StartupNotify=false
EOF

%build

%install
%{__rm} -rf %{buildroot}
%{__install} -Dp -m0755 clamtk %{buildroot}%{_bindir}/clamtk
%{__install} -Dp -m0644 clam.xpm %{buildroot}%{_datadir}/pixmaps/clam.xpm

%if %{?_without_freedesktop:1}0
	%{__install} -Dp -m0644 clamtk.desktop %{buildroot}%{_datadir}/gnome/apps/Utilities/clamtk.desktop
%else 
	%{__install} -d -m0755 %{buildroot}%{_datadir}/applications/
	desktop-file-install --delete-original \
		--vendor %{desktop_vendor}                 \
		--dir %{buildroot}%{_datadir}/applications \
		--add-category X-Red-Hat-Base              \
		clamtk.desktop
%endif

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-, root, root, 0755)
%doc CHANGES DISCLAIMER LICENSE README clamtk.pl clamtk
%{_bindir}/clamtk
%{!?_without_freedesktop:%{_datadir}/applications/%{desktop_vendor}-clamtk.desktop}
%{?_without_freedesktop:%{_datadir}/gnome/apps/Utilities/clamtk.desktop}
%{_datadir}/pixmaps/clam.xpm

%changelog
* Sun Aug 28 2005 Dave M. <dave.nerd@gmail.com> - 2.06-1
- Updated to release 2.06.

* Sat Aug 20 2005 Dave M. <dave.nerd@gmail.com> - 2.05-1
- Updated to release 2.05.
- Changed license from Perl to Artistic.

* Sun Jul 17 2005 Dave M. <dave.nerd@gmail.com> - 2.04-1
- Updated to release 2.04.

* Sat Jul 09 2005 Dave M. <dave.nerd@gmail.com> - 2.03-1
- Updated to release 2.03.

* Sat Jul 02 2005 Dave M. <dave.nerd@gmail.com> - 2.02-1
- Updated to release 2.02.

* Sat Jun 25 2005 Dave M. <dave.nerd@gmail.com> - 2.01-1
- Changed dependencies to fit Fedora Extras different naming scheme.
- Updated to release 2.01.

* Sat Jun 11 2005 Dave M. <dave.nerd@gmail.com> - 2.00-1
- Updated to release 2.00.

* Wed May 18 2005 Dave M. <dave.nerd@gmail.com> - 1.99-1
- Updated to release 1.99.

* Sun May 08 2005 Dave M. <dave.nerd@gmail.com> - 1.98-1
- Updated to release 1.98.

* Thu May 05 2005 Dag Wieers <dag@wieers.com> - 1.97-1 - 3063+/dag
- Updated to release 1.97.
- Added changes from Dave M.

* Wed Mar 30 2005 Dag Wieers <dag@wieers.com> - 1.0.10-1
- Initial package. (using DAR)
