/*
  Copyright (C) 1999-2002 Ricardo Ueda Karpischek

  This is free software; you can redistribute it and/or modify
  it under the terms of the version 2 of the GNU General Public
  License as published by the Free Software Foundation.

  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this software; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
  USA.
*/

/*

alphabet.c: Alphabet stuff

*/

#include "common.h"

/* size of each alphabet */
int latin_sz,
    greek_sz,
    cyrillic_sz,
    hebrew_sz,
    arabic_sz,
    kana_sz,
    max_sz,
    number_sz,
    alpha_sz,
    alpha_cols;

/*

Per-alphabet alignments.

*/
int l_align[256];
int g_align[256];
int n_align[256];

/*

Latin to Greek keyboard mapping.

*/
char *l2g[256];

/*

Alphabet button inverse mapping.

*/
char inv_balpha[MAX_ALPHA];

/* current alphabet */
alpharec *alpha;

/*

Latin Alphabet

*/
alpharec latin[] = {

{
    "A",
    "a",
    65,
    {0x00,0x00,0x00,0x00,0x18,0x24,0x24,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x00,0x00},
    97,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x02,0x3e,0x42,0x42,0x46,0x3a,0x00,0x00},
    0,
    0,
    'A',
    0
},

{
    "B",
    "b",
    66,
    {0x00,0x00,0x00,0x00,0x7c,0x42,0x42,0x42,0x7c,0x42,0x42,0x42,0x42,0x7c,0x00,0x00},
    98,
    {0x00,0x00,0x00,0x40,0x40,0x40,0x5c,0x62,0x42,0x42,0x42,0x42,0x62,0x5c,0x00,0x00},
    0,
    0,
    'B',
    0
},

{
    "C",
    "c",
    67,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x40,0x40,0x40,0x40,0x42,0x42,0x3c,0x00,0x00},
    99,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x40,0x40,0x40,0x40,0x42,0x3c,0x00,0x00},
    0,
    0,
    'C',
    0
},

{
    "D",
    "d",
    68,
    {0x00,0x00,0x00,0x00,0x78,0x44,0x42,0x42,0x42,0x42,0x42,0x42,0x44,0x78,0x00,0x00},
    100,
    {0x00,0x00,0x00,0x02,0x02,0x02,0x3a,0x46,0x42,0x42,0x42,0x42,0x46,0x3a,0x00,0x00},
    0,
    0,
    'D',
    0
},

{
    "E",
    "e",
    69,
    {0x00,0x00,0x00,0x00,0x7e,0x40,0x40,0x40,0x7c,0x40,0x40,0x40,0x40,0x7e,0x00,0x00},
    101,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x7e,0x40,0x40,0x42,0x3c,0x00,0x00},
    0,
    0,
    'E',
    0
},

{
    "F",
    "f",
    70,
    {0x00,0x00,0x00,0x00,0x7e,0x40,0x40,0x40,0x7c,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    102,
    {0x00,0x00,0x00,0x0c,0x10,0x10,0x10,0x7c,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00},
    0,
    0,
    'F',
    0
},

{
    "G",
    "g",
    71,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x40,0x40,0x4e,0x42,0x42,0x46,0x3a,0x00,0x00},
    103,
    {0x00,0x00,0x00,0x00,0x00,0x02,0x3a,0x44,0x44,0x44,0x38,0x20,0x3c,0x42,0x42,0x3c},
    0,
    0,
    'G',
    0
},

{
    "H",
    "h",
    72,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x42,0x00,0x00},
    104,
    {0x00,0x00,0x00,0x40,0x40,0x40,0x5c,0x62,0x42,0x42,0x42,0x42,0x42,0x42,0x00,0x00},
    0,
    0,
    'H',
    0
},

{
    "I",
    "i",
    73,
    {0x00,0x00,0x00,0x00,0x3e,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00},
    105,
    {0x00,0x00,0x00,0x08,0x08,0x00,0x18,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00},
    0,
    0,
    'I',
    0
},

{
    "J",
    "j",
    74,
    {0x00,0x00,0x00,0x00,0x1f,0x04,0x04,0x04,0x04,0x04,0x04,0x44,0x44,0x38,0x00,0x00},
    106,
    {0x00,0x00,0x00,0x04,0x04,0x00,0x0c,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x48,0x30},
    0,
    0,
    'J',
    0
},

{
    "K",
    "k",
    75,
    {0x00,0x00,0x00,0x00,0x42,0x44,0x48,0x50,0x60,0x60,0x50,0x48,0x44,0x42,0x00,0x00},
    107,
    {0x00,0x00,0x00,0x00,0x40,0x40,0x44,0x48,0x50,0x60,0x50,0x48,0x44,0x42,0x00,0x00},
    0,
    0,
    'K',
    0
},

{
    "L",
    "l",
    76,
    {0x00,0x00,0x00,0x00,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x7e,0x00,0x00},
    108,
    {0x00,0x00,0x00,0x00,0x18,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00},
    0,
    0,
    'L',
    0
},

{
    "M",
    "m",
    77,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x66,0x66,0x5a,0x5a,0x42,0x42,0x42,0x42,0x00,0x00},
    109,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x00,0x00},
    0,
    0,
    'M',
    0
},

{
    "N",
    "n",
    78,
    {0x00,0x00,0x00,0x00,0x42,0x62,0x62,0x52,0x52,0x4a,0x4a,0x46,0x46,0x42,0x00,0x00},
    110,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x5c,0x62,0x42,0x42,0x42,0x42,0x42,0x42,0x00,0x00},
    0,
    0,
    'N',
    0
},

{
    "O",
    "o",
    79,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    111,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    0,
    0,
    'O',
    0
},

{
    "P",
    "p",
    80,
    {0x00,0x00,0x00,0x00,0x7c,0x42,0x42,0x42,0x7c,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    112,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x5c,0x62,0x42,0x42,0x42,0x42,0x62,0x5c,0x40,0x40},
    0,
    0,
    'P',
    0
},

{
    "Q",
    "q",
    81,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x5a,0x66,0x3c,0x03,0x00},
    113,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3a,0x46,0x42,0x42,0x42,0x42,0x46,0x3a,0x02,0x02},
    0,
    0,
    'Q',
    0
},

{
    "R",
    "r",
    82,
    {0x00,0x00,0x00,0x00,0x7c,0x42,0x42,0x42,0x7c,0x48,0x44,0x44,0x42,0x42,0x00,0x00},
    114,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x5c,0x62,0x42,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    0,
    0,
    'R',
    0
},

{
    "S",
    "s",
    83,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x40,0x30,0x0c,0x02,0x42,0x42,0x3c,0x00,0x00},
    115,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x40,0x30,0x0c,0x02,0x42,0x3c,0x00,0x00},
    0,
    0,
    'S',
    0
},

{
    "T",
    "t",
    84,
    {0x00,0x00,0x00,0x00,0x7f,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    116,
    {0x00,0x00,0x00,0x00,0x10,0x10,0x7c,0x10,0x10,0x10,0x10,0x10,0x10,0x0c,0x00,0x00},
    0,
    0,
    'T',
    0
},

{
    "U",
    "u",
    85,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    117,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x46,0x3a,0x00,0x00},
    0,
    0,
    'U',
    0
},

{
    "V",
    "v",
    86,
    {0x00,0x00,0x00,0x00,0x41,0x41,0x41,0x22,0x22,0x22,0x14,0x14,0x08,0x08,0x00,0x00},
    118,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x24,0x24,0x24,0x18,0x18,0x00,0x00},
    0,
    0,
    'V',
    0
},

{
    "W",
    "w",
    87,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x5a,0x5a,0x66,0x66,0x42,0x42,0x00,0x00},
    119,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x49,0x49,0x49,0x49,0x49,0x49,0x36,0x00,0x00},
    0,
    0,
    'W',
    0
},

{
    "X",
    "x",
    88,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x24,0x24,0x18,0x18,0x24,0x24,0x42,0x42,0x00,0x00},
    120,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x24,0x18,0x18,0x24,0x42,0x42,0x00,0x00},
    0,
    0,
    'X',
    0
},

{
    "Y",
    "y",
    89,
    {0x00,0x00,0x00,0x00,0x41,0x41,0x22,0x22,0x14,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    121,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x26,0x1a,0x02,0x02,0x3c},
    0,
    0,
    'Y',
    0
},

{
    "Z",
    "z",
    90,
    {0x00,0x00,0x00,0x00,0x7e,0x02,0x02,0x04,0x08,0x10,0x20,0x40,0x40,0x7e,0x00,0x00},
    122,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x02,0x04,0x08,0x10,0x20,0x40,0x7e,0x00,0x00},
    0,
    0,
    'Z',
    0
},

/* sentinel */
{
    NULL,
    NULL,
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    ' ',
    0
}

};

/*

Greek Alphabet

*/
alpharec greek[] = {

{
    "Alpha",
    "alpha",
    193,
    {0x00,0x00,0x00,0x00,0x18,0x24,0x24,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x00,0x00},
    225,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x32,0x4a,0x44,0x44,0x44,0x44,0x4a,0x32,0x00,0x00},
    0,
    0,
    'A',
    0
},

{
    "Beta",
    "beta",
    194,
    {0x00,0x00,0x00,0x00,0x7c,0x42,0x42,0x42,0x7c,0x42,0x42,0x42,0x42,0x7c,0x00,0x00},
    226,
    {0x00,0x00,0x00,0x00,0x38,0x44,0x44,0x44,0x7c,0x42,0x42,0x42,0x62,0x5c,0x40,0x40},
    0,
    0,
    'B',
    0
},

{
    "Gamma",
    "gamma",
    195,
    {0x00,0x00,0x00,0x00,0x7e,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    227,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x31,0x49,0x0a,0x04,0x08,0x08,0x10,0x10,0x00,0x00},
    0,
    0,
    'G',
    0
},

{
    "Delta",
    "delta",
    196,
    {0x00,0x00,0x00,0x00,0x08,0x08,0x14,0x14,0x22,0x22,0x22,0x41,0x41,0x7f,0x00,0x00},
    228,
    {0x00,0x00,0x00,0x00,0x1c,0x20,0x20,0x20,0x18,0x24,0x42,0x42,0x42,0x3c,0x00,0x00},
    0,
    0,
    'D',
    0
},

{
    "Epsilon",
    "epsilon",
    197,
    {0x00,0x00,0x00,0x00,0x7e,0x40,0x40,0x40,0x7c,0x40,0x40,0x40,0x40,0x7e,0x00,0x00},
    229,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x40,0x3c,0x40,0x40,0x42,0x3c,0x00,0x00},
    0,
    0,
    'E',
    0
},

{
    "Zeta",
    "zeta",
    198,
    {0x00,0x00,0x00,0x00,0x7e,0x02,0x02,0x04,0x08,0x10,0x20,0x40,0x40,0x7e,0x00,0x00},
    230,
    {0x00,0x00,0x00,0x00,0x20,0x20,0x1c,0x08,0x10,0x20,0x20,0x20,0x20,0x1c,0x02,0x1c},
    0,
    0,
    'Z',
    0
},

{
    "Eta",
    "eta",
    199,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x42,0x00,0x00},
    231,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x5c,0x62,0x42,0x42,0x42,0x42,0x42,0x42,0x02,0x02},
    0,
    0,
    'U',
    0
},

{
    "Theta",
    "theta",
    200,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    232,
    {0x00,0x00,0x00,0x00,0x18,0x24,0x24,0x42,0x7e,0x42,0x42,0x24,0x24,0x18,0x00,0x00},
    0,
    0,
    'Q',
    0
},

{
    "Iota",
    "iota",
    201,
    {0x00,0x00,0x00,0x00,0x3e,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00},
    233,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x0c,0x00,0x00},
    0,
    0,
    'I',
    0
},

{
    "Kappa",
    "kappa",
    202,
    {0x00,0x00,0x00,0x00,0x42,0x44,0x48,0x50,0x60,0x60,0x50,0x48,0x44,0x42,0x00,0x00},
    234,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x24,0x28,0x30,0x30,0x28,0x24,0x22,0x00,0x00},
    0,
    0,
    'K',
    0
},

{
    "Lambda",
    "lambda",
    203,
    {0x00,0x00,0x00,0x00,0x08,0x08,0x14,0x14,0x22,0x22,0x22,0x41,0x41,0x41,0x00,0x00},
    235,
    {0x00,0x00,0x00,0x00,0x20,0x20,0x10,0x10,0x08,0x18,0x24,0x24,0x42,0x42,0x00,0x00},
    0,
    0,
    'L',
    0
},

{
    "Mu",
    "mu",
    204,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x66,0x66,0x5a,0x5a,0x42,0x42,0x42,0x42,0x00,0x00},
    236,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x66,0x66,0x5a,0x42,0x40,0x40},
    0,
    0,
    'M',
    0
},

{
    "Nu",
    "nu",
    205,
    {0x00,0x00,0x00,0x00,0x42,0x62,0x62,0x52,0x52,0x4a,0x4a,0x46,0x46,0x42,0x00,0x00},
    237,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x44,0x44,0x48,0x50,0x60,0x00,0x00},
    0,
    0,
    'N',
    0
},

{
    "Xi",
    "xi",
    206,
    {0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x7e,0x00,0x00},
    238,
    {0x00,0x00,0x00,0x00,0x40,0x40,0x3c,0x40,0x40,0x3c,0x40,0x40,0x3c,0x02,0x02,0x3c},
    0,
    0,
    'X',
    0
},

{
    "Omicron",
    "omicron",
    207,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    239,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    0,
    0,
    'O',
    0
},

{
    "Pi",
    "pi",
    208,
    {0x00,0x00,0x00,0x00,0x7f,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00},
    240,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x00,0x00},
    0,
    0,
    'P',
    0
},

{
    "Rho",
    "rho",
    209,
    {0x00,0x00,0x00,0x00,0x7c,0x42,0x42,0x42,0x7c,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    241,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x62,0x5c,0x40,0x40},
    0,
    0,
    'R',
    0
},

{
    "Sigma",
    "sigma",
    211,
    {0x00,0x00,0x00,0x00,0x7e,0x40,0x20,0x10,0x08,0x08,0x10,0x20,0x40,0x7e,0x00,0x00},
    242,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x1e,0x20,0x40,0x40,0x40,0x20,0x1c,0x02,0x02,0x1c},
    0,
    0,
    'S',
    0
},

{
    "Final_sigma",
    "final_sigma",
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    243,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x48,0x44,0x44,0x44,0x44,0x44,0x38,0x00,0x00},
    0,
    0,
    'H',
    0
},

{
    "Tau",
    "tau",
    212,
    {0x00,0x00,0x00,0x00,0x7f,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    244,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x10,0x10,0x10,0x10,0x10,0x10,0x0c,0x00,0x00},
    0,
    0,
    'T',
    0
},

{
    "Upsilon",
    "upsilon",
    213,
    {0x00,0x00,0x00,0x00,0x41,0x41,0x22,0x22,0x14,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    245,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    0,
    0,
    'Y',
    0
},

{
    "Phi",
    "phi",
    214,
    {0x00,0x00,0x00,0x00,0x7f,0x08,0x3e,0x49,0x49,0x49,0x49,0x3e,0x08,0x7f,0x00,0x00},
    246,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3e,0x49,0x49,0x49,0x49,0x49,0x49,0x3e,0x08,0x08},
    0,
    0,
    'F',
    0
},

{
    "Chi",
    "chi",
    215,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x24,0x24,0x18,0x18,0x24,0x24,0x42,0x42,0x00,0x00},
    247,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x24,0x24,0x18,0x18,0x24,0x24,0x42,0x42},
    0,
    0,
    'C',
    0
},

{
    "Psi",
    "psi",
    216,
    {0x00,0x00,0x00,0x00,0x49,0x49,0x49,0x49,0x49,0x3e,0x08,0x08,0x08,0x08,0x00,0x00},
    248,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x49,0x49,0x49,0x49,0x49,0x3e,0x08,0x08},
    0,
    0,
    'J',
    0
},

{
    "Omega",
    "omega",
    217,
    {0x00,0x00,0x00,0x00,0x3e,0x41,0x41,0x41,0x41,0x41,0x22,0x14,0x14,0x77,0x00,0x00},
    249,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x41,0x41,0x49,0x49,0x49,0x49,0x36,0x00,0x00},
    0,
    0,
    'W',
    0
},

{
    NULL,
    NULL,
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    ' ',
    0
}

};

/*

Cyrillic Alphabet

*/
alpharec cyrillic[] = {

/*

As Cyrillic is too large for the current Clara GUI, we're
maintaning it commented out.

*/

/*
{
    "IO",
    161,
    {0x24,0x24,0x00,0x00,0x7e,0x40,0x40,0x40,0x7c,0x40,0x40,0x40,0x40,0x7e,0x00,0x00},
    241,
    {0x00,0x00,0x24,0x24,0x00,0x00,0x3c,0x42,0x42,0x7e,0x40,0x40,0x42,0x3c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "DJE",
    162,
    {0x00,0x00,0x00,0x00,0x7e,0x10,0x10,0x10,0x1e,0x11,0x11,0x11,0x11,0x16,0x00,0x00},
    242,
    {0x00,0x00,0x00,0x00,0x20,0x20,0x78,0x20,0x20,0x3c,0x22,0x22,0x22,0x22,0x0c,0x00},
    0,
    0,
    'a',
    0
},

{
    "GJE",
    163,
    {0x0c,0x30,0x00,0x00,0x7e,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    243,
    {0x00,0x00,0x0c,0x30,0x00,0x00,0x7e,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "UKRAINIAN IE",
    164,
    {0x00,0x00,0x00,0x00,0x1c,0x22,0x40,0x40,0x7c,0x40,0x40,0x40,0x22,0x1c,0x00,0x00},
    244,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x22,0x40,0x7c,0x40,0x40,0x22,0x1c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "DZE",
    165,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x40,0x30,0x0c,0x02,0x42,0x42,0x3c,0x00,0x00},
    245,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x40,0x30,0x0c,0x02,0x42,0x3c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "BYELORUSSIAN-UKRAINIAN I",
    166,
    {0x00,0x00,0x00,0x00,0x3e,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00},
    246,
    {0x00,0x00,0x00,0x08,0x08,0x00,0x18,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "YI",
    167,
    {0x24,0x24,0x00,0x00,0x3e,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00},
    247,
    {0x00,0x00,0x00,0x24,0x24,0x00,0x18,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "JE",
    168,
    {0x00,0x00,0x00,0x00,0x0e,0x04,0x04,0x04,0x04,0x04,0x04,0x44,0x44,0x38,0x00,0x00},
    248,
    {0x00,0x00,0x00,0x04,0x04,0x00,0x0c,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x48,0x30},
    0,
    0,
    'a',
    0
},

{
    "LJE",
    169,
    {0x00,0x00,0x00,0x00,0x78,0x48,0x48,0x48,0x4e,0x49,0x49,0x49,0x49,0x8e,0x00,0x00},
    249,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x48,0x48,0x4e,0x49,0x49,0x49,0x8e,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "NJE",
    170,
    {0x00,0x00,0x00,0x00,0x48,0x48,0x48,0x48,0x7e,0x49,0x49,0x49,0x49,0x4e,0x00,0x00},
    250,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x48,0x48,0x7e,0x49,0x49,0x49,0x4e,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "TSHE",
    171,
    {0x00,0x00,0x00,0x00,0x7e,0x10,0x10,0x10,0x1e,0x11,0x11,0x11,0x11,0x11,0x00,0x00},
    251,
    {0x00,0x00,0x00,0x00,0x20,0x20,0x78,0x20,0x20,0x2c,0x32,0x22,0x22,0x22,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "KJE",
    172,
    {0x0c,0x30,0x00,0x00,0x40,0x46,0x48,0x50,0x60,0x60,0x50,0x48,0x44,0x42,0x00,0x00},
    252,
    {0x00,0x00,0x0c,0x30,0x00,0x00,0x46,0x48,0x50,0x60,0x50,0x48,0x44,0x42,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SHORT U",
    174,
    {0x42,0x42,0x3c,0x00,0x41,0x41,0x22,0x22,0x14,0x14,0x08,0x08,0x10,0x30,0x00,0x00},
    254,
    {0x00,0x42,0x42,0x3c,0x00,0x00,0x42,0x42,0x24,0x24,0x18,0x18,0x10,0x10,0x20,0x60},
    0,
    0,
    'a',
    0
},

{
    "DZHE",
    175,
    {0x00,0x00,0x00,0x00,0x41,0x41,0x41,0x41,0x41,0x41,0x7f,0x08,0x08,0x08,0x00,0x00},
    255,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x22,0x22,0x22,0x3e,0x08,0x08,0x08},
    0,
    0,
    'a',
    0
},

{
    "A",
    176,
    {0x00,0x00,0x00,0x00,0x18,0x24,0x24,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x00,0x00},
    208,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x02,0x3e,0x42,0x42,0x46,0x3a,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "BE",
    177,
    {0x00,0x00,0x00,0x00,0x7c,0x40,0x40,0x40,0x7c,0x42,0x42,0x42,0x42,0x7c,0x00,0x00},
    209,
    {0x00,0x00,0x02,0x1c,0x20,0x40,0x7c,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "VE",
    178,
    {0x00,0x00,0x00,0x00,0x7c,0x42,0x42,0x42,0x7c,0x42,0x42,0x42,0x42,0x7c,0x00,0x00},
    210,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0x42,0x42,0x7c,0x42,0x42,0x42,0x7c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "GHE",
    179,
    {0x00,0x00,0x00,0x00,0x7e,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    211,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "DE",
    180,
    {0x00,0x00,0x00,0x00,0x0e,0x12,0x12,0x12,0x22,0x22,0x22,0x42,0x42,0x7f,0x01,0x01},
    212,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x1e,0x12,0x22,0x22,0x42,0x42,0x42,0x7f,0x01,0x00},
    0,
    0,
    'a',
    0
},

{
    "IE",
    181,
    {0x00,0x00,0x00,0x00,0x7e,0x40,0x40,0x40,0x7c,0x40,0x40,0x40,0x40,0x7e,0x00,0x00},
    213,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x7e,0x40,0x40,0x42,0x3c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "ZHE",
    182,
    {0x00,0x00,0x00,0x00,0x49,0x49,0x2a,0x2a,0x1c,0x1c,0x2a,0x2a,0x49,0x49,0x00,0x00},
    214,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x49,0x49,0x2a,0x1c,0x1c,0x2a,0x49,0x49,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "ZE",
    183,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x02,0x02,0x3c,0x04,0x02,0x02,0x42,0x3c,0x00,0x00},
    215,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x02,0x3c,0x04,0x02,0x42,0x3c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "I",
    184,
    {0x00,0x00,0x00,0x00,0x42,0x46,0x46,0x4a,0x4a,0x52,0x52,0x62,0x62,0x42,0x00,0x00},
    216,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x46,0x46,0x4a,0x4a,0x52,0x52,0x62,0x62,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SHORT I",
    185,
    {0x42,0x42,0x3c,0x00,0x42,0x46,0x46,0x4a,0x4a,0x52,0x52,0x62,0x62,0x42,0x00,0x00},
    217,
    {0x00,0x42,0x42,0x3c,0x00,0x00,0x46,0x46,0x4a,0x4a,0x52,0x52,0x62,0x62,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "KA",
    186,
    {0x00,0x00,0x00,0x00,0x40,0x46,0x48,0x50,0x60,0x60,0x50,0x48,0x44,0x42,0x00,0x00},
    218,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x46,0x48,0x50,0x60,0x50,0x48,0x44,0x42,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "EL",
    187,
    {0x00,0x00,0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x12,0x12,0x22,0x22,0x42,0x00,0x00},
    219,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x1e,0x12,0x12,0x12,0x12,0x22,0x22,0x42,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "EM",
    188,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x66,0x66,0x5a,0x5a,0x42,0x42,0x42,0x42,0x00,0x00},
    220,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x66,0x66,0x5a,0x5a,0x42,0x42,0x42,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "EN",
    189,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x42,0x00,0x00},
    221,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "O",
    190,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    222,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "PE",
    191,
    {0x00,0x00,0x00,0x00,0x7e,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x00,0x00},
    223,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "ER",
    192,
    {0x00,0x00,0x00,0x00,0x7c,0x42,0x42,0x42,0x7c,0x40,0x40,0x40,0x40,0x40,0x00,0x00},
    224,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x5c,0x62,0x42,0x42,0x42,0x42,0x62,0x5c,0x40,0x40},
    0,
    0,
    'a',
    0
},

{
    "ES",
    193,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x40,0x40,0x40,0x40,0x42,0x42,0x3c,0x00,0x00},
    225,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x42,0x40,0x40,0x40,0x40,0x42,0x3c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "TE",
    194,
    {0x00,0x00,0x00,0x00,0x7f,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    226,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "U",
    195,
    {0x00,0x00,0x00,0x00,0x41,0x41,0x22,0x22,0x14,0x14,0x08,0x08,0x10,0x30,0x00,0x00},
    227,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x24,0x24,0x18,0x18,0x10,0x10,0x20,0x60},
    0,
    0,
    'a',
    0
},

{
    "EF",
    196,
    {0x00,0x00,0x00,0x08,0x08,0x3e,0x49,0x49,0x49,0x49,0x49,0x3e,0x08,0x08,0x00,0x00},
    228,
    {0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x3e,0x49,0x49,0x49,0x49,0x3e,0x08,0x08,0x00},
    0,
    0,
    'a',
    0
},

{
    "HA",
    197,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x24,0x24,0x18,0x18,0x24,0x24,0x42,0x42,0x00,0x00},
    229,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x24,0x18,0x18,0x24,0x42,0x42,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "TSE",
    198,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x7f,0x01,0x01},
    230,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x7f,0x01,0x01},
    0,
    0,
    'a',
    0
},

{
    "CHE",
    199,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x46,0x3a,0x02,0x02,0x02,0x00,0x00},
    231,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x46,0x3a,0x02,0x02,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SHA",
    200,
    {0x00,0x00,0x00,0x00,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x7f,0x00,0x00},
    232,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x7f,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SHCHA",
    201,
    {0x00,0x00,0x00,0x00,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x7f,0x01,0x01},
    233,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x7f,0x01,0x01},
    0,
    0,
    'a',
    0
},

{
    "HARD SIGN",
    202,
    {0x00,0x00,0x00,0x00,0x70,0x10,0x10,0x10,0x1e,0x11,0x11,0x11,0x11,0x1e,0x00,0x00},
    234,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x10,0x10,0x1e,0x11,0x11,0x11,0x1e,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "YERU",
    203,
    {0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x72,0x4a,0x4a,0x4a,0x4a,0x72,0x00,0x00},
    235,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x42,0x72,0x4a,0x4a,0x4a,0x72,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SOFT SIGN",
    204,
    {0x00,0x00,0x00,0x00,0x40,0x40,0x40,0x40,0x7c,0x42,0x42,0x42,0x42,0x7c,0x00,0x00},
    236,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x40,0x7c,0x42,0x42,0x42,0x7c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "E",
    205,
    {0x00,0x00,0x00,0x00,0x38,0x44,0x02,0x02,0x3e,0x02,0x02,0x02,0x44,0x38,0x00,0x00},
    237,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x44,0x02,0x3e,0x02,0x02,0x44,0x38,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "YU",
    206,
    {0x00,0x00,0x00,0x00,0x4c,0x52,0x52,0x52,0x72,0x52,0x52,0x52,0x52,0x4c,0x00,0x00},
    238,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x4c,0x52,0x52,0x72,0x52,0x52,0x52,0x4c,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "YA",
    207,
    {0x00,0x00,0x00,0x00,0x3e,0x42,0x42,0x42,0x3e,0x12,0x22,0x22,0x42,0x42,0x00,0x00},
    239,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x3e,0x42,0x42,0x42,0x3e,0x12,0x22,0x42,0x00,0x00},
    0,
    0,
    'a',
    0
},

*/

/* sentinel */
{
    NULL,
    NULL,
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    ' ',
    0
}

};

/*

Hebrew Alphabet

*/
alpharec hebrew[] = {

{
    "ALEF",
    "ALEF",
    224,
    {0x00,0x00,0x00,0x00,0x00,0x46,0x42,0x22,0x12,0x2c,0x48,0x44,0x42,0x42,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "BET",
    "BET",
    225,
    {0x00,0x00,0x00,0x00,0x00,0x7c,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x7f,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "GIMEL",
    "GIMEL",
    226,
    {0x00,0x00,0x00,0x00,0x00,0x30,0x08,0x08,0x08,0x04,0x0c,0x14,0x22,0x42,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "DALET",
    "DALET",
    227,
    {0x00,0x00,0x00,0x00,0x00,0x7e,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "HE",
    "HE",
    228,
    {0x00,0x00,0x00,0x00,0x00,0x7e,0x02,0x02,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "VAV",
    "VAV",
    229,
    {0x00,0x00,0x00,0x00,0x00,0x38,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "ZAYIN",
    "ZAYIN",
    230,
    {0x00,0x00,0x00,0x00,0x00,0x30,0x0c,0x0a,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "HET",
    "HET",
    231,
    {0x00,0x00,0x00,0x00,0x00,0x7e,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "TET",
    "TET",
    232,
    {0x00,0x00,0x00,0x00,0x00,0x46,0x4a,0x42,0x42,0x42,0x42,0x42,0x42,0x7e,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "YOD",
    "YOD",
    233,
    {0x00,0x00,0x00,0x00,0x00,0x38,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "FINAL KAF",
    "FINAL KAF",
    234,
    {0x00,0x00,0x00,0x00,0x00,0x7e,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "KAF",
    "KAF",
    235,
    {0x00,0x00,0x00,0x00,0x00,0x7e,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x7c,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "LAMED",
    "LAMED",
    236,
    {0x00,0x00,0x00,0x20,0x20,0x3e,0x02,0x02,0x02,0x02,0x04,0x04,0x08,0x30,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "FINAL MEM",
    "FINAL MEM",
    237,
    {0x00,0x00,0x00,0x00,0x00,0xfe,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x3e,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "MEM",
    "MEM",
    238,
    {0x00,0x00,0x00,0x00,0x00,0x48,0x48,0x34,0x14,0x22,0x22,0x41,0x41,0x4f,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "FINAL NUN",
    "FINAL NUN",
    239,
    {0x00,0x00,0x00,0x00,0x00,0x38,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "NUN",
    "NUN",
    240,
    {0x00,0x00,0x00,0x00,0x00,0x1c,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x3c,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "SAMEKH",
    "SAMEKH",
    241,
    {0x00,0x00,0x00,0x00,0x00,0x7e,0x42,0x42,0x42,0x42,0x42,0x42,0x44,0x78,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "AYIN",
    "AYIN",
    242,
    {0x00,0x00,0x00,0x00,0x00,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0xfe,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "FINAL PE",
    "FINAL PE",
    243,
    {0x00,0x00,0x00,0x00,0x00,0x7e,0x42,0x42,0x42,0x72,0x02,0x02,0x02,0x02,0x02,0x02},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "PE",
    "PE",
    244,
    {0x00,0x00,0x00,0x00,0x00,0x7e,0x42,0x42,0x42,0x72,0x02,0x02,0x02,0x7e,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "FINAL TSADI",
    "FINAL TSADI",
    245,
    {0x00,0x00,0x00,0x00,0x00,0x22,0x22,0x24,0x28,0x30,0x20,0x20,0x20,0x20,0x20,0x20},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "TSADI",
    "TSADI",
    246,
    {0x00,0x00,0x00,0x00,0x00,0x42,0x42,0x24,0x18,0x08,0x04,0x02,0x02,0x7e,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "QOF",
    "QOF",
    247,
    {0x00,0x00,0x00,0x00,0x00,0x7e,0x22,0x22,0x24,0x24,0x28,0x20,0x20,0x20,0x20,0x20},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "RESH",
    "RESH",
    248,
    {0x00,0x00,0x00,0x00,0x00,0x7e,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "SHIN",
    "SHIN",
    249,
    {0x00,0x00,0x00,0x00,0x00,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x7f,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

{
    "TAV",
    "TAV",
    250,
    {0x00,0x00,0x00,0x00,0x00,0x3e,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x62,0x00,0x00},
    0,
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    0,
    0,
    'a',
    0
},

/* sentinel */
{
    NULL,
    NULL,
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    ' ',
    0
}

};

/*

Arabic Alphabet

*/
alpharec arabic[] = {

/*

Arabic must be worked on, so we're maintaining it commented out.

*/

/*

{
    "COMMA",
    172,
    {0x00,0x00,0x00,0x00,0x00,0x08,0x10,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SEMICOLON",
    187,
    {0x00,0x00,0x00,0x00,0x00,0x08,0x10,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "QUESTION MARK",
    191,
    {0x00,0x3e,0x41,0x40,0x20,0x10,0x08,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "HAMZA",
    193,
    {0x00,0x00,0x00,0x00,0x00,0x0e,0x10,0x16,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "ALEF WITH MADDA ABOVE",
    194,
    {0x1e,0x60,0x08,0x0c,0x0c,0x08,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "ALEF WITH HAMZA ABOVE",
    195,
    {0x30,0x40,0x24,0x46,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "WAW WITH HAMZA ABOVE",
    196,
    {0x00,0x30,0x40,0x30,0x40,0x06,0x09,0x09,0x0f,0x01,0x02,0x44,0x38,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "ALEF WITH HAMZA BELOW",
    197,
    {0x00,0x00,0x04,0x06,0x04,0x04,0x34,0x44,0x24,0x40,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "YEH WITH HAMZA ABOVE",
    198,
    {0x00,0x00,0x00,0x03,0x04,0x02,0x04,0x00,0x0c,0x58,0x8c,0x84,0x78,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "ALEF",
    199,
    {0x00,0x10,0x18,0x18,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "BEH",
    200,
    {0x00,0x00,0x00,0x00,0x00,0x02,0x41,0x81,0x7e,0x00,0x00,0x10,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "TEH MARBUTA",
    201,
    {0x00,0x12,0x00,0x00,0x0c,0x12,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "TEH",
    202,
    {0x00,0x00,0x24,0x00,0x00,0x02,0x41,0x81,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "THEH",
    203,
    {0x10,0x00,0x24,0x00,0x00,0x02,0x41,0x81,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "JEEM",
    204,
    {0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x23,0x40,0x80,0x88,0x80,0x41,0x3e,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "HAH",
    205,
    {0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x23,0x40,0x80,0x80,0x80,0x41,0x3e,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "KHAH",
    206,
    {0x00,0x00,0x00,0x10,0x00,0x00,0xfc,0x23,0x40,0x80,0x80,0x80,0x41,0x3e,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "DAL",
    207,
    {0x00,0x00,0x00,0x00,0x04,0x02,0x01,0x21,0x3e,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "THAL",
    208,
    {0x00,0x00,0x10,0x00,0x04,0x02,0x01,0x21,0x3e,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "REH",
    209,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x01,0x01,0x01,0x02,0x44,0x38,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "ZAIN",
    210,
    {0x00,0x00,0x00,0x08,0x00,0x00,0x02,0x01,0x01,0x01,0x02,0x44,0x38,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SEEN",
    211,
    {0x00,0x00,0x00,0x00,0x00,0x02,0x91,0x49,0x76,0x40,0x40,0x80,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SHEEN",
    212,
    {0x00,0x20,0x00,0x48,0x00,0x02,0x91,0x49,0x76,0x40,0x40,0x80,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SAD",
    213,
    {0x00,0x00,0x00,0x00,0x00,0x0e,0x91,0x61,0x7e,0x40,0x40,0x80,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "DAD",
    214,
    {0x00,0x00,0x00,0x20,0x00,0x0e,0x91,0x61,0x7e,0x40,0x40,0x80,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "TAH",
    215,
    {0x00,0x20,0x20,0x20,0x20,0x2e,0x31,0x21,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "ZAH",
    216,
    {0x00,0x20,0x24,0x20,0x20,0x2e,0x31,0x21,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "AIN",
    217,
    {0x00,0x00,0x00,0x0e,0x11,0x10,0x08,0x1f,0x20,0x40,0x80,0x80,0x80,0x41,0x3e,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "GHAIN",
    218,
    {0x00,0x04,0x00,0x0e,0x11,0x10,0x08,0x1f,0x20,0x40,0x80,0x80,0x80,0x41,0x3e,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "TATWEEL",
    224,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "FEH",
    225,
    {0x00,0x04,0x00,0x00,0x0e,0x09,0x45,0x83,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "QAF",
    226,
    {0x00,0x00,0x12,0x00,0x00,0x0e,0x09,0x45,0x83,0x81,0x82,0x7c,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "KAF",
    227,
    {0x00,0x01,0x09,0x11,0x09,0x41,0x81,0x81,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "LAM",
    228,
    {0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x41,0x81,0x81,0x82,0x7c,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "MEEM",
    229,
    {0x00,0x00,0x00,0x00,0x0e,0x11,0x09,0x7f,0x80,0x80,0x40,0x40,0x20,0x20,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "NOON",
    230,
    {0x00,0x00,0x00,0x08,0x00,0x00,0x02,0x41,0x81,0x81,0x82,0x7c,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "HEH",
    231,
    {0x00,0x00,0x00,0x00,0x0c,0x12,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "WAW",
    232,
    {0x00,0x00,0x00,0x00,0x00,0x06,0x09,0x09,0x0f,0x01,0x02,0x44,0x38,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "ALEF MAKSURA",
    233,
    {0x00,0x00,0x00,0x00,0x00,0x06,0x09,0x08,0x46,0x81,0x81,0x82,0x7c,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "YEH",
    234,
    {0x00,0x00,0x00,0x00,0x00,0x06,0x09,0x08,0x46,0x81,0x81,0x82,0x7c,0x00,0x48,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "FATHATAN",
    235,
    {0x0c,0x38,0x60,0x0c,0x38,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "DAMMATAN",
    236,
    {0x00,0x36,0x36,0x12,0x12,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "KASRATAN",
    237,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x38,0x60,0x0c,0x38,0x60,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "FATHA",
    238,
    {0x00,0x0c,0x38,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "DAMMA",
    239,
    {0x00,0x18,0x18,0x08,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "KASRA",
    240,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x38,0x60,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SHADDA",
    241,
    {0x22,0x49,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

{
    "SUKUN",
    242,
    {0x00,0x00,0x00,0x00,0x06,0x09,0x11,0x12,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    'a',
    0
},

*/

/* sentinel */
{
    NULL,
    NULL,
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    ' ',
    0
}

};

/*

Kana Alphabet

*/
alpharec kana[] = {

/* sentinel */
{
    NULL,
    NULL,
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    ' ',
    0
}

};


/*

Indo-arabic digits

*/
alpharec number[] = {

{
    "0",
    "0",
    48,
    {0x00,0x00,0x00,0x00,0x18,0x24,0x42,0x42,0x42,0x42,0x42,0x42,0x24,0x18,0x00,0x00},
    48,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    '0',
    0
},

{
    "1",
    "1",
    49,
    {0x00,0x00,0x00,0x00,0x08,0x18,0x28,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00},
    49,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    '1',
    0
},

{
    "2",
    "2",
    50,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x02,0x0c,0x10,0x20,0x40,0x40,0x7e,0x00,0x00},
    50,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    '2',
    0
},

{
    "3",
    "3",
    51,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x02,0x1c,0x02,0x02,0x42,0x42,0x3c,0x00,0x00},
    51,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    '3',
    0
},

{
    "4",
    "4",
    52,
    {0x00,0x00,0x00,0x00,0x04,0x0c,0x14,0x24,0x44,0x44,0x7e,0x04,0x04,0x04,0x00,0x00},
    52,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    '4',
    0
},

{
    "5",
    "5",
    53,
    {0x00,0x00,0x00,0x00,0x7e,0x40,0x40,0x40,0x7c,0x02,0x02,0x02,0x42,0x3c,0x00,0x00},
    53,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    '5',
    0
},

{
    "6",
    "6",
    54,
    {0x00,0x00,0x00,0x00,0x1c,0x20,0x40,0x40,0x7c,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    54,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    '6',
    0
},

{
    "7",
    "7",
    55,
    {0x00,0x00,0x00,0x00,0x7e,0x02,0x02,0x04,0x04,0x04,0x08,0x08,0x08,0x08,0x00,0x00},
    55,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    '7',
    0
},

{
    "8",
    "8",
    56,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x3c,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    56,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    '8',
    0
},

{
    "9",
    "9",
    57,
    {0x00,0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x3e,0x02,0x02,0x02,0x04,0x38,0x00,0x00},
    57,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    '9',
    0
},

/* sentinel */
{
    NULL,
    NULL,
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    0,
    0,
    ' ',
    0
}

};

/*

Latin alphabet alignment.

obs. Alignment positions and their codes are

     position         code
  ------------------------
  A .. asc_height       0
  X .. x_height         1
  B .. baseline         2
  D .. desc_depth       3

Alignement AB is 02, alignment BD is 23 and so on.

*/
void latin_align(void)
{
    int i;

    for (i=0; i<256; ++i)
        l_align[i] = -1;

    /* lowercase */
    l_align['a'] = 12;
    l_align['b'] = 2;
    l_align['c'] = 12;
    l_align['d'] = 2;
    l_align['e'] = 12;
    l_align['f'] = 2;
    l_align['g'] = 13;
    l_align['h'] = 2;
    l_align['i'] = 12;
    l_align['j'] = 13;
    l_align['k'] = 2;
    l_align['l'] = 2;
    l_align['m'] = 12;
    l_align['n'] = 12;
    l_align['o'] = 12;
    l_align['p'] = 13;
    l_align['q'] = 13;
    l_align['r'] = 12;
    l_align['s'] = 12;
    l_align['t'] = 2;
    l_align['u'] = 12;
    l_align['v'] = 12;
    l_align['w'] = 12;
    l_align['x'] = 12;
    l_align['y'] = 13;
    l_align['z'] = 12;

    /* uppercase */
    for (i='A'; i<='Z'; ++i)
        l_align[i] = 2;

    /*
        Sometimes the accent is graphically joined to the letter,
        so we maintain the alignment for accented characters
        too.
    */

    /* TODO */

}

/*

Indo-arabic decimal digits alignment.

*/
void number_align(void)
{
    int i;

    for (i='0'; i<='9'; ++i)
        n_align[i] = 2;

#ifdef CF
    /* old style */
    n_align[0] = 12;
    n_align[1] = 12;
    n_align[2] = 12;
    n_align[4] = 13;
    n_align[7] = 13;
    n_align[9] = 13;
#endif
}

/*

Keyboard mapping from Latin to Greek. When using a Latin keyboard,
this service will convert Latin letters to the corresponding Greek
letters accordingly to the following table:

    letter   phonetic    Clara
    --------------------------
    alpha    a             a
    beta     b             b
    gamma    g             g
    delta    d             d
    epsilon  e             e
    zeta     z             z
    eta      e (long)      u
    theta    th            q
    iota     i             i
    kappa    k             k
    lambda   l             l
    mu       m             m
    nu       n             n
    xi       x             x
    omicron  o             o
    pi       p             p
    rho      r             r
    sigma    s             s
    tau      t             t
    upsilon  y             y
    phi      ph            f
    chi      ch            c
    psi      ps            j
    omega    o (long)      w

*/
void init_latin_greek(void)
{
    int i;

    for (i=0; i<256; ++i)
        l2g[i] = NULL;

    /* uppercase */
    l2g['A'] = "\\Alpha";
    l2g['B'] = "\\Beta";
    l2g['G'] = "\\Gamma";
    l2g['D'] = "\\Delta";
    l2g['E'] = "\\Epsilon";
    l2g['Z'] = "\\Zeta";
    l2g['U'] = "\\Eta";
    l2g['Q'] = "\\Theta";
    l2g['I'] = "\\Iota";
    l2g['K'] = "\\Kappa";
    l2g['L'] = "\\Lambda";
    l2g['M'] = "\\Mu";
    l2g['N'] = "\\Nu";
    l2g['X'] = "\\Xi";
    l2g['O'] = "\\Omicron";
    l2g['P'] = "\\Pi";
    l2g['R'] = "\\Rho";
    l2g['S'] = "\\Sigma";
    l2g['T'] = "\\Tau";
    l2g['Y'] = "\\Upsilon";
    l2g['F'] = "\\Phi";
    l2g['C'] = "\\Chi";
    l2g['J'] = "\\Psi";
    l2g['W'] = "\\Omega";

    /* lowercase */
    l2g['a'] = "\\alpha";
    l2g['b'] = "\\beta";
    l2g['g'] = "\\gamma";
    l2g['d'] = "\\delta";
    l2g['e'] = "\\epsilon";
    l2g['z'] = "\\zeta";
    l2g['u'] = "\\eta";
    l2g['q'] = "\\theta";
    l2g['i'] = "\\iota";
    l2g['k'] = "\\kappa";
    l2g['l'] = "\\lambda";
    l2g['m'] = "\\mu";
    l2g['n'] = "\\nu";
    l2g['x'] = "\\xi";
    l2g['o'] = "\\omicron";
    l2g['p'] = "\\pi";
    l2g['r'] = "\\rho";
    l2g['s'] = "\\sigma";
    l2g['t'] = "\\tau";
    l2g['y'] = "\\upsilon";
    l2g['f'] = "\\phi";
    l2g['c'] = "\\chi";
    l2g['j'] = "\\psi";
    l2g['w'] = "\\omega";
}

/*

Initialize alphabet stuff.

*/
void init_alphabet(void)
{

    /* count the size of each alphabet */
    for (latin_sz=0; latin[latin_sz].ln != NULL; ++latin_sz);
    for (greek_sz=0; greek[greek_sz].ln != NULL; ++greek_sz);
    for (cyrillic_sz=0; cyrillic[cyrillic_sz].ln != NULL; ++cyrillic_sz);
    for (hebrew_sz=0; hebrew[hebrew_sz].ln != NULL; ++hebrew_sz);
    for (arabic_sz=0; arabic[arabic_sz].ln != NULL; ++arabic_sz);
    for (kana_sz=0; kana[kana_sz].ln != NULL; ++kana_sz);
    for (number_sz=0; number[number_sz].ln != NULL; ++number_sz);

    /* maximum alphabet size */
    max_sz = latin_sz;
    if (greek_sz > max_sz)
        max_sz = greek_sz;
    if (cyrillic_sz > max_sz)
        max_sz = cyrillic_sz;
    if (hebrew_sz > max_sz)
        max_sz = hebrew_sz;
    if (arabic_sz > max_sz)
        max_sz = arabic_sz;
    if (kana_sz > max_sz)
        max_sz = kana_sz;
    if (number_sz > max_sz)
        max_sz = number_sz;

    /* alignment info */
    latin_align();
    number_align();

    /* alphabet mappings */
    init_latin_greek();
}

/*

Compose accents with letters into ISO-8859-1 characters.

*/
int compose(int *l,int c)
{
    if (*l < 0) {
        *l = c;
        if ((c == '\'') ||
            (c == '~') ||
            (c == '^') ||
            (c == '"') ||
            (c == '`') ||
            (c == '/'))
            return(0);
        else
            return(1);
    }
    else if (*l == '\'') {
        if (c == '\'')
            *l = '"';
        else if (c == 'a')
            *l = '';
        else if (c == 'e')
            *l = '';
        else if (c == 'i')
            *l = '';
        else if (c == 'o')
            *l = '';
        else if (c == 'u')
            *l = '';
        else if (c == 'A')
            *l = '';
        else if (c == 'E')
            *l = '';
        else if (c == 'I')
            *l = '';
        else if (c == 'O')
            *l = '';
        else if (c == 'U')
            *l = '';
        else if (c == 'c')
            *l = '';
        else if (c == 'C')
            *l = '';
        else
            *l = c;
    }
    else if (*l == '~') {
        if (c == '~')
            *l = '~';
        else if (c == 'a')
            *l = '';
        else if (c == 'o')
            *l = '';
        else if (c == 'n')
            *l = '';
        else if (c == 'A')
            *l = '';
        else if (c == 'O')
            *l = '';
        else if (c == 'N')
            *l = '';
        else if (c == 'c')
            *l = '';
        else if (c == 'C')
            *l = '';
        else
            *l = c;
    }
    else if (*l == '^') {
        if (c == '^')
            *l = '^';
        else if (c == 'a')
            *l = '';
        else if (c == 'e')
            *l = '';
        else if (c == 'i')
            *l = '';
        else if (c == 'o')
            *l = '';
        else if (c == 'u')
            *l = '';
        else if (c == 'A')
            *l = '';
        else if (c == 'E')
            *l = '';
        else if (c == 'I')
            *l = '';
        else if (c == 'O')
            *l = '';
        else if (c == 'U')
            *l = '';
        else
            *l = c;
    }
    else if (*l == '"') {
        if (c == '"')
            *l = '"';
        else if (c == 'a')
            *l = '';
        else if (c == 'e')
            *l = '';
        else if (c == 'i')
            *l = '';
        else if (c == 'o')
            *l = '';
        else if (c == 'u')
            *l = '';
        else if (c == 'y')
            *l = '';
        else if (c == 'A')
            *l = '';
        else if (c == 'E')
            *l = '';
        else if (c == 'I')
            *l = '';
        else if (c == 'O')
            *l = '';
        else if (c == 'U')
            *l = '';
        else if (c == 's')
            *l = '';
        else
            *l = c;
    }
    else if (*l == '`') {
        if (c == '`')
            *l = '"';
        else if (c == 'a')
            *l = '';
        else if (c == 'e')
            *l = '';
        else if (c == 'i')
            *l = '';
        else if (c == 'o')
            *l = '';
        else if (c == 'u')
            *l = '';
        else if (c == 'A')
            *l = '';
        else if (c == 'E')
            *l = '';
        else if (c == 'I')
            *l = '';
        else if (c == 'O')
            *l = '';
        else if (c == 'U')
            *l = '';
        else
            *l = c;
    }
    else if (*l == '/') {
        if (c == '')
            *l = '/';
        else if (c == '?')
            *l = '';
        else if (c == '!')
            *l = '';
        else if (c == 'a')
            *l = '';
        else if (c == 'o')
            *l = '';
        else if (c == 'A')
            *l = '';
        else if (c == 'O')
            *l = '';
        else
            *l = c;
    }
    return(1);
}

