# Change this file when releasing a new version.

# Version numbers.
set(CLEMENTINE_VERSION_MAJOR 0)
set(CLEMENTINE_VERSION_MINOR 6)
set(CLEMENTINE_VERSION_PATCH 0)

include(FindSubversion)

set(BUILDBOT_REVISION $ENV{BUILDBOT_REVISION})
if(NOT BUILDBOT_REVISION)
  find_package(Subversion)
  if(SUBVERSION_FOUND)
    execute_process(COMMAND ${Subversion_SVN_EXECUTABLE} info ${PROJECT_SOURCE_DIR}
        RESULT_VARIABLE SVN_INFO_RESULT
        OUTPUT_QUIET
        ERROR_QUIET)
    if(${SVN_INFO_RESULT} EQUAL 0)
      Subversion_WC_INFO(${PROJECT_SOURCE_DIR} clementine)
      set(BUILDBOT_REVISION ${clementine_WC_REVISION})
    endif(${SVN_INFO_RESULT} EQUAL 0)
  endif(SUBVERSION_FOUND)
endif(NOT BUILDBOT_REVISION)

if(BUILDBOT_REVISION)
  set(CLEMENTINE_VERSION_STRING "${CLEMENTINE_VERSION_MAJOR}.${CLEMENTINE_VERSION_MINOR} r${BUILDBOT_REVISION}") # Displayed in GUIs
  set(CLEMENTINE_VERSION_SHORT_STRING "${CLEMENTINE_VERSION_MAJOR}.${CLEMENTINE_VERSION_MINOR}r${BUILDBOT_REVISION}")       # Used in filenames
  set(CLEMENTINE_VERSION ${CLEMENTINE_VERSION_MAJOR}.${CLEMENTINE_VERSION_MINOR}.90.r${BUILDBOT_REVISION})
  set(CLEMENTINE_DEB_VERSION ${CLEMENTINE_VERSION_MAJOR}.${CLEMENTINE_VERSION_MINOR}.90~r${BUILDBOT_REVISION}~${DEB_DIST})
else(BUILDBOT_REVISION)
  if (CLEMENTINE_VERSION_PATCH)
    set(CLEMENTINE_VERSION ${CLEMENTINE_VERSION_MAJOR}.${CLEMENTINE_VERSION_MINOR}.${CLEMENTINE_VERSION_PATCH})
  else (CLEMENTINE_VERSION_PATCH)
    set(CLEMENTINE_VERSION ${CLEMENTINE_VERSION_MAJOR}.${CLEMENTINE_VERSION_MINOR})
  endif (CLEMENTINE_VERSION_PATCH)
  set(CLEMENTINE_DEB_VERSION ${CLEMENTINE_VERSION}~${DEB_DIST})
  set(CLEMENTINE_VERSION_STRING "${CLEMENTINE_VERSION}")
  set(CLEMENTINE_VERSION_SHORT_STRING "${CLEMENTINE_VERSION}")
endif(BUILDBOT_REVISION)

