#!/bin/bash

name=clementine
version="0.6"
deb_version="0.6~"
root=$(cd "${0%/*}/.." && echo $PWD/${0##*/})
root=`dirname "$root"`
rootnoslash=`echo $root | sed "s/^\///"`

echo "Creating $name-$version.tar.gz..."

tar -czf $name-$version.tar.gz "$root" \
    --transform "s,^$rootnoslash,$name-$version," \
    --exclude-vcs \
    --exclude "$root/bin/*" \
    --exclude "$root/debian" \
    --exclude "$root/dist/*.tar.gz"

echo "Also creating ${name}_$deb_version.orig.tar.gz..."
cp "$name-$version.tar.gz" "${name}_$deb_version.orig.tar.gz"

