# -*- coding: ascii -*-

###########################################################################
# clive, video extraction utility
# Copyright (C) 2007-2008 Toni Gundogdu
#
# This file is part of clive.
#
# clive is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# clive is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with clive.  If not, see <http://www.gnu.org/licenses/>.
###########################################################################

## The classes that involve locating or constructing file paths

__all__ = ['ConfigDir', 'Autodetect']

from clive.modules import Modules

## The class that wraps absolute paths to config etc. files
class ConfigDir:
    _rcdir = '.clive'
    _rcfile = 'config'
    _cachefile = 'cache'
    _recallfile = 'recall'
    _customfile = 'custom.py'
    _passwdfile = 'passwd'

    ## Constructor
    def __init__(self):
        os = Modules().getinst('os')
        self._rcdir = os.path.join(os.path.expanduser('~'), self._rcdir)
        errno = Modules().getinst('errno')
        try:
            os.makedirs(self._rcdir)
        except OSError, e:
            if e.errno == errno.EEXIST: pass
            else: raise
        self._rcfile = os.path.join(self._rcdir, self._rcfile)
        self._cachefile = os.path.join(self._rcdir, self._cachefile)
        self._recallfile = os.path.join(self._rcdir, self._recallfile)
        self._customfile = os.path.join(self._rcdir, self._customfile)
        self._passwdfile = os.path.join(self._rcdir, self._passwdfile)

    ## Return path to ~/.clive directory
    def dir(self):
        return self._rcdir

    ## Return path to rcfile
    def rcfile(self):
        return self._rcfile

    ## Return path to cache file
    def cachefile(self):
        return self._cachefile

    ## Return path to recall file
    def recallfile(self):
        return self._recallfile

    ## Return path to custom file
    def customfile(self):
        return self._customfile

    ## Return path to passwd file
    def passwdfile(self):
        return self._passwdfile


## The class used to locate programs
class Autodetect:
    ## Return path to a program
    def locate(self, cmds, append="", say=None):
        if not isinstance(cmds, list): cmds = [cmds] # -> list
        path = None
        subprocess = Modules().getinst('subprocess')
        for cmd in cmds:
            pipe = subprocess.Popen('which %s 2>/dev/null' % cmd,
                shell=1, stdout=subprocess.PIPE).stdout
            data = pipe.read().rstrip('\n')
            if len(data) > 0:
                path = '%s %s' % (data, append)
                if say: say('found: %s' % data)
                break # use first found item from the cmd list
        return path
