#version 120
uniform sampler2D Tex0;
uniform vec2 TextureSize;

#define NUM_SAMPLES 7
uniform float W[NUM_SAMPLES];

void main()
{
    vec4 sum   = vec4(0.0, 0.0, 0.0, 0.0);
    vec2 delta = vec2(0.0, 1.0 / TextureSize.y);

    vec2 texCoord = vec2(gl_TexCoord[0].s, gl_TexCoord[0].t);
    texCoord.x += 0.0 / TextureSize.x;
    texCoord.y -= ((NUM_SAMPLES -1)/2) / TextureSize.y;
   
    for(int i = 0; i < NUM_SAMPLES; ++i)
    {
        sum += texture2D(Tex0, texCoord) * W[i];
        texCoord += delta;
    }
    gl_FragColor = vec4(sum.x, sum.y, sum.z, sum.w);
}

