/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <clutk/clutk.h>

void test_effect_create_suite ();
void test_effect_animation_create_suite (void);
void test_effect_context_create_suite (void);
void test_effect_drop_shadow_create_suite (void);
void test_em_support_create_suite (void);
void test_layer_actor_support_create_suite (void);
void test_render_target_create_suite (void);
void test_menu_create_suite (void);
void test_menu_expandable_create_suite (void);
void test_dnd_create_suite (void);
void test_surface_blur_create_suite (void);
void test_icon_view_create_suite (void);

gint
main (gint argc, gchar *argv[])
{
  g_type_init ();
  g_test_init (&argc, &argv, NULL);

  ctk_init (&argc, &argv);

  const gchar *display = g_getenv ("DISPLAY");
  if (!display || *display == '\0')
    {
      g_print ("No DISPLAY found. Unable to run the test suite without a "
               "display.");
      exit (EXIT_SUCCESS);
    }

  g_setenv ("CLUTTER_VBLANK", "none", FALSE);

  /* Please keep this alphabetically ordered */
  test_dnd_create_suite ();
  test_effect_create_suite ();
  test_effect_animation_create_suite ();
  test_effect_context_create_suite ();
  test_effect_drop_shadow_create_suite ();
  test_em_support_create_suite ();
  test_icon_view_create_suite ();
  test_layer_actor_support_create_suite ();
  test_menu_create_suite ();
  test_menu_expandable_create_suite ();
  test_render_target_create_suite ();
  test_surface_blur_create_suite ();

  return g_test_run ();
}
