/*
 * ClutterCairo.
 *
 * An simple Clutter Cairo 'Drawable'.
 *
 * Authored By Matthew Allum  <mallum@openedhand.com>
 *
 * Copyright (C) 2006 OpenedHand
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _HAVE_CLUTTER_CAIRO_H
#define _HAVE_CLUTTER_CAIRO_H

#include <glib-object.h>

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <clutter/clutter-texture.h>

#include <cairo/cairo.h>

G_BEGIN_DECLS

#define CLUTTER_TYPE_CAIRO clutter_cairo_get_type()

#define CLUTTER_CAIRO(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  CLUTTER_TYPE_CAIRO, ClutterCairo))

#define CLUTTER_CAIRO_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  CLUTTER_TYPE_CAIRO, ClutterCairoClass))

#define CLUTTER_IS_CAIRO(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  CLUTTER_TYPE_CAIRO))

#define CLUTTER_IS_CAIRO_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  CLUTTER_TYPE_CAIRO))

#define CLUTTER_CAIRO_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  CLUTTER_TYPE_CAIRO, ClutterCairoClass))

typedef struct _ClutterCairo ClutterCairo;
typedef struct _ClutterCairoClass ClutterCairoClass;
typedef struct _ClutterCairoPrivate ClutterCairoPrivate;

struct _ClutterCairo
{
  ClutterTexture         parent;
  /*< private >*/
  ClutterCairoPrivate   *priv;
};

struct _ClutterCairoClass 
{
  /*< private >*/
  ClutterTextureClass parent_class;

  void (*_clutter_cairo_1) (void);
  void (*_clutter_cairo_2) (void);
  void (*_clutter_cairo_3) (void);
  void (*_clutter_cairo_4) (void);
}; 

GType         clutter_cairo_get_type         (void) G_GNUC_CONST;
ClutterActor *clutter_cairo_new              (guint               width,
                                              guint               height);
cairo_t *     clutter_cairo_create           (ClutterCairo       *cairo);

void          clutter_cairo_set_source_color (cairo_t            *cr,
                                              const ClutterColor *color);

G_END_DECLS

#endif
