(*
 * Copyright 2005-2010, Ecole des Mines de Nantes, University of Copenhagen
 * Yoann Padioleau, Julia Lawall, Rene Rydhof Hansen, Henrik Stuart, Gilles Muller, Nicolas Palix
 * This file is part of Coccinelle.
 *
 * Coccinelle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, according to version 2 of the License.
 *
 * Coccinelle is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Coccinelle.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The authors reserve the right to distribute this or future versions of
 * Coccinelle under other licenses.
 *)


open Ograph_extended

val labels_for_ctl :
  string list (* dropped isos *) ->
  (nodei * Control_flow_c.node) list -> Lib_engine.metavars_binding ->
  Lib_engine.label_ctlcocci


val fix_flow_ctl : Control_flow_c.cflow -> Control_flow_c.cflow

val model_for_ctl :
  string list (* dropped isos *) ->
  Control_flow_c.cflow -> Lib_engine.metavars_binding -> Lib_engine.model


type pred = Lib_engine.predicate * Ast_cocci.meta_name Ast_ctl.modif

val mysat :
  Lib_engine.model ->
  (Lib_engine.ctlcocci * (pred list list)) ->
  (Lib_engine.mvar list * Lib_engine.metavars_binding) ->
  (Lib_engine.numbered_transformation_info *  bool *
     Lib_engine.metavars_binding * Lib_engine.metavars_binding list)


val print_bench : unit -> unit
