/*-------------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported to C++ by Csaba Balazs, University of Szeged
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the 
Free Software Foundation; either version 2, or (at your option) any 
later version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
for more details.

You should have received a copy of the GNU General Public License along 
with this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than 
Coco/R itself) does not fall under the GNU General Public License.
-------------------------------------------------------------------------*/

#include <string.h>
#include "StringBuilder.h"
#include "Scanner.h"

namespace Coco {

void StringBuilder::Init(int capacity) {
	length = 0;
	this->capacity = capacity;
	data = new wchar_t[capacity + 1];
	data[0] = 0;	
}

StringBuilder::StringBuilder(int capacity) {
	Init(capacity);
}

StringBuilder::StringBuilder(const wchar_t *val) {
	capacity = length = wcslen(val);
	Init(capacity);
	wcscpy(data, val);
}

StringBuilder::~StringBuilder() {
	if (data != NULL) {
		delete [] data;
		data = NULL;
		length = 0;
		capacity = 0;
	}
}

void StringBuilder::Append(wchar_t value) {
	if (length == capacity) {
		int oldCap = capacity;
		capacity = capacity * 2;
		wchar_t *nData = new wchar_t[capacity + 1];
		memcpy(nData, data, oldCap * sizeof(int));
		delete [] data;
		data = nData;
	}
	
	data[length] = value;
	length++;
	data[length] = '\0';
}

void StringBuilder::Append(wchar_t *value) {
	if (length + (int)wcslen(value) < capacity) {
		wcscpy(data + length, value);
		length += wcslen(value);
	}
}


wchar_t* StringBuilder::ToString() {
	return coco_string_create(data);
}

}; // namespace
