//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2008 by Eran Ifrah                            
// file name            : externaltooldlg.h              
//                                                                          
// -------------------------------------------------------------------------
// A                                                                        
//              _____           _      _     _ _                            
//             /  __ \         | |    | |   (_) |                           
//             | /  \/ ___   __| | ___| |    _| |_ ___                      
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )                     
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/                     
//              \____/\___/ \__,_|\___\_____/_|\__\___|                     
//                                                                          
//                                                  F i l e                 
//                                                                          
//    This program is free software; you can redistribute it and/or modify  
//    it under the terms of the GNU General Public License as published by  
//    the Free Software Foundation; either version 2 of the License, or     
//    (at your option) any later version.                                   
//                                                                          
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef __externaltooldlg__
#define __externaltooldlg__

/**
@file
Subclass of ExternalToolBaseDlg, which is generated by wxFormBuilder.
*/

#include "externaltoolsbasedlg.h"
#include <vector>
#include "externaltoolsdata.h"
class IManager;

/** Implementing ExternalToolBaseDlg */
class ExternalToolDlg : public ExternalToolBaseDlg
{
	long m_item;
	IManager *m_mgr;
	
private:
	void DoUpdateEntry(const wxString& id, const wxString& name, const wxString& path, const wxString& workingDirectory, const wxString& arguments, const wxString &icon16, const wxString &icon24, bool captureOutput, bool saveAllFiles);
	void DoEditEntry(long item);
	
protected:
	// Handlers for ExternalToolBaseDlg events.
	void OnItemActivated( wxListEvent& event );
	void OnItemDeSelected( wxListEvent& event );
	void OnItemSelected( wxListEvent& event );
	void OnButtonNew( wxCommandEvent& event );
	void OnButtonNewUI( wxUpdateUIEvent& event );
	void OnButtonEdit( wxCommandEvent& event );
	void OnButtonEditUI( wxUpdateUIEvent& event );
	void OnButtonDelete( wxCommandEvent& event );
	void OnButtonDeleteUI( wxUpdateUIEvent& event );
	
	void Initialize();
public:
	/** Constructor */
	ExternalToolDlg( wxWindow* parent, IManager *mgr );
	std::vector<ToolInfo> GetTools();
	void SetTools(const std::vector<ToolInfo>& tools);
};

#endif // __externaltooldlg__
