#ifndef __cppcheckreportpage__
#define __cppcheckreportpage__

/**
@file
Subclass of CppCheckReportBasePage, which is generated by wxFormBuilder.
*/

#include "cppcheckreportbasepage.h"
#include "cppchecktestresults.h"
#include <vector>
#include <map>

extern const wxEventType wxEVT_CPPCHECK_ASK_STOP;

class IManager;
class CppCheckPlugin;

/** Implementing CppCheckReportBasePage */
class CppCheckReportPage : public CppCheckReportBasePage
{
	IManager*           m_mgr;
	CppCheckPlugin*     m_plugin;
	CppCheckTestResults m_results;

protected:
	// Handlers for CppCheckReportBasePage events.

	void OnListCtrlItemActivated( wxListEvent& event );
	void OnClearReport          ( wxCommandEvent& event );
	void OnStopChecking         ( wxCommandEvent& event );
	void OnStopCheckingUI       (wxUpdateUIEvent &event);
	void OnClearReportUI        (wxUpdateUIEvent &event);
	void OnSkipFile             ( wxCommandEvent& event );
	void OnSkipFileUI           (wxUpdateUIEvent &event);
protected:
	void DoClearReport          ();
	void ClearListCtrl          ();
public:
	/** Constructor */
	CppCheckReportPage(wxWindow* parent, IManager* mgr, CppCheckPlugin* plugin);

	void   AddResults   (const wxString &xmlOutput);
	void   SetStatus    (const wxString& status);
	void   FileSelected ( const wxString &filename );
	void   Clear        ();
	size_t GetErrorCount() {
		return m_results.GetErrorCount();
	}
};

#endif // __cppcheckreportpage__
