#!/usr/bin/env python
docstring = """
invoke

    %s filename1.txt

to generate a pdf file from restructered text.

http://docutils.sourceforge.net/docs/user/rst/quickref.html

""" % __file__

from _findpy import py

from py.__.rest import directive
from py.__.rest.latex import process_rest_file, process_configfile

optparse = py.compat.optparse

parser = optparse.OptionParser(usage=docstring)
parser.add_option("-c", "--config", dest="configfile",
                  help="use config file")
parser.add_option("--stylesheet", dest="stylesheet", default=None,
                  help="use style sheet")
parser.add_option("--debug", action="store_true", dest="debug",
                  default=False,
                  help="print debug output and don't delete files")

if __name__ == '__main__':
    directive.BackendStore("latex")
    (options, args) = parser.parse_args()
    if options.configfile is not None:
        configfile = py.path.local(options.configfile)
        process_configfile(options.configfile, options.debug)
    elif len(args) != 1:
        parser.error("please supply a file name")
    else:
        f = py.path.local(args[0])
        process_rest_file(args[0], options.stylesheet, options.debug)
        

