import gobject

GROUP_MEMBER_FLAG_MEMBER = 0
GROUP_MEMBER_FLAG_LOCAL = 1
GROUP_MEMBER_FLAG_REMOTE = 2

class TelepathyGroupMember(gobject.GObject):
	__gsignals__ = {"updated": (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [])}
	
	def __init__(self, handle):
		gobject.GObject.__init__(self)
		self.handle = handle
		self.flag = GROUP_MEMBER_FLAG_MEMBER
	
	def set_flag(self, flag):
		if self.flag != flag:
			self.flag = flag
			self.emit('updated')
	
	def is_member(self):
		return (self.flag == GROUP_MEMBER_FLAG_MEMBER)
	def is_local(self):
		return (self.flag == GROUP_MEMBER_FLAG_LOCAL)
	def is_remote(self):
		return (self.flag == GROUP_MEMBER_FLAG_REMOTE)
		
	def __repr__(self):
		flag = "member"
		if self.flag == GROUP_MEMBER_FLAG_LOCAL:
			flag = "local"
		elif self.flag == GROUP_MEMBER_FLAG_REMOTE:
			flag = "remote"
			
		return "TelepathyGroupMember(%s, %s)" % (self.handle, flag)
