# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import gtk
from gettext import gettext as _

from cohoba.contacts.ui.ContactListWindowManager import get_contact_list_window_manager
from cohoba.common.ui.PresenceIcons import get_presence_icons
from cohoba.common.Utils import presence_status_to_string, global_error_handler
from cohoba.common.TelepathyConstants import (MISSION_CONTROL_INTERFACE,
	MISSION_CONTROL_OBJECT_PATH)
from cohoba.common.TelepathyGroup import GROUP_MEMBER_FLAG_LOCAL, GROUP_MEMBER_FLAG_REMOTE
from cohoba.common.DBusProxyProvider import get_proxy_provider

ICON_THEME = gtk.icon_theme_get_default()
PEOPLE_ICON = ICON_THEME.load_icon("stock_people", 48, gtk.ICON_LOOKUP_USE_BUILTIN)

from telepathy.constants import CONNECTION_HANDLE_TYPE_CONTACT
from telepathy.interfaces import CONN_INTERFACE, CHANNEL_TYPE_TEXT


class AbstractContact:
	"""An entry in the main window's contact list."""

	def __init__(self):
		pass
	
	def get_description(self):
		"""Return a formatted description of the contact-list item,
		encoded as a string using Pango markup.
		"""
		name = self.name
		if self.alias != None:
			name = "%s\n%s" % (self.alias, name)

		string = '<b>%s</b>\n<span size="small"><i>%r</i></span>' % (name, self.groups)
		code, message = self.status
		if message != None:
			message = "\n"+message
		else:
			message = ""
		
		string += '\n<span size="small">%s%s</span>' % (presence_status_to_string(code), message)
		if self.flag == GROUP_MEMBER_FLAG_LOCAL:
			string += "\n<span size='small'><i>%s</i></span>" % _("Waiting for your authorization")
		elif self.flag == GROUP_MEMBER_FLAG_REMOTE:
			string += "\n<span size='small'><i>%s</i></span>" % _("Waiting for remote authorization")
		
		return string

	def get_icon(self):
		"""Return an icon representing this contact-list item,
		in GDK Pixbuf format.
		"""
		return PEOPLE_ICON

	def action(self):
		"""Do something appropriate when the user clicks on
		the contact-list item."""
		pass

	def is_uncategorized(self):
		return (self.groups != None and len(self.groups) == 0)
	
	def get_sort_key(self):
		return self.name
	
	def set_name(self, name):
		self.name = name
		self.save()
	
	def set_groups(self, groups):
		self.groups = groups
		self.save()
		
	def set_favorite(self, favorite):
		self.favorite = favorite
		self.save()
