# Cohoba - a GNOME client for Telepathy
#
# Copyright (C) 2006 Collabora Limited
#
# This package is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this package; if not, write to the Free Software
# Foundation, 51 Franklin Street, Fifth Floor, Boston, MA, 02110-1301 USA.

import os
import gtk, gobject

from cohoba.technobabble.ui.ConversationWindow import ConversationWindow

class ConversationWindowManager:
	def __init__(self):
		self.windows = {}
		self.shutdown_id = 0
	
	def stop_shutdown(self):
		if self.shutdown_id != 0:
			print 'Technobabble Cancelling previous shutdown scheduling'
			gobject.source_remove(self.shutdown_id)
			self.shutdown_id = 0
			
	def start_shutdown(self):
		self.stop_shutdown()
		if 'TB_PERSIST' not in os.environ:
			print 'Technobabble will shut itself down in 5 secs'
			self.shutdown_id = gobject.timeout_add(5*1000, gtk.main_quit)
		else:
			print 'Technobabble will not shut itself because of TB_PERSIST'
		
	def show(self, conn_path, contact):
		print 'Showing Conversation with:', conn_path, contact
		print 'Existing conversations:', self.windows
		if conn_path not in self.windows:
			self.windows[conn_path] = {}
			
		if contact.handle not in self.windows[conn_path]:
			print 'Creating new conversation window', contact
			win = ConversationWindow(contact)
			win.connect('destroy', self.on_window_destroy, conn_path, contact.handle)
			self.windows[conn_path][contact.handle] = win
				
		self.windows[conn_path][contact.handle].present_with_time(gtk.get_current_event_time())
		
		# Cancel any previously scheduled shutdowns
		self.stop_shutdown()
		
		return self.windows[conn_path][contact.handle]
	
	def on_window_destroy(self, window, conn_path, handle):
		if conn_path in self.windows and handle in self.windows[conn_path]:
			del self.windows[conn_path][handle]
		if len(self.windows[conn_path]) == 0:
			del self.windows[conn_path]
			
		if len(self.windows) == 0:
			self.start_shutdown()
			
manager = ConversationWindowManager()
def get_conversation_window_manager():
	return manager	
	
