/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

/*!
  \class SoLockManager SoLockMgr.h Inventor/lock/SoLockMgr.h
  \brief The SoLockManager is a defunct software license lock mechanism.
  \ingroup general

  This is just a dummy implementation of the TGS Inventor class used
  to provide a license locking mechanism. Since Coin can be used
  without any royalty fees or client-site license locks, no such
  mechanism is needed.

  If you are looking for information about using Coin in proprietary
  applications for commercial distribution, read about the Coin
  Professional Edition License on the Coin web-pages <a
  href="http://www.coin3d.org">here</a>.
*/


#include <Inventor/lock/SoLockMgr.h>
#include <Inventor/SbString.h>
#include <string.h>

class SoLockManager_pimpl {
public:
  SoLockManager_pimpl(void) { this->unlockstr = NULL; }
  ~SoLockManager_pimpl() { delete this->unlockstr; }

  char * unlockstr;
};

SoLockManager_pimpl * SoLockManager::pimpl = NULL;

/*!
  A void method provided just for sourcecode compatibility in client
  applications with TGS Inventor.

  It just stores the \a unlockstr argument internally to be able to
  provide it upon calls to GetUnlockString().
*/
void
SoLockManager::SetUnlockString(char * unlockstr)
{
  if (!SoLockManager::pimpl) // FIXME: deallocate on exit. 20000518 mortene.
    SoLockManager::pimpl = new SoLockManager_pimpl;
  delete SoLockManager::pimpl->unlockstr;
  SoLockManager::pimpl->unlockstr = new char[strlen(unlockstr) + 1];
  (void)strcpy(SoLockManager::pimpl->unlockstr, unlockstr);
}

/*!
  A void method provided just for sourcecode compatibility in client
  applications with TGS Inventor.

  Returns the string set through SetUnlockString().
*/
char *
SoLockManager::GetUnlockString(void)
{
  return SoLockManager::pimpl ? SoLockManager::pimpl->unlockstr : NULL;
}
