#!/usr/bin/python
# -*- coding: Latin-1 -*-
###############################################################################
#
#    This file is part of COLLATINVS.
#
#    COLLATINVS is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    COLLATINVS is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with COLLATINVS; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###############################################################################
#                Amico meo Georgio Kaznadario, summa cum gratia               #
###############################################################################
#   Faciendum : dialoga cautionis (proprietas changet aeditorium)
#

import re
from gtk import *
import gtk.glade
import collat

# les en-ttes

en_tete_html = """
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
  <title>Collatinus - Sine nomine</title>
</head>
<body>
"""

en_tete_LaTeX = """
\documentclass[12pt]{article}
\usepackage[T1]{fontenc}
\usepackage[latin1]{inputenc}
\usepackage{geometry}
\usepackage[frenchb]{babel}
\geometry{a4paper, left=1in, right=1in, top=1in, bottom=1in}
\\begin{document}
"""

class GladeHandlers:
 
  def on_quitter1_activate(self):
     mainquit()

  def on_window1_destroy(self):
    mainquit()
    
  def on_a_propos1_activate(self):
      widgets['apropos'].show()
      return

  def on_button1_clicked(self):
     widgets['apropos'].hide()
     return

  def on_ouvrir1_activate(self):
     # action_fichier permet de savoir si la validation
     # d'un nom dans le dialogue de choix de fichier
     # correspond  (0) un fichier  charger, ou  (1)
     # un fichier  enregistrer
     # 
     #  crire : dialogue de prcaution
     global action_fichier
     action_fichier = 0
     widgets['fileselection1'].show()
     return

  def on_ok_button1_clicked(self):
     """ Validation dans le dialogue de choix de fichiers. Cf ci-dessus. """
     nomfichier = widgets['fileselection1'].get_filename()
     if action_fichier == 0:
        """ charger le fichier dans l'diteur source """
        # chargement
        fichier = open(nomfichier)
        edlatin.get_buffer().insert_at_cursor(unicode(fichier.read(), 'latin1'))
        fichier.close()
     else:
        # enregistrement
	fichier = open(nomfichier, 'w')
        page = widgets['notebook1'].get_current_page()
	if page == 0:  
	   fichier.write(edlatin.get_chars(0,-1))
	   fichier.write(widgets['text2'].get_chars(0, -1))
	elif page == 1:
	   fichier.write(en_tete_html)
	   fichier.write(edlatin.get_chars(0,-1))
           fichier.write('<ul>')
	   fichier.write(widgets['text3'].get_chars(0,-1))
           fichier.write('</ul>\n')
	   fichier.write("</body>\n</html>")
	else:
           fichier.write(en_tete_LaTeX)
	   fichier.write(edlatin.get_chars(0,-1))
	   fichier.write('\\\\ \n')
	   fichier.write('\\begin{itemize}')
	   fichier.write(widgets['text4'].get_chars(0,-1))
	   fichier.write('\end{itemize}\n\end{document}')
	fichier.close()
     widgets['fileselection1'].hide()
     return

  def on_cancel_button1_clicked(self):
     """ Annulation dans le dialogue de choix de fichiers. """
     widgets['fileselection1'].hide()
     return

  def on_simple1_toggled(self):
     widgets['togglebutton1'].set_active(widgets['morphologie1'].active)
     return

  def on_togglebutton1_toggled(self):
     """ Bascule entre lemmatisation simple et analyse morpho. """
     widgets['morphologie1'].set_active(widgets['togglebutton1'].get_active())
     widgets['simple1'].set_active(widgets['togglebutton1'].get_active() - 1)
     return

  def on_lemmatiser1_activate(self):
     """ lemmatiser le texte """
     # dfinir le texte
     texte = edlatin.get_buffer().get_text(edlatin.get_buffer().get_start_iter(),edlatin.get_buffer().get_end_iter()) 
     # appeler le lemmatiseur
     page = widgets['notebook1'].get_current_page()
     if page == 0:
        liste_lemmes = unicode(collat.lemmatise(texte, 'texte'), 'latin1')
        widgets['text2'].get_buffer().insert_at_cursor(liste_lemmes)
     elif page == 1:
        liste_lemmes = unicode(collat.lemmatise(texte, 'html'), 'latin1')
        widgets['text3'].get_buffer().insert_at_cursor(liste_lemmes)
     else:
        liste_lemmes  = unicode(collat.lemmatise(texte, 'LaTeX'), 'latin1')
        widgets['text4'].get_buffer().insert_at_cursor(liste_lemmes)
     return

  def on_text1_button_release_event(self, event):
     """ ajoute dans l'diteur de lemmes la lemmatisation
      du mot cliqu. Si le calcul de la morpho est activ
      dans le menu, affiche aussi la morpho du mot cliqu."""
     if event.button != 1:
        # clic droit : menu contextuel ?
        return
     # reconstituer le mot
     p = edlatin.get_buffer().get_insert()
     d = edlatin.get_buffer().get_iter_at_mark(p)
     d.backward_word_start()
     f = edlatin.get_buffer().get_iter_at_mark(p)
     f.forward_word_end()
     if d.equal(f):
       return
     m = edlatin.get_buffer().get_text(d, f)
     # analyse du mot
     page = widgets['notebook1'].get_current_page()
     if widgets['morphologie1'].active:
        # requte d'analyse morpho
        analyses = collat.chaineAnalyse(m)
     else:
        # lemmatisation simple
        formats = ['texte','html','LaTeX']
        analyses = collat.lemmatisem(m, formats[page])
     # passage en utf8
     analyses = unicode(analyses,'latin1')
     # les widgets textes sont text2, text3 et text4 : il faut ajouter 2  page.
     page_active=widgets['text' + str(page + 2)]
     page_active.get_buffer().insert_at_cursor(analyses)
     return

  def on_window1_motion_notify_event(self, event):
     p = edlatin.window_to_buffer_coords('text', int(event.x), int(event.y))
     d = edlatin.get_iter_at_location(p[0], p[1])
     f = d.copy()
     d.backward_word_start()
     f.forward_word_end()
     if d.equal(f):
         return
     m = edlatin.get_buffer().get_text(d, f)
     # analyse du mot
     analyses = collat.chaineAnalyse(m)
     analyses = unicode(analyses,'latin1')
     #print analyses
     widgets['window1'].tooltips.enable()
     widgets['window1'].tooltips.set_tip(edlatin, analyses) 
     return

  def on_text2_motion_notify_event(self, event):
     widgets['window1'].tooltips.disable()
     return

  def on_effacer_la_lemmatisation1_activate(self):
     """ effacer les diteurs de lemmatisation """
     for id in ( 'text2', 'text3', 'text4'):
       startiter, enditer = widgets[id].get_buffer().get_bounds()
       widgets[id].get_buffer().delete(startiter, enditer)
     return

  def on_coller_dans_le_texte1_activate(t):
     edlatin.emit("paste-clipboard")
     return

  def on_copier_le_texte1_activate(t):
     edlatin.emit("select-all", 1)
     edlatin.emit("copy-clipboard")
     edlatin.emit("select-all", 0)
     return

  def on_copier_la_lemmatisation1_activate(t):
     page = widgets['notebook1'].get_current_page()
     if page == 0:
       editeur = widgets['text2']
     elif page == 1:
       editeur = widgets['text3']
     else:
       editeur = widgets['text4']
     # geler
     # tout slectionner
     editeur.emit("select-all", 1)
     # copier dans le presse-papier
     editeur.emit("copy-clipboard")
     # effacer la slection
     editeur.emit("select-all", 0)
     return

  def on_nouveau1_activate(self):
     """ nouveau texte : tout effacer """ 
     #  crire : dialogue de prcaution
     # effacement
     startiter, enditer = edlatin.get_buffer().get_bounds()
     edlatin.get_buffer().delete(startiter, enditer)
     widgets['effacer_la_lemmatisation1'].activate()
     return
     
  def on_enregistrer_sous1_activate(self):
     global action_fichier 
     action_fichier = 1
     widgets['fileselection1'].show()
     return

class WidgetsWrapper:
    def __init__(self):
        self.widgets = gtk.glade.XML('collatinus.glade')
        self.widgets.signal_autoconnect(GladeHandlers.__dict__)
    # Permet d'crire : widgets['nom_du_widget'].action()
    def __getitem__(self, key):
        return self.widgets.get_widget(key)

widgets = WidgetsWrapper()
edlatin = widgets['text1']
widgets['window1'].tooltips = gtk.Tooltips()
# Problmes avec gtk.Tooltips()
# http://www.mail-archive.com/pygtk@daa.com.au/msg06246.html

def main():
    mainloop()

if __name__ == "__main__":
    main()
