#!/usr/bin/env python

''' This script installs or uninstalls Comix on your system. '''

import os
import shutil
import sys

ISO_CODES = ['sv', 'es', 'zh_CN', 'pt_BR', 'de', 'it', 'nl', 'fr', 'pl']
INSTALL_DIR = '/usr/local'
NO_MIME = 0

def info():
    
    print
    print \
    'Run "python install.py install" as root to install Comix in /usr/local.'
    print \
    'To uninstall, simply run "python install.py uninstall".'
    print
    print \
    'If you wish to install Comix in another base directory, use the', \
    '--installdir'
    print \
    'option. Example: "python install.py install --installdir /usr".'
    print \
    'If you have installed with --installdir, do not forget to use the', \
    'same option'
    print 'when uninstalling.'
    print
    print \
    'By default install.py registers mime types for cbz, cbr and cbt archives'
    print \
    'and installs a thumbnailer that can be used by some file managers (e.g.'
    print \
    'Nautilus) to create thumbnails for these files.'
    print \
    'If you do not want this feature you can install with the --no-mime', \
    'option.'
    print

if len(sys.argv) > 1:
    if len(sys.argv) > 3:
        if '--installdir' in sys.argv[1:-1]:
            INSTALL_DIR = sys.argv[sys.argv.index('--installdir') + 1]
            sys.argv.pop(sys.argv.index('--installdir') + 1)
            sys.argv.pop(sys.argv.index('--installdir'))
    if os.path.isdir(INSTALL_DIR):
        if INSTALL_DIR.endswith('/'):
            INSTALL_DIR = INSTALL_DIR[:-1]
        if len(sys.argv) > 2:
            if '--no-mime' in sys.argv[1:]:    
                NO_MIME = 1
                sys.argv.pop(sys.argv.index('--no-mime'))
        if len(sys.argv) == 2:
            
            # Determine directory for mime files.
            if INSTALL_DIR == '/usr':
                MIME_DIR = '/usr/share/mime'
            elif INSTALL_DIR == '/usr/local':
                MIME_DIR = '/usr/local/share/mime'
            else:
                MIME_DIR = os.getenv('HOME') + '/local/share/mime'
                
            if sys.argv[1] == 'install':
                
                # Check for dependencies
                print 'Checking dependencies...'
                print
                # Should check PyGTK version as well. Must import module gtk
                # for that though, which can't be done when install.py is run
                # by sudo.
                try:
                    import pygtk
                    print '*** PyGTK ... OK'
                except:
                    print '*** PyGTK ... Not found.\n Please install it' + \
                        ' before you use Comix.'
                print
                try:
                    import Image
                    try:
                        assert Image.VERSION >= '1.1.4'
                        print '*** Python Imaging Library ... OK'
                    except:
                        print '*** Python Imaging Library ... version ' + \
                            Image.VERSION + ' found.\n Version 1.1.4 or' + \
                            ' higher is required. Please install it' + \
                            ' before you use Comix.'
                except:
                    print '*** Python Imaging Library ... Not found.\n' + \
                        ' Please install it before you use Comix.'
                print
                if os.popen('unrar 2>&1').close():
                    print '*** Unrar ... Not found.\n Please install it if' + \
                        ' you want Comix to read RAR (.cbr) files.'
                else:
                    print '*** Unrar ... OK'
                print
                print
                
                print 'Installing...'
                print
                # Make new directories if they do not exist.
                if not os.path.exists(INSTALL_DIR + '/bin'):
                    os.makedirs(INSTALL_DIR + '/bin', 0755)
                if not os.path.exists(INSTALL_DIR + 
                    '/share/applications'):
                    os.makedirs(INSTALL_DIR + '/share/applications', 0755)
                if not os.path.exists(INSTALL_DIR + 
                    '/share/icons/hicolor/48x48/apps'):
                    os.makedirs(INSTALL_DIR + 
                        '/share/icons/hicolor/48x48/apps', 0755)
                if not os.path.exists(INSTALL_DIR + 
                    '/share/icons/hicolor/scalable/apps'):
                    os.makedirs(INSTALL_DIR + 
                        '/share/icons/hicolor/scalable/apps', 0755)
                if not os.path.exists(INSTALL_DIR + '/share/man/man1'):
                    os.makedirs(INSTALL_DIR + '/share/man/man1', 0755)
                if not os.path.exists(INSTALL_DIR + '/share/pixmaps/comix'):
                    os.makedirs(INSTALL_DIR + '/share/pixmaps/comix', 0755)
                for lang in ISO_CODES:
                    if not os.path.exists(INSTALL_DIR + '/share/locale/' +
                        lang + '/LC_MESSAGES'):
                        os.makedirs(INSTALL_DIR + '/share/locale/' + lang + 
                            '/LC_MESSAGES', 0755)
                if not NO_MIME:
                    if not os.path.exists(MIME_DIR + '/packages'):
                        os.makedirs(MIME_DIR + '/packages', 0755)
                    
                # If the directories exist, copy the files to them.
                if os.path.isdir(INSTALL_DIR + '/bin'):
                    shutil.copy('comix', INSTALL_DIR + '/bin/comix')
                    os.chmod(INSTALL_DIR + '/bin/comix', 0755)
                    print 'installed ' +  INSTALL_DIR + '/bin/comix'
                    
                if os.path.isdir(INSTALL_DIR + '/share/applications'):
                    shutil.copy('comix.desktop', INSTALL_DIR + 
                        '/share/applications/comix.desktop')
                    os.chmod(INSTALL_DIR + 
                        '/share/applications/comix.desktop', 0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/applications/comix.desktop'
                    
                if os.path.isdir(INSTALL_DIR + '/share/pixmaps'):
                    shutil.copy('images/comix.png', INSTALL_DIR + 
                        '/share/pixmaps/comix.png')
                    os.chmod(INSTALL_DIR + '/share/pixmaps/comix.png', 0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix.png'
                    
                if os.path.isdir(INSTALL_DIR + 
                    '/share/icons/hicolor/48x48/apps'):
                    shutil.copy('images/comix.png', INSTALL_DIR + 
                        '/share/icons/hicolor/48x48/apps/comix.png')
                    os.chmod(INSTALL_DIR + 
                        '/share/icons/hicolor/48x48/apps/comix.png', 0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/icons/hicolor/48x48/apps/comix.png'
                    
                if os.path.isdir(INSTALL_DIR + 
                    '/share/icons/hicolor/scalable/apps'):
                    shutil.copy('images/comix.svg', INSTALL_DIR + 
                        '/share/icons/hicolor/scalable/apps/comix.svg')
                    os.chmod(INSTALL_DIR + 
                        '/share/icons/hicolor/scalable/apps/comix.svg', 0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/icons/hicolor/scalable/apps/comix.svg'
                    
                if os.path.isdir(INSTALL_DIR + '/share/man/man1'):
                    shutil.copy('comix.1.gz', INSTALL_DIR + 
                        '/share/man/man1/comix.1.gz')
                    os.chmod(INSTALL_DIR + '/share/man/man1/comix.1.gz', 0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/man/man1/comix.1.gz'
                    
                    shutil.copy('mime/comicthumb.1.gz', INSTALL_DIR +
                        '/share/man/man1/comicthumb.1.gz')
                    os.chmod(INSTALL_DIR + 
                        '/share/man/man1/comicthumb.1.gz', 0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/man/man1/comicthumb.1.gz'
                    
                if os.path.isdir(INSTALL_DIR + '/share/pixmaps/comix'):
                    shutil.copy('images/stock-flip-horizontal-16.png', 
                        INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-flip-horizontal-16.png')
                    os.chmod(INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-flip-horizontal-16.png', 
                        0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/stock-flip-horizontal-16.png'
                    
                    shutil.copy('images/stock-flip-vertical-16.png', 
                        INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-flip-vertical-16.png')
                    os.chmod(INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-flip-vertical-16.png',
                        0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/stock-flip-vertical-16.png'
                    
                    shutil.copy('images/stock-rotate-180-16.png',
                        INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-rotate-180-16.png')
                    os.chmod(INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-rotate-180-16.png',
                        0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/stock-rotate-180-16.png'
                    
                    shutil.copy('images/stock-rotate-270-16.png', 
                        INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-rotate-270-16.png')
                    os.chmod(INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-rotate-270-16.png', 
                        0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/stock-rotate-270-16.png'
                    
                    shutil.copy('images/stock-rotate-90-16.png', 
                        INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-rotate-90-16.png')
                    os.chmod(INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-rotate-90-16.png', 
                        0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/stock-rotate-90-16.png'
                    
                    shutil.copy('images/cbz.png', INSTALL_DIR + 
                        '/share/pixmaps/comix/cbz.png')
                    os.chmod(INSTALL_DIR + '/share/pixmaps/comix/cbz.png', 
                        0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/cbz.png'
                    
                    shutil.copy('images/cbr.png', INSTALL_DIR +
                        '/share/pixmaps/comix/cbr.png')
                    os.chmod(INSTALL_DIR + '/share/pixmaps/comix/cbr.png',
                        0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/cbr.png'
                    
                    shutil.copy('images/cbt.png', INSTALL_DIR + 
                        '/share/pixmaps/comix/cbt.png')
                    os.chmod(INSTALL_DIR + '/share/pixmaps/comix/cbt.png',
                        0644)
                    print 'installed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/cbt.png'
                
                for lang in ISO_CODES:
                    if os.path.isdir(INSTALL_DIR + '/share/locale/' + lang +
                        '/LC_MESSAGES'):
                        shutil.copy('./messages/' + lang +
                            '/LC_MESSAGES/comix.mo', INSTALL_DIR +
                            '/share/locale/' + lang + '/LC_MESSAGES/comix.mo')
                        os.chmod(INSTALL_DIR + '/share/locale/' + lang +
                            '/LC_MESSAGES/comix.mo', 0644)
                        print 'installed ' +  INSTALL_DIR + \
                            '/share/locale/' + lang + '/LC_MESSAGES/comix.mo'
                    
                if not NO_MIME:
                    
                    if os.path.isdir(MIME_DIR + '/packages'):
                        shutil.copy('./mime/comix.xml', MIME_DIR + 
                            '/packages/comix.xml')
                        os.chmod(MIME_DIR + '/packages/comix.xml', 0644)
                        print 'installed ' + MIME_DIR + '/packages/comix.xml'
                        
                    if os.path.isdir(INSTALL_DIR + '/bin'):
                        shutil.copy('./mime/comicthumb', INSTALL_DIR + 
                            '/bin/comicthumb')
                        os.chmod(INSTALL_DIR + '/bin/comicthumb', 0755)
                        print 'installed ' +  INSTALL_DIR + '/bin/comicthumb'
                        
                    # Update mime database
                    os.popen('update-mime-database "' + MIME_DIR + '"')
                    print
                    print 'Updated mime database.'
                    # Install gconf rules
                    os.popen('export GCONF_CONFIG_SOURCE=`gconftool-2 ' +
                    '--get-default-source 2>/dev/null` && gconftool-2 ' +
                    '--makefile-install-rule ./mime/comicbook.schemas ' +
                    '2>/dev/null')
                    print
                    print 'Registered settings in gconf (if available) for', \
                    'thumbnailer.'
                    print 'The thumbnailer is at this point supported by', \
                    'Nautilus only.'
                    print 'You have to restart Nautilus before it is', \
                    'activated.'
                  
            elif sys.argv[1] == 'uninstall':
                
                # Remove the files if they exist
                if os.path.exists(INSTALL_DIR + '/bin/comix'):
                    os.remove(INSTALL_DIR + '/bin/comix')
                    print 'removed ' +  INSTALL_DIR + '/bin/comix'
                if os.path.exists(INSTALL_DIR + 
                    '/share/applications/comix.desktop'):
                    os.remove(INSTALL_DIR + 
                        '/share/applications/comix.desktop')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/applications/comix.desktop'
                if os.path.exists(INSTALL_DIR + '/share/pixmaps/comix.png'):
                    os.remove(INSTALL_DIR + '/share/pixmaps/comix.png')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix.png'
                if os.path.exists(INSTALL_DIR + 
                    '/share/icons/hicolor/48x48/apps/comix.png'):
                    os.remove(INSTALL_DIR + 
                        '/share/icons/hicolor/48x48/apps/comix.png')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/icons/hicolor/48x48/apps/comix.png'
                if os.path.exists(INSTALL_DIR + 
                    '/share/icons/hicolor/scalable/apps/comix.svg'):
                    os.remove(INSTALL_DIR + 
                        '/share/icons/hicolor/scalable/apps/comix.svg')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/icons/hicolor/scalable/apps/comix.svg'
                if os.path.exists(INSTALL_DIR + '/share/man/man1/comix.1.gz'):
                    os.remove(INSTALL_DIR + '/share/man/man1/comix.1.gz')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/man/man1/comix.1.gz'
                if os.path.exists(INSTALL_DIR + 
                    '/share/man/man1/comicthumb.1.gz'):
                    os.remove(INSTALL_DIR + 
                        '/share/man/man1/comicthumb.1.gz')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/man/man1/comicthumb.1.gz'
                if os.path.exists(INSTALL_DIR + 
                    '/share/pixmaps/comix/stock-flip-horizontal-16.png'):
                    os.remove(INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-flip-horizontal-16.png')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/stock-flip-horizontal-16.png'
                if os.path.exists(INSTALL_DIR + 
                    '/share/pixmaps/comix/stock-flip-vertical-16.png'):
                    os.remove(INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-flip-vertical-16.png')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/stock-flip-vertical-16.png'
                if os.path.exists(INSTALL_DIR + 
                    '/share/pixmaps/comix/stock-rotate-180-16.png'):
                    os.remove(INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-rotate-180-16.png')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/stock-rotate-180-16.png'
                if os.path.exists(INSTALL_DIR + 
                    '/share/pixmaps/comix/stock-rotate-270-16.png'):
                    os.remove(INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-rotate-270-16.png')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/stock-rotate-270-16.png'
                if os.path.exists(INSTALL_DIR + 
                    '/share/pixmaps/comix/stock-rotate-90-16.png'):
                    os.remove(INSTALL_DIR + 
                        '/share/pixmaps/comix/stock-rotate-90-16.png')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/stock-rotate-90-16.png'
                if os.path.exists(INSTALL_DIR + 
                    '/share/pixmaps/comix/cbz.png'):
                    os.remove(INSTALL_DIR + '/share/pixmaps/comix/cbz.png')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/cbz.png'
                if os.path.exists(INSTALL_DIR + 
                    '/share/pixmaps/comix/cbr.png'):
                    os.remove(INSTALL_DIR + '/share/pixmaps/comix/cbr.png')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/cbr.png'
                if os.path.exists(INSTALL_DIR + 
                    '/share/pixmaps/comix/cbt.png'):
                    os.remove(INSTALL_DIR + '/share/pixmaps/comix/cbt.png')
                    print 'removed ' +  INSTALL_DIR + \
                        '/share/pixmaps/comix/cbt.png'    
                for lang in ISO_CODES:
                    if os.path.exists(INSTALL_DIR + '/share/locale/' + lang +
                        '/LC_MESSAGES/comix.mo'):
                        os.remove(INSTALL_DIR + '/share/locale/' + lang +
                            '/LC_MESSAGES/comix.mo')
                        print 'removed ' +  INSTALL_DIR + '/share/locale/' + \
                            lang + '/LC_MESSAGES/comix.mo'
                if os.path.exists(MIME_DIR + '/packages/comix.xml'):
                    os.remove(MIME_DIR + '/packages/comix.xml')
                    print 'removed ' +  MIME_DIR + '/packages/comix.xml'
                if os.path.exists(INSTALL_DIR + '/bin/comicthumb'):
                    os.remove(INSTALL_DIR + '/bin/comicthumb')
                    print 'removed ' +  INSTALL_DIR + '/bin/comicthumb'
                if os.path.exists('/tmp/comix'):    
                    shutil.rmtree('/tmp/comix')
                    print 'removed /tmp/comix'
                # Update mime database
                os.popen('update-mime-database "' + MIME_DIR + '"')
                print
                print 'Updated mime database.'
                # Uninstall gconf rules
                os.popen('export GCONF_CONFIG_SOURCE=`gconftool-2 ' + 
                '--get-default-source 2>/dev/null` && gconftool-2 ' +
                '--makefile-uninstall-rule ./mime/comicbook.schemas ' + 
                '2>/dev/null')
                print
                print 'Removed settings from gconf (if available).'
                    
            else:
                info()
        else:
            info()
    else:
        print
        print INSTALL_DIR, 'does not exist.'
        info()
else:
    info()   
