/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt42;

import condor.gahp.GahpInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.globus.axis.message.addressing.EndpointReferenceType;
import org.globus.delegation.DelegationUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.utils.AddressingUtils;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public abstract class GSIUtils {
    public static final String DEFAULT = "DEFAULT";
    private static final String CURRENT_GSI_CREDENTIAL = "CURRENT_GSI_CREDENTIAL";
    public static final String GSI_CREDENTIAL = "GSI_CREDENTIAL : ";

    public static GSSCredential getCredential(GahpInterface gahpInterface) {
        GSSCredential gSSCredential = GSIUtils.getCurrentCredential(gahpInterface);
        if (gSSCredential == null) {
            gSSCredential = GSIUtils.getDefaultCredential(gahpInterface);
        }
        return gSSCredential;
    }

    public static GSSCredential getDefaultCredential(GahpInterface gahpInterface) {
        GSSCredential gSSCredential = null;
        gSSCredential = (GSSCredential)gahpInterface.getObject("GSI_CREDENTIAL : DEFAULT");
        return gSSCredential;
    }

    public static GSSCredential getCurrentCredential(GahpInterface gahpInterface) {
        GSSCredential gSSCredential = null;
        gSSCredential = (GSSCredential)gahpInterface.getObject(CURRENT_GSI_CREDENTIAL);
        return gSSCredential;
    }

    public static void setDefaultCredential(GahpInterface gahpInterface, GSSCredential gSSCredential) {
        GlobusCredential.setDefaultCredential((GlobusCredential)((GlobusGSSCredentialImpl)gSSCredential).getGlobusCredential());
        gahpInterface.storeObject("GSI_CREDENTIAL : DEFAULT", gSSCredential);
    }

    public static void cacheCredential(GahpInterface gahpInterface, String string, GSSCredential gSSCredential) {
        gahpInterface.storeObject(GSI_CREDENTIAL + string, gSSCredential);
    }

    public static void setCurrentCredential(GahpInterface gahpInterface, String string) throws Exception {
        GSSCredential gSSCredential = (GSSCredential)gahpInterface.getObject(GSI_CREDENTIAL + string);
        if (gSSCredential == null) {
            throw new Exception("Non-existent credential id " + string);
        }
        gahpInterface.storeObject(CURRENT_GSI_CREDENTIAL, gSSCredential);
    }

    public static void deleteCredential(GahpInterface gahpInterface, String string) throws Exception {
        GSSCredential gSSCredential = (GSSCredential)gahpInterface.getObject(GSI_CREDENTIAL + string);
        if (gSSCredential == null) {
            throw new Exception("Invalid credential id " + string);
        }
        gahpInterface.removeObject(string);
        if (gSSCredential == GSIUtils.getCurrentCredential(gahpInterface)) {
            gahpInterface.removeObject(CURRENT_GSI_CREDENTIAL);
        }
    }

    public static GSSCredential readCredentialFromFile(String string) throws IOException, GSSException {
        byte[] byArray = new byte[4096];
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("File " + string + " does not exist");
        }
        FileInputStream fileInputStream = new FileInputStream(file.getAbsolutePath());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        do {
            if ((n = fileInputStream.read(byArray)) <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, n);
        } while (n > 0);
        fileInputStream.close();
        ExtendedGSSManager extendedGSSManager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
        GSSCredential gSSCredential = extendedGSSManager.createCredential(byteArrayOutputStream.toByteArray(), 0, 0, null, 0);
        return gSSCredential;
    }

    public static X509Certificate getCertificateToSign(String string, ClientSecurityDescriptor clientSecurityDescriptor) throws Exception {
        EndpointReferenceType endpointReferenceType = AddressingUtils.createEndpointReference((String)string, null);
        X509Certificate[] x509CertificateArray = DelegationUtil.getCertificateChainRP((EndpointReferenceType)endpointReferenceType, (ClientSecurityDescriptor)clientSecurityDescriptor);
        return x509CertificateArray[0];
    }
}

