/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt42;

import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.globus.axis.message.addressing.EndpointReferenceType;
import org.globus.exec.client.GramJob;
import org.globus.exec.generated.ManagedJobFactoryPortType;
import org.globus.exec.generated.ManagedJobPortType;
import org.globus.exec.utils.service.ManagedJobHelper;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.security.authorization.client.Authorization;
import org.globus.wsrf.utils.AddressingUtils;
import org.ietf.jgss.GSSCredential;

public class GramJobUtils {
    public static void setDefaultJobAttributes(GramJob gramJob, GSSCredential gSSCredential) {
        gramJob.setTimeOut(300000);
        gramJob.setAuthorization((Authorization)HostAuthorization.getInstance());
        gramJob.setMessageProtectionType(Constants.SIGNATURE);
        gramJob.setCredentials(gSSCredential);
    }

    public static void setDefaultJobAttributes(ManagedJobPortType managedJobPortType, GSSCredential gSSCredential) {
        GramJobUtils.setDefaultAttributes((Stub)managedJobPortType, gSSCredential);
    }

    public static void setDefaultAttributes(Stub stub, GSSCredential gSSCredential) {
        ClientSecurityDescriptor clientSecurityDescriptor = new ClientSecurityDescriptor();
        clientSecurityDescriptor.setGSISecureTransport(Constants.SIGNATURE);
        clientSecurityDescriptor.setAuthz((Authorization)HostAuthorization.getInstance());
        if (gSSCredential != null) {
            clientSecurityDescriptor.setGSSCredential(gSSCredential);
        }
        stub._setProperty("clientDescriptor", (Object)clientSecurityDescriptor);
    }

    public static void setDefaultFactoryAttributes(ManagedJobFactoryPortType managedJobFactoryPortType, GSSCredential gSSCredential) {
        ((Stub)managedJobFactoryPortType)._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
        ((Stub)managedJobFactoryPortType)._setProperty("org.globus.security.secMsg.msg.type", (Object)Constants.SIGNATURE);
        if (gSSCredential != null) {
            ((Stub)managedJobFactoryPortType)._setProperty("org.globus.gsi.credentials", (Object)gSSCredential);
        }
    }

    public static EndpointReferenceType getEndpoint(String string) throws Exception {
        EndpointReferenceType endpointReferenceType = null;
        if (string.indexOf("DelegationService") != -1) {
            QName qName = new QName("http://www.globus.org/08/2004/delegationService", "DelegationKey");
            int n = string.indexOf("?") + 1;
            String string2 = string.substring(n);
            String string3 = string.substring(0, n - 1);
            SimpleResourceKey simpleResourceKey = new SimpleResourceKey(qName, (Object)string2);
            endpointReferenceType = AddressingUtils.createEndpointReference((String)string3, (ResourceKey)simpleResourceKey);
        } else if (string.indexOf("ManagedExecutableJobService") != -1) {
            endpointReferenceType = ManagedJobHelper.getEndpoint((String)string);
        }
        return endpointReferenceType;
    }
}

