/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt4;

import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.GahpInterface;
import condor.gahp.gt4.GSIUtils;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.axis.util.Util;
import org.globus.delegation.DelegationConstants;
import org.globus.delegation.DelegationUtil;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;
import org.globus.wsrf.utils.AddressingUtils;
import org.ietf.jgss.GSSCredential;

public class RefreshCredentialHandler
implements CommandHandler {
    private GahpInterface gahp;

    public void setGahp(GahpInterface gahpInterface) {
        this.gahp = gahpInterface;
    }

    public CommandHandlerResponse handleCommand(String[] stringArray) {
        Integer n;
        String string = null;
        Date date = null;
        try {
            n = new Integer(stringArray[1]);
            string = stringArray[2];
            if (stringArray[0].equals("GT4_REFRESH_CREDENTIAL_2")) {
                long l = Long.parseLong(stringArray[3]);
                if (l > 0L) {
                    date = new Date(l * 1000L);
                }
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.add(10, 12);
                date = calendar.getTime();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        GSSCredential gSSCredential = GSIUtils.getCredential(this.gahp);
        return new CommandHandlerResponse("S", (Runnable)new RefreshCredentialRunnable(n, string, this.gahp, gSSCredential, date));
    }

    static class RefreshCredentialRunnable
    implements Runnable {
        private int requestId;
        private String delegationURI;
        private GahpInterface gahp;
        private GSSCredential proxy;
        private Date credTermTime;

        public RefreshCredentialRunnable(int n, String string, GahpInterface gahpInterface, GSSCredential gSSCredential, Date date) {
            this.requestId = n;
            this.delegationURI = string;
            this.gahp = gahpInterface;
            this.proxy = gSSCredential;
            this.credTermTime = date;
        }

        public void run() {
            try {
                int n;
                QName qName = new QName(DelegationConstants.NS, "DelegationKey");
                int n2 = this.delegationURI.indexOf("?") + 1;
                String string = this.delegationURI.substring(n2);
                String string2 = this.delegationURI.substring(0, n2 - 1);
                SimpleResourceKey simpleResourceKey = new SimpleResourceKey(qName, (Object)string);
                EndpointReferenceType endpointReferenceType = AddressingUtils.createEndpointReference((String)string2, (ResourceKey)simpleResourceKey);
                String string3 = new URL(endpointReferenceType.getAddress().getScheme(), endpointReferenceType.getAddress().getHost(), endpointReferenceType.getAddress().getPort(), "/wsrf/services/DelegationFactoryService").toString();
                ClientSecurityDescriptor clientSecurityDescriptor = new ClientSecurityDescriptor();
                clientSecurityDescriptor.setGSITransport(GSIConstants.SIGNATURE);
                Util.registerTransport();
                clientSecurityDescriptor.setAuthz((Authorization)HostAuthorization.getInstance());
                X509Certificate x509Certificate = GSIUtils.getCertificateToSign(string3, clientSecurityDescriptor);
                GlobusCredential globusCredential = ((GlobusGSSCredentialImpl)this.proxy).getGlobusCredential();
                if (this.credTermTime == null) {
                    n = new Long(globusCredential.getTimeLeft()).intValue();
                } else {
                    long l = (this.credTermTime.getTime() - new Date().getTime()) / 1000L;
                    n = new Long(l).intValue();
                }
                DelegationUtil.refresh((GlobusCredential)globusCredential, (X509Certificate)x509Certificate, (int)n, (boolean)true, (ClientSecurityDescriptor)clientSecurityDescriptor, (EndpointReferenceType)endpointReferenceType);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                String string = exception.toString();
                if (string == null) {
                    string = "unknown";
                }
                this.gahp.addResult(this.requestId, new String[]{"1", string});
                return;
            }
            this.gahp.addResult(this.requestId, new String[]{"0", "NULL"});
        }
    }
}

