'*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
' Generator   : PPWIZARD version 07.223
'             : FREE tool for Windows, OS/2, DOS and UNIX by Dennis Bareis (dbareis@gmail.com)
'             : http://dennisbareis.com/ppwizard.htm
' Time        : Thursday, 18 Oct 2007 5:59:36pm
' Input File  : C:\DBAREIS\Projects\Win32\MakeMsi\MsiSync.v
' Output File : C:\DBAREIS\Projects\Win32\MakeMsi\out\MsiSync.VBS
'*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+



'*****************************************************************************
'*** Simple tool (C)opyright Dennis Bareis 2003-2007. All rights reserved. ***
'*****************************************************************************


if Wscript.Arguments.Count = 1 then if Wscript.Arguments(0) = "!CheckSyntax!" then wscript.quit(21924)


const ForAppending = 8
dim LogFileQueue   : LogFileQueue = ""
dim LogFileName    : LogFileName  = ""
dim LogIndent      : LogIndent    = 0
Log "MSISYNC version 07.252 starting..."
Log ""
set oInstaller  = MkObject("WindowsInstaller.Installer")
set oFs         = MkObject("Scripting.FileSystemObject")
set oShell      = MkObject("WScript.Shell")
const msiOpenDatabaseModeReadOnly   = 0
const msiInstallStateDefault        = 5
const PID_PACKAGECODE               = 9
const ForWriting                    = 2
const ERROR_INSTALL_ALREADY_RUNNING = 1618
const ERROR_SUCCESS_REBOOT_REQUIRED = 3010
const MsgBoxTitle                 = "MsiSync.VBS (07.252)"
LockFlagFile  = GetEnv("TEMP") & "\MsiSyncLockFile.TMP"
CurrentMsi      = ""
FinalMessage    = ""
Need2Reboot     = false
Log ""
Log "Looking for a configuration file..."
LogInc()
ScriptDir = oFS.GetParentFolderName(wscript.ScriptFullName)
dim XmlCfgFile
if  wscript.arguments.count = 1 then
XmlCfgFile = wscript.arguments(0)
Log "The configuration file """ & XmlCfgFile & """ was specified on the command line"
if  not oFS.FileExists(XmlCfgFile) then
Error "The XML configuration file """ & XmlCfgFile & """ specified on the command line doesn't exist!"
end if
else
if  wscript.arguments.count <> 0 then
error "We got " & wscript.arguments.count & " command line parameters, only expected 0 or one (XML configuration file)."
end if
XmlCfgFile = ScriptDir & "\" & oFS.GetBaseName(wscript.ScriptFullName) & ".XML"
Log "The default configuration filename is  """ & XmlCfgFile & """."
LogInc()
if  oFS.FileExists(XmlCfgFile) then
Log "It exists!"
else
Log "It doesn't exist!"
XmlCfgFile = ""
end if
LogDec()
end if
LogDec()
Log ""
dim oDOM
on error resume next
if  XmlCfgFile = "" then
set oDOM = Nothing
else
Log "Loading the configuration file """ & XmlCfgFile & """ into a DOM object"
LogInc()
Log "Create and preparing DOM object"
set oDOM              = MkObject("MsXml2.DOMDocument")
oDOM.ValidateOnParse  = false
oDOM.Async            = false
oDOM.ResolveExternals = false
Log "Loading the file"
ItWorked = oDOM.Load(XmlCfgFile)
if  err.number <> 0 then
error "Fatal (non parsing?) error reading the XML file """ & XmlCfgFile & """." &  vbCRLF & vbCRLF & "Reason 0x" & hex(err.number) & " - " & err.description
end if
if not ItWorked then
set oParseError = oDOM.ParseError
ErrPos = oParseError.filepos + 1
error "Failed loading the XML configuration file """ & XmlCfgFile & """." & vbCRLF & "Return Code = 0x" & hex(oParseError.errorcode) & vbCRLF & "Description = " & oParseError.Reason
end if
'    dim ValRc
'    set ValRc = oDOM.validate()
'    msgbox "err.number=" & err.number & ", ValRc.errorCode=" & ValRc.errorCode & ", ValRc.reason=" & ValRc.reason
Log "Successful!"
LogDec()
end if
Log ""
Log "Reading configuration from the XML DOM object"
LogInc()
dim TestMode                       : TestMode                = "N"
dim DialogDebugItemInXML           : DialogDebugItemInXML    = "Y"
dim DialogDebugItemNotInXML        : DialogDebugItemNotInXML = "Y"
TestMode                  = XmlCfgYn("//MsiSync/@Test",                       "N")
LogFileName               = XmlCfg("//MsiSync/Log/@Name",                     "")
if  LogFileName = "" then
LogFileName = GetEnv("TEMP") & "\MsiSyncLog.txt"
end if
DialogDebugItemInXML      = XmlCfgYn("//MsiSync/Dialogs/DebugCfgItemFoundInXml/@Show",    "No")
DialogDebugItemNotInXML   = XmlCfgYn("//MsiSync/Dialogs/DebugCfgItemNotFoundInXml/@Show", "Yes")
dim DefaultQuietSwitches           : DefaultQuietSwitches  = "/qb"
dim DefaultRebootSwitches          : DefaultRebootSwitches = "REBOOT=ReallySuppress"
dim DirList                        : DirList                          = XmlCfg("//MsiSync/MsiSource/Directory",            "?")
dim Mask                           : Mask                             = XmlCfg("//MsiSync/MsiSource/MsiReMask",            "\.MSI$")
dim LockMaxAttempts                : LockMaxAttempts                  = XmlCfg("//MsiSync/Retries/StartupLock/@Tries",     "60")
dim LockSecondsBetweenAttempts     : LockSecondsBetweenAttempts       = XmlCfg("//MsiSync/Retries/StartupLock/@Delay",     "30")
dim MsiInUseMaxAttempts            : MsiInUseMaxAttempts              = XmlCfg("//MsiSync/Retries/MsiInUse/@Tries",        "60")
dim MsiInUseSecondsBetweenAttempts : MsiInUseSecondsBetweenAttempts   = XmlCfg("//MsiSync/Retries/MsiInUse/@Delay",        "30")
dim MsiExeUiSwitchesForInstall     : MsiExeUiSwitchesForInstall       = XmlCfgMsiExecParameters("Install")
dim MsiExeUiSwitchesForUninstall   : MsiExeUiSwitchesForUninstall     = XmlCfgMsiExecParameters("Uninstall")
dim DialogShowFinal                : DialogShowFinal                  = XmlCfgYn("//MsiSync/Dialogs/Final/@Show",                     "Yes")
dim DialogShowFinalNoFilesFound    : DialogShowFinalNoFilesFound      = XmlCfgYn("//MsiSync/Dialogs/FinalNoFilesFound/@Show",         "Yes")
dim DialogShowFinalNothingDone     : DialogShowFinalNothingDone       = XmlCfgYn("//MsiSync/Dialogs/FinalNothingDone/@Show",          "No")
dim DialogShowFinalNeedReboot      : DialogShowFinalNeedReboot        = XmlCfgYn("//MsiSync/Dialogs/FinalNeedReboot/@Show",           "Yes")
dim BeepCntAtEndIfNoDialog         : BeepCntAtEndIfNoDialog           = XmlCfg("//MsiSync/Beeps/AtEndIfNoDialog/@Number", "1")
set oDOM = Nothing
LogDec()
on error goto 0
if  TestMode = "Y" then
Debug "Exiting MSISYNC without doing anything as we are in test mode (Test=""Yes"" on the MsiSync tag)..."
wscript.quit 666
end if
dim LockSelfStream : set LockSelfStream = Nothing
if  not GetLock() then
Log "Quietly exiting as another MSISYNC is already running!"
wscript.quit 666
end if
on error resume next
set oMask        = new RegExp
if err.number <> 0 then
error("Could not create a regular expression (""new RegExp""), windows clagged (""VBSCRIPT.DLL"" needs registration)?")
end if
on error goto 0
oMask.IgnoreCase = true
oMask.Pattern    = Mask
dim TotalFileCount   : TotalFileCount   = 0
dim MatchedFileCount : MatchedFileCount = 0
Log ""
ProcessListOfDirectories DirList
ReleaseLock()
set oInstaller = Nothing
if  FinalMessage = "" then
dim DlgDisplayed : DlgDisplayed = "N"
if  DialogShowFinalNoFilesFound = "Y" and MatchedFileCount = 0 then
Info "We did not find any matching files (out of the " & TotalFileCount & " files found)."
DlgDisplayed = "Y"
else
if  DialogShowFinalNothingDone = "Y" then
Info "There was nothing to do. You are up to date."
DlgDisplayed = "Y"
end if
end if
if  DlgDisplayed = "N" then
Beep(BeepCntAtEndIfNoDialog)
end if
else
if  DialogShowFinal = "Y" then
Info FinalMessage
end if
end if
if Need2Reboot then
if   DialogShowFinalNeedReboot = "Y" then
dim Text : Text = "YOU NEED TO REBOOT!" & vbCRLF & vbCRLF & "You need to reboot to complete the install. Please do so at your earliest convenience."
if  DialogShowFinal = "N" then
Text= Text & vbCRLF & vbCRLF & FinalMessage
end if
Info Text
end if
end if
Log "Finished!"
wscript.quit 0




'=========================================================================
function XmlCfgMsiExecParameters(WhatType)
'=========================================================================
dim XpathBase : XpathBase = "//MsiSync/" & WhatType & "/MsiExec.EXE/"
XmlCfgMsiExecParameters =                                            _
XmlCfg(XpathBase & "QuietSwitches",    DefaultQuietSwitches)  & _
" "                                                           & _
XmlCfg(XpathBase & "RebootSwitches",   DefaultRebootSwitches) & _
" "                                                           & _
XmlCfg(XpathBase & "OtherSwitches",    "")
if  TestMode = "Y" then
Debug "The MSIEXEC.EXE command line switches for " & WhatType & "s are:" & vbCRLF & vbCRLF & XmlCfgMsiExecParameters
end if
end function


'=========================================================================
function XmlCfg(ByVal XPath, ByVal Default)
'=========================================================================
on error resume next
Log "Looking for CFG item: " & XPath
LogInc()
dim oNode : set oNode = oDOM.selectSingleNode(XPath)
dim DefaultUsed
if  err.number <> 0 or oNode is Nothing then
Log "Not configured, using default: " & Default
XmlCfg      = Default
DefaultUsed = true
else
XmlCfg      = oNode.Text
DefaultUsed = false
Log "Found it: " & XmlCfg
end if
set oNode = Nothing
XmlCfg = EnvVarReplace(XmlCfg)
if  TestMode = "Y" then
dim T, ShowDlg
T = "Configuration for """ & XPATH & """." & vbCRLF & vbCRLF
if  DefaultUsed then
ShowDlg = DialogDebugItemNotInXML
T = T & "The default value of """ & Default & """ was used."
else
ShowDlg = DialogDebugItemInXML
T = T & "The value of """ & XmlCfg & """ was found in the configuration file!"
if  XmlCfg <> Default then
T = T & vbCRLF & vbCRLF & "The default value of """ & Default & """ was not used."
end if
end if
if  ShowDlg = "Y" then
Debug T
end if
end if
LogDec()
end function


'=========================================================================
function XmlCfgYn(ByVal XPath, ByVal Default)
'=========================================================================
on error resume next
dim Rv : Rv = XmlCfg(XPath, Default)
dim L1 : L1 = ucase(left(trim(Rv), 1))
if  L1 <> "Y" and L1 <> "N" then
error "The configuration for the property """ & XPath & """ did not contain ""Y"" or ""N"". It contained """ & Rv & """!"
else
Rv = L1
end if
XmlCfgYn = Rv
end function


'============================================================================
sub ProcessListOfDirectories(DirList)
'============================================================================
Log "Processing directory list """ & DirList & """"
LogInc()
dim ListofDirsNotFound : ListofDirsNotFound = ""
dim Dirs, i
Dirs = split(DirList, ";")
for i = lbound(Dirs) to ubound(Dirs)
dim Dir : Dir = trim( Dirs(i) )
Dir = replace(Dir, "?", ScriptDir)      '"?" means script directory
if  left(Dir, 1) = "-" then
Tree = false
Dir  = mid(Dir, 2)
elseif  left(Dir, 1) = "+" then
Tree = true
Dir  = mid(Dir, 2)
else
Tree = true
end if
if  Dir <> "" then
Log ""
dim AbsDir : AbsDir = oFS.GetAbsolutePathName(Dir)
if  lcase(AbsDir) <> lcase(Dir) then
Log "Converted directory """ & Dir & """ to full name """ & AbsDir & """"
end if
if  not oFS.FolderExists(Dir) then
Log "The directory """ & AbsDir & """ doesn't exist!"
ListofDirsNotFound = ListofDirsNotFound & "  * " & AbsDir & vbCRLF
else
ProcessMask AbsDir, Tree
end if
end if
next
if  ListofDirsNotFound <> "" then
error "These MSI source directories don't exist:" & vbCRLF & ListofDirsNotFound
end if
LogDec()
end sub


'============================================================================
sub ProcessMask(byVal Dir, ByVal FollowSubDirs)
'============================================================================
Log "Starting processing of """ & Dir & """ (whole tree = " & FollowSubDirs & ")"
LogInc()
if  not oFS.FolderExists(Dir) then
Error("The folder """ & Dir & """ does not exist!")
end if
Log "Processing files in the directory """ & Dir & """"
LogInc()
set oFolder = oFS.GetFolder(Dir)
set oFiles  = oFolder.Files
for each oFile in oFiles
TotalFileCount = TotalFileCount + 1
Log "FILE: " & oFile.name
if  oMask.test(oFile.name) then
LogInc()
MatchedFileCount = MatchedFileCount + 1
UpgradeProductIfRequired oFile.Path
LogDec()
end if
next
LogDec()
if  FollowSubDirs then
Log "Processing subdirectories in the directory """ & Dir & """"
LogInc()
set oDirs  = oFolder.SubFolders
for each oDir in oDirs
Log "DIR: " & oDir.name
LogInc()
ProcessMask oDir.PATH, FollowSubDirs
LogDec()
next
LogDec()
end if
Log "Finished processing of """ & Dir & """"
LogDec()
end sub

'=========================================================================
sub UpgradeProductIfRequired(ByVal FullMsiName)
'=========================================================================
on error resume next
dim Need2Install : Need2Install = false
CurrentMsi = FullMsiName
Log "Processing """ & FullMsiName & """"
LogInc()
Log "Opening the MSI..."
LogInc()
dim oMsi, oView, oRec
set oMsi = oInstaller.OpenDatabase(FullMsiName, msiOpenDatabaseModeReadOnly) : MsiError("Opening the CURRENT database """ & FullMsiName & """")
set oView = ViewOpen(oMSI, "SELECT `Value` FROM `Property` WHERE `Property` = 'ProductCode'")
if  oView is Nothing then exit sub
set oRec  = ViewFetch(oView)
if  oRec is nothing then
Error("Could not find the ""ProductCode"" in """ & FullMsiName & """")
else
dim ProductCode  : ProductCode  = oRec.StringData(1)
Log "ProductCode = " & ProductCode
dim ProductState : ProductState = oInstaller.ProductState(ProductCode)
if  ProductState <> msiInstallStateDefault then
Log "+Product is not installed"
Need2Install = true
else
LogInc()
Log "Product is installed"
InstalledPackageCode = oInstaller.ProductInfo(ProductCode, "PackageCode")
Log "Installed package code is: " & InstalledPackageCode
set oSummary   = oMsi.SummaryInformation(1)
NewPackageCode = oSummary.Property(PID_PACKAGECODE)
Log "MSI package code is: " & NewPackageCode
set oSummary   = Nothing
if  InstalledPackageCode <> NewPackageCode then
Log "+Need to install as package codes differ"
Need2Install = true
else
LogInc()
Log "Package codes are the same, lets check version numbers as well"
InstalledVersion = oInstaller.ProductInfo(ProductCode, "VersionString")
Log "Installed Version: " & InstalledVersion
set oView = ViewOpen(oMSI, "SELECT `Value` FROM `Property` WHERE `Property` = 'ProductVersion'")
if  oView is Nothing then exit sub
set oRec  = ViewFetch(oView)
if  oRec is nothing then
Error("Could not find the ""ProductVersion"" in """ & FullMsiName & """")
else
NewVersion = oRec.StringData(1)
Log "MSI Version: " & NewVersion
if  NewVersion <> InstalledVersion then
Log "+Need to install as version numbers differ"
Need2Install = true
end if
end if
LogDec()
end if
LogDec()
end if
end if
LogDec()
if  not Need2Install then
Log "We don't need to install the MSI."
else
Log "We want to install the MSI!"
dim UpgradeCode : UpgradeCode = ""
set oView = ViewOpen(oMSI, "SELECT `Value` FROM `Property` WHERE `Property` = 'UpgradeCode'")
if  oView is Nothing then exit sub
set oRec  = ViewFetch(oView)
if  oRec is nothing then
Error("Could not find the ""UpgradeCode"" in """ & FullMsiName & """")
else
UpgradeCode = oRec.StringData(1)
end if
Log "Its upgrade code is: " & UpgradeCode
Log "Looking for installed related products to uninstall"
dim Cmd, MsiExecRc
dim oRelated : set oRelated = oInstaller.RelatedProducts(UpgradeCode)
if  err.number = 0 then
for each RelatedPackageCode in oRelated
Log "Removing package: " & RelatedPackageCode
LogInc()
dim UninstallProductName : UninstallProductName = oInstaller.ProductInfo(RelatedPackageCode, "InstalledProductName")
dim UninstallProductVer  : UninstallProductVer  = oInstaller.ProductInfo(RelatedPackageCode, "VersionString")
Cmd       = "MSIEXEC.EXE /x """ & RelatedPackageCode & """ "  & MsiExeUiSwitchesForUninstall
Log "Executing: " & Cmd
LogInc()
MsiExecRc = oShell.run("%comspec% /c " & Cmd, 0, True)
if  MsiExecRc = ERROR_SUCCESS_REBOOT_REQUIRED then
Need2Reboot = true
MsiExecRc   = "Reboot Requested (" & ERROR_SUCCESS_REBOOT_REQUIRED & ")"
end if
Log "RC = " & MsiExecRc
FinalMessage = FinalMessage & "UNINSTALL: " & UninstallProductName & " - " & UninstallProductVer & ", RC=" & MsiExecRc & vbCRLF
LogDec()
LogDec()
next
end if
Log "Installing the MSI..."
LogInc()
Cmd = "MSIEXEC.EXE /I """ & FullMsiName & """ " & MsiExeUiSwitchesForInstall
Log "Executing: " & Cmd
LogInc()
MsiExecRc = oShell.run("%comspec% /c " & Cmd, 0, True)
if  MsiExecRc = ERROR_SUCCESS_REBOOT_REQUIRED then
Need2Reboot = true
MsiExecRc   = "Reboot Requested (" & ERROR_SUCCESS_REBOOT_REQUIRED & ")"
end if
Log "RC = " & MsiExecRc
FinalMessage = FinalMessage & "INSTALL: """ & FullMsiName & """, RC=" & MsiExecRc & vbCRLF
LogDec()
LogDec()
end if
ViewClose(oView)
CurrentMsi = ""
set oRec  = Nothing
set oView = Nothing
set oMsi  = Nothing
LogDec()
end sub

'=========================================================================
function MsiExecRetryIfLocked(ByVal Cmd)
' Executes the required MSIEXEC.EXE command.
' If it reports that another is in progress, it will retry until
' configured limits.
'=========================================================================
dim TryNumber
for TryNumber = 1 to MsiInUseMaxAttempts
MsiExecRetryIfLocked = oShell.run("%comspec% /c " & Cmd, 0, True)
if  MsiExecRetryIfLocked <> ERROR_INSTALL_ALREADY_RUNNING then
exit function
end if
wscript.sleep MsiInUseSecondsBetweenAttempts * 1000
next
error "MSIEXEC.EXE is locked. Had " & MsiInUseMaxAttempts & " attempts."
end function

'=========================================================================
function ViewOpen(oMSI, ByVal Sql)
'=========================================================================
on error resume next
set ViewOpen = oMSI.OpenView(Sql)
if  MsiError("Opening View - " & Sql) <> 0 then
set ViewOpen = Nothing
exit function
end if
ViewOpen.Execute
if  MsiError("Executing View - " & Sql) <> 0 then
set ViewOpen = Nothing
end if
end function

'=========================================================================
function ViewFetch(ByRef oView)
'=========================================================================
on error resume next
set ViewFetch = oView.Fetch()
if  MsiError("Fetching a record") <> 0 then
set ViewFetch = Nothing
end if
end function

'=========================================================================
sub ViewClose(ByRef oView)
'=========================================================================
on error resume next
oView.close
MsiError "Closing a view"
set oView = Nothing
end sub

'=========================================================================
function MkObject(ByVal AutomationClass)   'Create object, die on error
'=========================================================================
on error resume next
set MkObject = CreateObject(AutomationClass)
if  err.number <> 0 then
Error "Failed loading the automation class """ & AutomationClass & """." & vbCRLF & "This is likely to be due to a Windows configuration problem of some type." & vbCRLF & vbCRLF & "Reason 0x" & hex(err.number) & " - " & err.description
end if
end function

'=========================================================================
function MsiError(ByVal Doing)
'=========================================================================
dim Msg, oLast
If  err.number <> 0 then
Msg = Doing & vbCRLF & vbCRLF & err.Source & " 0x" & Hex(err.number) & ": " & err.Description
If  Not oInstaller Is Nothing Then
Set oLast = oInstaller.LastErrorRecord
If  Not oLast Is Nothing Then
Msg = Msg & vbNewLine & oLast.FormatText
end if
end if
Error(Msg)
end if
end function

'=========================================================================
sub Error(ByVal Text)
'=========================================================================
LogIndent = 0
Log ""
Log "ERROR"
Log "~~~~~"
Log Text
dim Title : Title = MsgBoxTitle
if  CurrentMsi <> "" then
Title = Title & " - " & CurrentMsi
end if
Text = Text & vbCRLF & vbCRLF & "This program is now terminating..."
MsgBox Text, vbCritical, Title
ExitRc 999
end sub

'=========================================================================
sub InfoBox(ByVal Text, IsDebug)
'=========================================================================
on error resume next
dim Title : Title = MsgBoxTitle
dim Icon  : Icon  = vbInformation
if  IsDebug then
Icon  = vbExclamation
Title = "DEBUG BOX: " & Title
end if
Log ""
Log "INFORMATION BOX: " & Title
Log "~~~~~~~~~~~~~~~"
Log Text
Log ""
MsgBox Text, Icon, Title
end sub

'=========================================================================
sub Info(Text)
'=========================================================================
on error resume next
InfoBox Text, false
end sub

'=========================================================================
sub Debug(Text)
'=========================================================================
on error resume next
InfoBox Text, true
end sub

'=========================================================================
sub ExitRc(ReturnCode)
'=========================================================================
on error resume next
wscript.quit ReturnCode
end sub

'=========================================================================
function GetLock()
'=========================================================================
on error resume next
GetLock = false
for TryNumber = 1 to LockMaxAttempts
err.clear()
set LockSelfStream = oFS.OpenTextFile(LockFlagFile, ForWriting, True)
if  err.number = 0 then
LockSelfStream.write "We grabbed the lock at " &  date() & ", " & time() & "."
GetLock = true
exit for
end if
wscript.sleep LockSecondsBetweenAttempts * 1000
next
end function

'=========================================================================
sub ReleaseLock()
'=========================================================================
on error resume next
LockSelfStream.close()
oFS.DeleteFile LockFlagFile
end sub

'=========================================================================
function GetEnv(EnvVar)
'=========================================================================
on error resume next
Log "Reading Environment variable: " & EnvVar
LogInc()
GetEnv = ""
dim Try : Try = "%" & EnvVar & "%"
GetEnv = EnvVarReplace(Try)
if  GetEnv <> Try then
Log "Found, value: " & GenEnv
else
Log "Environment variable not found using """"!"
GetEnv = ""
end if
LogDec()
end function

'=========================================================================
function EnvVarReplace(ByVal Before)
'=========================================================================
on error resume next
LogInc()
EnvVarReplace = oShell.ExpandEnvironmentStrings(Before)
if  err.number <> 0 then
Log "No environment variables replaced, replacement failed - " & err.description
EnvVarReplace = Before
else
if  Before <> EnvVarReplace then
Log "With Environment variables replaced: " & EnvVarReplace
end if
end if
LogDec()
end function

'=========================================================================
sub Beep(ByVal NumBeepsAsString)
'=========================================================================
on error resume next
dim NumBeeps : NumBeeps = cint(NumBeepsAsString)
if  err.number <> 0 then
NumBeeps = 1
end if
if  NumBeeps > 0 then
oShell.run "cmd.exe /c echo " & string(NumBeeps, chr(7)), 0, false
end if
end sub

'============================================================================
sub LogInc()
'============================================================================
LogIndent = LogIndent + 1
end sub

'============================================================================
sub LogDec()
'============================================================================
LogIndent = LogIndent - 1
end sub

'============================================================================
sub Log(ByVal Text)
'============================================================================
on error resume next
dim WithoutTime : WithoutTime = Text
dim StartLine   : StartLine   = ""
if  Text <> "" then
dim UseIndent : UseIndent = LogIndent
if  left(Text,1) = "+" then
UseIndent = UseIndent + 1
Text      = mid(Text, 2)
end if
If  UseIndent > 0 then
StartLine   = string(UseIndent*4, " ")
WithoutTime = Text
end if
StartLine = PrettyNow(false) & ": " & StartLine
end if
Text = StartLine & Text
Text = replace(Text, vbLF, vbLF & string(len(StartLine), " "))
if   LogFileName = "" then
LogFileQueue = LogFileQueue & Text & vbCRLF
else
if  LogFileQueue <> "" then
oFS.DeleteFile LogFileName
end if
dim Stream : set Stream = oFS.OpenTextFile(LogFileName, ForAppending, True)
if  LogFileQueue <> "" then
Stream.write LogFileQueue
LogFileQueue = ""
end if
Stream.writeline(Text)
Stream.close()
err.clear()
end if
end sub

'============================================================================
function PrettyNow(ByVal WantDayOfWeek)
'============================================================================
dim NowDate, NowTime
NowDate = Date()
NowTime = Time()
if  WantDayOfWeek then
PrettyNow = WeekDayName(WeekDay(NowDate), true) & " "
else
PrettyNow = ""
end if
PrettyNow = PrettyNow & day(NowDate) & " " & MonthName(Month(NowDate), true) & " " & Year(NowDate) & ", " & FormatDateTime(NowTime, vbLongTime)
end function
