---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
    

   under the License.
---

# Обновление iOS

В этом руководстве показано, как изменять проекты iOS для обновления старых версий Cordova. Большинство этих инструкций применимы для проектов, созданных с старого набора средств командной строки, которые предшествуют `cordova` утилиты CLI. Увидеть интерфейс командной строки для информации как обновить версию инфраструктуры CLI.

**Примечание:** Xcode 4.5 не требуется. Представить в Apple App Store, необходимо использовать последнюю поставляется версию iOS SDK, который является iOS 6. IOS 6 SDK требует Xcode 4.5.

## Обновление к CLI (3.0.0) с 2.9.0

1.  Создайте новый проект Apache Cordova 3.0.0, используя cordova CLI, как описано в интерфейс командной строки.

2.  Добавить ваши платформы cordova проекта, например:`cordova
platform add ios`.

3.  Скопируйте содержимое проекта `www` каталог `www` директорию в корне проекта cordova, вы только что создали.

4.  Копирование или перезаписать любые родной активы от вашего первоначального проекта ( `Resources` , и т.д.), что делает уверен, чтобы добавить новые файлы в `.xcodeproj` проекта. Проект iOS строит внутри `platforms\ios` каталог.

5.  Копия вашего `config.xml` в `www` каталог и удалять любые определения, плагин. Измените параметры здесь вместо папки платформы.

6.  Используйте средство CLI cordova для установки плагинов, что вам нужно. Обратите внимание, что CLI обрабатывает все основные API плагинов, так что они могут и должны быть добавлены. Только 3.0.0 плагины совместимы с CLI.

7.  Построение и тестирование.

## Проекты модернизации 2.9.0 3.0.0

1.  Скачайте и распакуйте Cordova 3.0.0 Источник постоянного папку на вашем жестком диске, например`~/Documents/Cordova-3.0.0`.

2.  Закройте Xcode, если она запущена.

3.  С помощью Terminal.app, перейдите в каталог, где вы положили загруженных исходных выше.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova.js` (Обратите внимание, что он не имеет суффикса версии больше, версия в сам файл в заголовке) файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova.js` файл.

7.  Удалить ваш `CordovaLib` каталог и копия `CordovaLib` каталог из нового проекта в корневой каталог вашего проекта.

**Примечание:** Начиная с Cordova 3.0.0, проекты не приходят с каких-либо плагинов, вы должны будете установить те, вам требуется для вашего проекта с помощью `plugman` утилиты CLI. Смотрите раздел Использование Plugman для управления плагины.

## Проекты модернизации 2.8.0 2.9.0

1.  Скачайте и распакуйте Cordova 2.9.0 Источник постоянного папку на вашем жестком диске, например`~/Documents/Cordova-2.9.0`.

2.  Закройте Xcode, если она запущена.

3.  С помощью Terminal.app, перейдите в каталог, где вы положили загруженных исходных выше.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova.js` (Обратите внимание, что он не имеет суффикса версии больше, версия в сам файл в заголовке) файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova.js` файл.

7.  Удалить ваш `CordovaLib` каталог и копия `CordovaLib` каталог из нового проекта в корневой каталог вашего проекта.

## Проекты модернизации 2.7.0 2.8.0

1.  Скачайте и распакуйте Cordova 2.8.0 Источник постоянного папку на вашем жестком диске, например`~/Documents/Cordova-2.8.0`.

2.  Закройте Xcode, если она запущена.

3.  С помощью Terminal.app, перейдите в каталог, где вы положили загруженных исходных выше.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova.js` (Обратите внимание, что он не имеет суффикса версии больше, версия в сам файл в заголовке) файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-2.7.0.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova.js` файл.

7.  Обновлять любой `<plugin>` теги, которые находятся в вашем `config.xml` для `<feature>` теги. Обратите внимание, что существующие `<plugin>` теги все равно будет работать, но являются устаревшими. Вы можете скопировать эту информацию в `config.xml` для нового проекта. Например:
    
        <plugins>
            <plugin name="LocalStorage" value="CDVLocalStorage" />
            <!-- other plugins -->
        </plugins>
        
        <!-- change to: (note that a <feature> tag is on the same level as <plugins> -->
        <feature name="LocalStorage">
            <param name="ios-package" value="CDVLocalStorage" />
        </feature>
        <!-- other <feature> tags -->
        

8.  Удалить ваш `CordovaLib` каталог и копия `CordovaLib` каталог из нового проекта в корневой каталог вашего проекта.

9.  Добавьте эти две структуры в проект:
    
        OpenAL
        ImageIO
        

10. Обновление вашего проекта целевые **Параметры построения**. В разделе **Связывание → прочие флаги компоновщика**, измените **"- Obj - C"** быть **"-ObjC»**.

11. Обновление вашего проекта целевые **Параметры построения**. В разделе **Связывание → прочие флаги компоновщика**, измените **»-all_load «** быть `-force\_load ${BUILT\_PRODUCTS\_DIR}/libCordova.a` . Вам только нужно будет это сделать, если у вас есть проблемы, определенные в [этот вопрос.][1].

 [1]: https://issues.apache.org/jira/browse/CB-3458

## Проекты модернизации 2.6.0 2.7.0

1.  Скачайте и распакуйте Cordova 2.7.0 Источник постоянного папку на вашем жестком диске, например`~/Documents/Cordova-2.7.0`.

2.  Закройте Xcode, если она запущена.

3.  С помощью Terminal.app, перейдите в каталог, где вы положили загруженных исходных выше.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova-2.7.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-2.6.0.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-2.7.0.js` файл.

7.  Обновление (или заменить, если вы никогда не изменяли файл) ваш `AppDelegate.m` файл согласно одной из нового проекта (см. [это diff][2]).

8.  В вашем `config.xml` файла, [удалите эту строку][3].

9.  Удалить ваш `CordovaLib` каталог и копия `CordovaLib` каталог из нового проекта в корневой каталог вашего проекта.

 [2]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/Classes/AppDelegate.m;h=5c05ac80e056753c0e8736f887ba9f28d5b0774c;hp=623ad8ec3c46f656ea18c6c3a190d650dd64e479;hb=c6e71147386d4ad94b07428952d1aae0a9cbf3f5;hpb=c017fda8af00375a453cf27cfc488647972e9a23
 [3]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/config.xml;h=537705d76a5ef6bc5e57a8ebfcab78c02bb4110b;hp=8889726d9a8f8c530fe1371c56d858c34552992a;hb=064239b7b5fa9a867144cf1ee8b2fb798ce1f988;hpb=c9f233250d4b800f3412eeded811daaafb17b2cc

## Проекты модернизации 2.5.0 2.6.0

1.  Скачайте и распакуйте Cordova 2.6.0 Источник постоянного папку на вашем жестком диске, например`~/Documents/Cordova-2.6.0`.

2.  Закройте Xcode, если она запущена.

3.  С помощью Terminal.app, перейдите в каталог, где вы положили загруженных исходных выше.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копирование проекта `www/cordova-2.6.0.js` файл в ваш `www` каталог и удалить ваш `www/cordova-2.5.0.js` файл.

6.  Обновить Cordova сценарий ссылку в ваш `www/index.html` файл (а также любые другие файлы, которые ссылки на сценарий) сослаться на новый `cordova-2.6.0.js` файл.

7.  Обновление (или заменить, если вы никогда не изменяли файл) ваш `AppDelegate.m` файл согласно одной из нового проекта (см. [это diff][4]).

8.  В вашем `config.xml` файла, [Добавить новую строку][5].

9.  В вашем `config.xml` файла, [Добавить новую строку][6].

10. В вашем `config.xml` файла, [UIWebViewBounce был изменен на DisallowOverscroll, и значения по умолчанию отличаются][7].

11. В ваш `config.xml` файл, `EnableLocation` предпочтение является устаревшим.

12. Удалить ваш `CordovaLib` каталог и копия `CordovaLib` каталог из нового проекта в корневой каталог вашего проекта.

 [4]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/Classes/AppDelegate.m;h=124a56bb4f361e95616f44d6d6f5a96ffa439b60;hp=318f79326176be8f16ebc93bad85dd745f4205b6;hb=a28c7712810a63396e9f32fa4eb94fe3f8b93985;hpb=36acdf55e4cab52802d73764c8a4b5b42cf18ef9
 [5]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/config.xml;h=1555b5e81de326a07efe0bccaa5f5e2326b07a9a;hp=0652d60f8d35ac13c825c572dca6ed01fea4a540;hb=95f16a6dc252db0299b8e2bb53797995b1e39aa1;hpb=a2de90b8f5f5f68bd9520bcbbb9afa3ac409b96d
 [6]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/config.xml;h=d307827b7e67301171a913417fb10003d43ce39d;hp=04260aa9786d6d74ab20a07c86d7e8b34e31968c;hb=97b89edfae3527828c0ca6bb2f6d58d9ded95188;hpb=942d33c8e7174a5766029ea1232ba2e0df745c3f
 [7]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/config.xml;h=8889726d9a8f8c530fe1371c56d858c34552992a;hp=d307827b7e67301171a913417fb10003d43ce39d;hb=57982de638a4dce6ae130a26662591741b065f00;hpb=ec411f18309d577b4debefd9a2f085ba719701d5

## Обновление 2.4.0 проекты для 2.5.0

1.  Скачайте и распакуйте Cordova 2.5.0 Источник постоянного папку на вашем жестком диске, например`~/Documents/Cordova-2.5.0`.

2.  Закройте Xcode, если она запущена.

3.  С помощью Terminal.app, перейдите в каталог, где вы положили загруженных исходных выше.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova-2.5.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-2.4.0.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-2.5.0.js` файл.

7.  Обновление (или заменить, если вы никогда не изменяли файл) ваш `AppDelegate.m` файл согласно одной из нового проекта (см. [это diff][8]).

8.  В вашем `config.xml` файла, [добавить эти новые линии][9].

9.  В ваш `config.xml` файл, [изменить корневой элемент, изменить его от Кордова виджет][10].

10. В ваш `config.xml` файл, [удалить предпочтение OpenAllWhitelistURLsInWebView][11].

11. Удалить ваш `cordova` каталог и копия `cordova` каталог из нового проекта в корневой каталог вашего проекта. В 2.5.0 это обновил скриптов.

12. Удалить ваш `CordovaLib` каталог и копия `CordovaLib` каталог из нового проекта в корневой каталог вашего проекта.

 [8]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/Classes/AppDelegate.m;h=318f79326176be8f16ebc93bad85dd745f4205b6;hp=6dc7bfc84f0ecede4cc43d2a3256ef7c5383b9fe;hb=4001ae13fcb1fcbe73168327630fbc0ce44703d0;hpb=299a324e8c30065fc4511c1fe59c6515d4842f09
 [9]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/config.xml;h=903944c4b1e58575295c820e154be2f5f09e6314;hp=721c734120b13004a4a543ee25f4287e541f34be;hb=ae467249b4a256bd31ee89aea7a06f4f2316b8ac;hpb=9e39f7ef8096fb15b38121ab0e245a3a958d9cbb
 [10]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/config.xml;h=64e71636f5dd79fa0978a97b9ff5aa3860a493f5;hp=d8579352dfb21c14e5748e09b2cf3f4396450163;hb=0e711f8d09377a7ac10ff6be4ec17d22cdbee88d;hpb=57c3c082ed9be41c0588d0d63a1d2bfcd2ed878c
 [11]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/config.xml;h=721c734120b13004a4a543ee25f4287e541f34be;hp=7d67508b70914aa921a16e79f79c00512502a8b6;hb=187bf21b308551bfb4b98b1a5e11edf04f699791;hpb=03b8854bdf039bcefbe0212db937abd81ac675e4

## Обновление 2.3.0 проекты 2.4.0

1.  Скачайте и распакуйте Cordova 2.4.0 Источник постоянного папку на вашем жестком диске, например`~/Documents/Cordova-2.4.0`.

2.  Закройте Xcode, если она запущена.

3.  С помощью Terminal.app, перейдите в каталог, где вы положили загруженных исходных выше.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova-2.4.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-2.3.0.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-2.4.0.js` файл.

7.  Обновление (или заменить, если вы никогда не изменяли файлы) ваш `MainViewController.m` файл согласно одной из нового проекта (см. [это diff][12]).

8.  Обновление (или заменить, если вы никогда не изменяли файл) ваш `AppDelegate.m` файл согласно одной из нового проекта (см. [это diff][13]).

9.  В вашем `config.xml` файла, [Добавить новую строку][14].

10. Удалить ваш `cordova` каталог и копия `cordova` каталог из нового проекта в корневой каталог вашего проекта. В 2.4.0 это фиксированная сценарии.

11. Удалить ваш `CordovaLib` каталог и копия `CordovaLib` каталог из нового проекта в корневой каталог вашего проекта.

12. Добавьте AssetsLibrary.framework как ресурс в проект. (Go [здесь][15] для получения инструкций о том, как это сделать.).

 [12]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/Classes/MainViewController.m;h=5f9eeac15c2437cd02a6eb5835b48374e9b94100;hp=89da1082d06ba5e5d0dffc5b2e75a3a06d5c2aa6;hb=b4a2e4ae0445ba7aec788090dce9b822d67edfd8;hpb=a484850f4610e73c7b20cd429a7794ba829ec997
 [13]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/Classes/AppDelegate.m;h=6dc7bfc84f0ecede4cc43d2a3256ef7c5383b9fe;hp=1ca3dafeb354c4442b7e149da4f281675aa6b740;hb=6749c17640c5fed8a7d3a0b9cca204b89a855baa;hpb=deabeeb6fcb35bac9360b053c8bf902b45e6de4d
 [14]: https://git-wip-us.apache.org/repos/asf?p=cordova-ios.git;a=blobdiff;f=bin/templates/project/__TESTING__/config.xml;h=7d67508b70914aa921a16e79f79c00512502a8b6;hp=337d38da6f40c7432b0bce05aa3281d797eec40a;hb=6749c17640c5fed8a7d3a0b9cca204b89a855baa;hpb=deabeeb6fcb35bac9360b053c8bf902b45e6de4d
 [15]: https://developer.apple.com/library/ios/#recipes/xcode_help-project_editor/Articles/AddingaLibrarytoaTarget.html

## Проекты модернизации 2.2.0 2.3.0

1.  Скачайте и распакуйте Cordova 2.3.0 Источник постоянного папку на вашем жестком диске, например`~/Documents/Cordova-2.3.0`.

2.  Закройте Xcode, если она запущена.

3.  С помощью Terminal.app, перейдите в каталог, где вы положили загруженных исходных выше.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova-2.3.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-2.2.0.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-2.3.0.js` файл.

7.  Обновление (или заменить, если вы никогда не изменяли файл) ваш `MainViewController.m` согласно одной из нового проекта.

8.  Удалить ваш `cordova` каталог и копия `cordova` каталог из нового проекта в корневой каталог вашего проекта. В 2.3.0 это имеет новые сценарии.

9.  Удалить ваш `CordovaLib` каталог и копия `CordovaLib` каталог из нового проекта в корневой каталог вашего проекта.

10. Конвертировать ваш `Cordova.plist` файл `config.xml` , запустив сценарий `bin/cordova\_plist\_to\_config\_xml` в вашем файле проекта.

11. Добавить плагин InAppBrowser для вашего `config.xml` , добавляя этот тег под `<cordova><plugins>` :
    
        <plugin name="InAppBrowser" value="CDVInAppBrowser" />
        

12. Обратите внимание, что плагины Objective-C *не* whitelisted больше. Белый список ваши соединения с app whitelist, вам будет нужно установить `User-Agent` заголовок подключения к же агент пользователя как основной Cordova WebView. Вы можете получить, обратившись к `userAgent` собственности от основной представление контроллер. Основной вид контроллера (CDVViewController) также имеет `URLisAllowed` метод для вас, чтобы проверить, является ли URL-адрес будет проходить белый.

13. Изменения устройства API:
    
    *   Для iOS, device.platform используется для возвращения `iPhone` , `iPad` или `iPod Touch` ; теперь возвращает (правильно)`iOS`.
    *   Для iOS, device.name (теперь устарела для всех платформ) используется для возвращения имени пользователя устройства (например ' Shazron в iPhone 5 ′); Теперь он возвращает какие device.platform используется для возвращения: `iPhone` , `iPad` или`iPod Touch`.
    *   Для всех платформ это новое свойство, называемое device.model; Возвращает модель конкретного устройства, например `iPad2,5` (для других платформ, это возвращает какие device.name используется для возвращения).

## Обновление 2.1.0 проекты 2.2.0

1.  Скачайте и распакуйте Cordova 2.2.0 Источник постоянного папку на вашем жестком диске, например`~/Documents/Cordova-2.2.0`.

2.  Закройте Xcode, если она запущена.

3.  С помощью Terminal.app, перейдите в каталог, где вы положили загруженных исходных выше.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova-2.2.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-2.1.0.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-2.2.0.js` файл.

7.  Обновление (или заменить, если вы никогда не изменяли файл) ваш `MainViewController.m` согласно одной из нового проекта:
    
    *   Обновление → viewWillAppear

8.  Копия `cordova` каталог из нового проекта в корневой каталог вашего проекта. В 2.2.0 это имеет обновленный «подражать» сценарий.

9.  Далее, обновить ваш `CordovaLib` подпроект ссылку. Начиная с Cordova 2.1.0, мы не используем переменную CORDOVALIB Xcode больше при ссылке на где `CordovaLib` проживает, эта ссылка является абсолютным файл теперь.
    
    1.  Запуск Terminal.app
    2.  Перейдите в местоположение, куда вы установили Кордова (см. шаг 1), в `bin` подкаталог
    3.  Запустите сценарий ниже, где первый параметр — путь к вашему проекту `.xcodeproj` файл:
        
        `update_cordova_subproject path/to/your/project/xcodeproj`

**Примечание:** В 2.2.0 `bin/create` сценарий копию в `CordovaLib` подпроекта в ваш проект. Чтобы иметь тот же тип установки, просто скопируйте в правом `CordovaLib` в папке проекта и обновление `CordovaLib` югу расположение (относительно проекта) в Xcode инспектора файлов проекта.

## Проекты модернизации 2.0.0 2.1.0

С Cordova 2.1.0 `CordovaLib` был обновлен для использования **Автоматического подсчета ссылок (ARC)**. Вам не нужно для обновления до **дуги** для использования CordovaLib, но если вы хотите обновить проект для использования **дуги**, пожалуйста, используйте мастер миграции Xcode из меню: **Правка → рефакторинг → преобразовать в Objective-C ARC...**, снимите флажок libCordova.a, а затем запустить мастер для завершения.

1.  Скачайте и распакуйте Cordova 2.1.0 Источник постоянного папку на вашем жестком диске, например`~/Documents/Cordova-2.1.0`.

2.  Закройте Xcode, если она запущена.

3.  С помощью Terminal.app, перейдите в каталог, где вы положили загруженных исходных выше.

4.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

5.  Копия `www/cordova-2.1.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-2.0.0.js` файл.

6.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-2.1.0.js` файл.

7.  Обновление (или заменить, если вы никогда не изменяли файл) ваш `AppDelegate.m` согласно одной из нового проекта:
    
    *   Редактировать → применения: didFinishLaunchingWithOptions:
    *   Добавлено → применения: supportedInterfaceOrientationsForWindow:

8.  Обновление (или заменить, если вы никогда не изменяли файл) ваш `MainViewController.m` согласно одной из нового проекта:
    
    *   Добавлено → viewWillAppear

9.  Копия `cordova` каталог из нового проекта в корневой каталог вашего проекта. В 2.1.0 это имеет обновленные скрипты для поддержки пути с пробелами.

10. Удалить `VERSION` файла ссылку из вашего проекта (*не* один в`CordovaLib`).

11. Далее, обновить ваш `CordovaLib` подпроект ссылку. Начиная с Cordova 2.1.0, мы не используем переменную CORDOVALIB Xcode больше при ссылке на где `CordovaLib` проживает, эта ссылка является абсолютным файл теперь.
    
    1.  Запуск Terminal.app
    2.  Перейдите в местоположение, куда вы установили Кордова (см. шаг 1), в `bin` подкаталог
    3.  Запустите сценарий ниже, где первый параметр — путь к вашему проекту `.xcodeproj` файл:
        
        `update_cordova_subproject path/to/your/project/xcodeproj`

## Проекты модернизации 1.9.0 2.0.0

1.  Установите Cordova 2.0.0.

2.  Создайте новый проект, как описано в iOS утилиты командной строки. Вам нужен активов от этого нового проекта.

3.  Копия `www/cordova-2.0.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-1.9.0.js` файл.

4.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-2.0.0.js` файл.

5.  Копия `cordova` каталог из нового проекта в корневой каталог вашего проекта (если вы хотите проект средства командной строки).

6.  Добавьте новую запись под `Plugins` в ваш `Cordova.plist` файл, группе **Поддержки файлов** . Ключ `Device` и значение`CDVDevice`.

7.  Удалить`Cordova.framework`.

8.  Удалить `verify.sh` из группы **Поддержки файлов** .

9.  Выберите значок проекта в диспетчере структуры проекта, выберите **целевой**проект, а затем выберите вкладку **Параметры построения** .

10. Поиск для **Макросов препроцессора**, затем удалите всю **CORDOVA_FRAMEWORK = 1** значения.

11. Найдите `CordovaLib` каталог, который был установлен на вашем жестком диске в вашей домашней папке `Documents` подкаталог.

12. Найдите `CordovaLib.xcodeproj` файл `CordovaLib` каталог, а затем перетащить файл в ваш проект. Он должен отображаться как под-проекта.

13. Создайте свой проект, вы должны получить некоторые ошибки, связанные с `#import` директивы.

14. Для `#import` ошибки, изменить любой импорт на основе цитата в этом стиле:
    
        #import "CDV.h"
        
    
    в этот стиль, основанный на скобки:
    
        #import <Cordova/CDV.h>
        
    
    и удалите `#ifdef` оболочки вокруг любой Cordova импорта, они больше не нужен (импорт теперь объединены)

15. Создайте проект снова, и он не должен иметь любой `#import` ошибок.

16. Выберите **значок проекта** в диспетчере структуры проекта, выберите **целевой**проект, а затем выберите вкладку **Build фаз** .

17. Разверните этапа **Зависимости целевых объектов** , а затем выберите **+** кнопку.

18. Выберите `CordovaLib` цели, а затем выберите кнопку **Добавить** .

19. Разверните первый этап **Двоичные связь с библиотеками** (он уже должен содержать кучу рамки), а затем выберите **+** кнопку.

20. Выберите `libCordova.a` статическую библиотеку, а затем выберите кнопку **Добавить** .

21. Удаление фазы **Запустить скрипт** .

22. Выберите **значок проекта** в диспетчере структуры проекта, выберите **целевой**проект, а затем выберите вкладку **Параметры построения** .

23. Поиск **Других флагов компоновщика**и добавьте значения **-all_load** и **- Obj-C**.

24. Разверните `CordovaLib` подпроекта.

25. Найдите `VERSION` файл, перетащите его в ваш основной проект (мы хотим создать ссылку на него, не копия).

26. Выберите переключатель **создать группы для любой дополнительной папки** , а затем выберите кнопку **Готово** .

27. Выберите `VERSION` файл, который вы просто перетащить на предыдущем шаге.

28. Введите сочетание клавиш **Option-Command-1** , чтобы показать **Инспектора файлов** (или menuitem **Просмотр → общих назначений → показать файл инспектор**).

29. Выберите **относительный CORDOVALIB** в **Инспектора файлов** для раскрывающегося меню для **местоположения**.

30. Xcode предпочтения **предпочтения Xcode → места → полученных данных → передовые...** можно присвоить **уникальный**, чтобы единой заголовки можно найти.

31. Выберите **значок проекта** в диспетчере структуры проекта, выберите ваши **цели**, а затем выберите вкладку **Параметры построения** .

32. Поиск **путей поиска заголовка**. Для этого параметра, добавьте эти три значения, включая котировки:
    
        "$(TARGET_BUILD_DIR)/usr/local/lib/include"
        
        "$(OBJROOT)/UninstalledProducts/include"
        
        "$(BUILT_PRODUCTS_DIR)"
        

33. Поиск **другие флаги компоновщика**. Для этого параметра, добавьте это значение:
    
        -weak_framework CoreFoundation
        

34. Создайте свой проект, следует скомпилировать и связать **без** вопросов.

35. Выберите проект в раскрывающемся списке **схемы** , а затем выберите **iPhone 5.1 симулятор**.

36. Выберите кнопку **Run** .

**Примечание:** Если ваш проект не работает как ожидалось в симуляторе, пожалуйста принять к сведению любые ошибки в журнале консоли в Xcode для подсказки.

## Обновление проектов 1.8.x до 1.9.0

1.  Установите Cordova 1.9.0.

2.  Создайте новый проект. Вам нужно некоторые из активов от этого нового проекта.

3.  Копия `www/cordova-1.9.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-1.8.x.js` файл.

4.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-1.9.0.js` файл.

**Примечание:** 1.9.0 поддерживает новый `BackupWebStorage` логическое `Cordova.plist` параметр. Она включена по умолчанию, так что установить `false` чтобы отключить его, особенно на iOS 6. Смотреть [заметки о выпуске: Safari и UIKit раздел][16]

 [16]: https://developer.apple.com/library/prerelease/ios/#releasenotes/General/RN-iOSSDK-6_0/_index.html

## Проекты модернизации 1.7.0 1.8.x

1.  Установите Cordova 1.8.0.

2.  Создайте новый проект. Вам нужно некоторые из активов от этого нового проекта.

3.  Копия `www/cordova-1.8.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-1.7.x.js` файл.

4.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-1.8.0.js` файл.

Если вы собираетесь использовать API захвата, вам понадобится новый **iPad retina дисплей** активов:

1.  Копия `Resources/Capture.bundle` элемент из нового проекта в папке проекта, помарок существующих `Resources/Capture.bundle` пункта.

2.  В вашем проекте, выберите `Capture.bundle` элемент в ваш проект навигатор в Xcode, введите клавишу **Delete** , а затем выберите **Удалить ссылку** из появившемся диалоговом.

3.  Перетащите новый `Capture.bundle` от шаг 1 выше в навигаторе проекта Xcode, затем выберите переключатель **создать группы для любой дополнительной папки** .

## Обновление проектов 1.6.x на 1.7.0

1.  Установите Cordova 1.7.0.

2.  Создайте новый проект. Вам нужно некоторые из активов от этого нового проекта.

3.  Копия `www/cordova-1.7.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-1.6.0.js` файл.

4.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-1.7.0.js` файл.

## Обновление 1.5.0 проекты 1.6.x

1.  Установите Cordova 1.6.1.

2.  Сделайте резервную копию `AppDelegate.m` , `AppDelegate.h` , `MainViewController.m` , `MainViewController.h` , и `Cordova.plist` в вашем проекте.

3.  Создайте новый проект. Вам нужно некоторые из активов от этого нового проекта.

4.  Скопируйте эти файлы из нового проекта в папке проекта 1.5.0-based на диске, заменив старые файлы (резервное копирование файлов сначала из шага 2 выше):
    
        AppDelegate.h
        AppDelegate.m
        MainViewController.h
        MainViewController.m
        Cordova.plist
        

5.  Добавить все новые `MainViewController` и `AppDelegate` файлы в ваш проект Xcode.

6.  Копия `www/cordova-1.6.1.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/cordova-1.5.0.js` файл.

7.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `cordova-1.6.1.js` файл.

8.  Добавить новый `Cordova.plist` файл в ваш проект. Это необходимо потому, что ядро плагин имена должны меняться, чтобы соответствовать те, от Android и BlackBerry, для единой Cordova JavaScript файл (`cordova-js`).

9.  Интегрировать любые параметры, **плагины** и **ExternalHosts** записи, которые вы имели в вашей **резервной Cordova.plist** в новый`Cordova.plist`.

10. Интегрировать любой код конкретного проекта, у вас есть в вашем резервные `AppDelegate.h` и `AppDelegate.m` в новые файлы AppDelegate. Любой `UIWebViewDelegate` или `CDVCommandDelegate` код в `AppDelegate.m` нужно будет идти в `MainViewController.m` сейчас (см. комментарии разделы в этом файле).

11. Интегрировать любой код конкретного проекта, у вас есть в вашем резервные `MainViewController.h` и `MainViewController.m` в новые файлы MainViewController.

12. Нажмите на значок проекта в навигаторе проект, выберите **проект**, а затем выберите вкладку **Параметры построения** .

13. Введите **компилятор для C / C + +/ Objective-C** в поле поиска.

14. Выберите значение **3.1 компилятора LLVM Apple** .

## Обновление проектов 1.4.x на 1.5.0

1.  Установите Cordova 1.5.0.

2.  Создайте новый проект и запустите его один раз. Вам нужно некоторые из активов от этого нового проекта.

3.  Копия `www/cordova-1.5.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/phonegap-1.4.x.js` файл.

4.  Обновить Cordova сценарий ссылку в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) чтобы указать новый Cordova `cordova-1.5.0.js` файла.

5.  Найти `PhoneGap.framework` в вашем навигаторе проекта, выберите его.

6.  Введите ключ **Удалить** и удалить `PhoneGap.framework` ссылка в диспетчере структуры проекта.

7.  Введите сочетание клавиш **Option-Command-A** , который следует падение вниз лист для добавления файлов в проект (лист **Добавить файлы...** ). Убедитесь, что выбран переключатель **группы создана для любой дополнительной папки** .

8.  Введите сочетание клавиш **Shift-Command-G** , который следует падение вниз еще один лист для вас, чтобы перейти к папке ( **перейдите в папку:** листа).

9.  Введите `/Users/Shared/Cordova/Frameworks/Cordova.framework` в **перейдите в папку:** лист, а затем нажмите кнопку **Go** .

10. Нажмите на кнопку **Добавить** в лист **Добавить файлы...** .

11. Выберите `Cordova.framework` в диспетчере структуры проекта.

12. Введите сочетание клавиш **Option-Command-1** , чтобы показать **Инспектора файлов**.

13. Выберите **Абсолютный путь** в **Инспектора файлов** для раскрывающегося меню для **местоположения**.

14. Введите сочетание клавиш **Option-Command-A** , который следует падение вниз лист для добавления файлов в проект (лист **Добавить файлы...** ). Убедитесь, что выбран переключатель **группы создана для любой дополнительной папки** .

15. Введите сочетание клавиш **Shift-Command-G** , который следует падение вниз еще один лист для вас, чтобы перейти к папке ( **перейдите в папку:** листа).

16. Введите `~/Documents/CordovaLib/Classes/deprecated` в **перейдите в папку:** лист, а затем нажмите кнопку **Go** .

17. Нажмите на кнопку **Добавить** в лист **Добавить файлы...** .

18. В вашем `AppDelegate.h` , `AppDelegate.m` , и `MainViewController.h` файлы, заменить весь `#ifdef PHONEGAP_FRAMEWORK` блок с:
    
        #import "CDVDeprecated.h"
        

19. Нажмите на **значок проекта** в диспетчере структуры проекта, выберите ваши **цели**, а затем перейдите на вкладку **Параметры построения** .

20. Поиск для **путей поиска рамки**.

21. Замените существующее значение с`/Users/Shared/Cordova/Frameworks`.

22. Поиск для **макросов препроцессора**.

23. Для первого значения (комбинированные), замените значение с **CORDOVA_FRAMEWORK = YES**.

24. Выберите вкладку **Build фаз** .

25. Разверните узел **запустить сценарий**.

26. Замените все вхождения **PhoneGap** с **Кордова**.

27. Найти ваш `PhoneGap.plist` файл в диспетчере структуры проекта и щелкните на имени файла один раз войти в режим редактирования имени.

28. Переименовать `PhoneGap.plist` в`Cordova.plist`.

29. Щелкните правой кнопкой мыши `Cordova.plist` и выберите команду **Открыть как → исходный код**.

30. Нажмите **Option-Command-F**, выберите **заменить** из раскрывающегося списка в верхнем левом углу окна исходного кода.

31. Введите `com.phonegap` для строки поиска, и `org.apache.cordova` для замены строки, затем нажмите кнопку **Заменить все** .

32. Введите **PG** для строки поиска и **CDV** для замены строки, а затем нажмите кнопку **Заменить все** .

33. Нажмите **Command-B** , чтобы построить, вам все равно придется симбиозе, которые вы можете избавиться от в будущем (см. `CDVDeprecated.h` . Например, заменить классы в коде, использующие PG * для CDV *).

## Проекты модернизации 1.4.0 1.4.1

1.  Установите Cordova 1.4.1.

2.  Сделайте резервную копию`MainViewController.m`.

3.  Создайте новый проект. Вам нужно некоторые из активов от этого нового проекта.

4.  Копия `MainViewController.m` файл из нового проекта в папке проекта 1.4.0-based на диске, заменив старый файл (резервного копирования ваших файлов от шаг 2 выше).

5.  Добавить `MainViewController.m` файл в ваш проект Xcode.

6.  Интегрировать любой код конкретного проекта, у вас есть в вашем резервные `MainViewController.m` в новый файл.

7.  Обновление `phonegap-1.4.0.js` файл не является обязательным, в JavaScript между 1.4.0 и 1.4.1 ничего не изменилось.

## Обновление 1.3.0 проекты 1.4.0

1.  Установите Cordova 1.4.0.

2.  Сделайте резервную копию `AppDelegate.m` и `AppDelegate.h` в вашем проекте.

3.  Создайте новый проект. Вам нужно некоторые из активов от этого нового проекта.

4.  Скопируйте эти файлы из нового проекта в папке проекта 1.3.0-based на диске, заменив старые файлы (резервное копирование файлов сначала из шага 2 выше):
    
        AppDelegate.h
        AppDelegate.m
        MainViewController.h
        MainViewController.m
        MainViewController.xib
        

5.  Добавить все `MainViewController` файлы в ваш проект Xcode.

6.  Копия `www/phonegap-1.4.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/phonegap-1.3.0.js` файл.

7.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `phonegap-1.4.0.js` файл.

8.  Добавьте новую запись под `Plugins` в ваш `PhoneGap.plist` файл. Ключ `com.phonegap.battery` и значение`PGBattery`.

9.  Интегрировать любой код конкретного проекта, у вас есть в вашем резервные `AppDelegate.h` и `AppDelegate.m` в новые файлы AppDelegate.

## Обновление 1.2.0 проектах для 1.3.0

1.  Установите Cordova 1.3.0.

2.  Сделайте резервную копию `AppDelegate.m` и `AppDelegate.h` в вашем проекте.

3.  Создайте новый проект. Вам нужно некоторые из активов от этого нового проекта.

4.  Скопируйте эти файлы из нового проекта в папке проекта 1.2.0-based на диске, заменив старые файлы (резервное копирование файлов сначала из шага 2 выше):
    
        AppDelegate.h
        AppDelegate.m
        MainViewController.h
        MainViewController.m
        MainViewController.xib
        

5.  Добавить все `MainViewController` файлы в ваш проект Xcode.

6.  Копия `www/phonegap-1.3.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/phonegap-1.2.0.js` файл.

7.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `phonegap-1.3.0.js` файл.

8.  Добавьте новую запись под `Plugins` в ваш `PhoneGap.plist` файл. Ключ `com.phonegap.battery` и значение`PGBattery`.

9.  Интегрировать любой код конкретного проекта, у вас есть в вашем резервные `AppDelegate.h` и `AppDelegate.m` в новые файлы AppDelegate.

## Обновление 1.1.0 проекты 1.2.0

1.  Установите Cordova 1.2.0.

2.  Сделайте резервную копию `AppDelegate.m` и `AppDelegate.h` в вашем проекте.

3.  Создайте новый проект. Вам нужно некоторые из активов от этого нового проекта.

4.  Скопируйте эти файлы из нового проекта в папке проекта 1.1.0-based на диске, заменив старые файлы (резервное копирование файлов сначала из шага 2 выше):
    
        AppDelegate.h
        AppDelegate.m
        MainViewController.h
        MainViewController.m
        MainViewController.xib
        

5.  Добавить все `MainViewController` файлы в ваш проект Xcode.

6.  Копия `www/phonegap-1.2.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/phonegap-1.1.0.js` файл.

7.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `phonegap-1.2.0.js` файл.

8.  Добавьте новую запись под `Plugins` в ваш `PhoneGap.plist` файл. Ключ `com.phonegap.battery` и значение`PGBattery`.

9.  Интегрировать любой код конкретного проекта, у вас есть в вашем резервные `AppDelegate.h` и `AppDelegate.m` в новые файлы AppDelegate.

## Проекты модернизации 1.0.0 1.1.0

1.  Установите Cordova 1.1.0.

2.  Сделайте резервную копию `AppDelegate.m` и `AppDelegate.h` в вашем проекте.

3.  Создайте новый проект. Вам нужно некоторые из активов от этого нового проекта.

4.  Скопируйте эти файлы из нового проекта в папке проекта 1.0.0-based на диске, заменив старые файлы (резервное копирование файлов сначала из шага 2 выше):
    
        AppDelegate.h
        AppDelegate.m
        MainViewController.h
        MainViewController.m
        MainViewController.xib
        

5.  Добавить все `MainViewController` файлы в ваш проект Xcode.

6.  Копия `www/phonegap-1.1.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/phonegap-1.0.0.js` файл.

7.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `phonegap-1.1.0.js` файл.

8.  Добавьте новую запись под `Plugins` в ваш `PhoneGap.plist` файл. Ключ `com.phonegap.battery` и значение`PGBattery`.

9.  Интегрировать любой код конкретного проекта, у вас есть в вашем резервные `AppDelegate.h` и `AppDelegate.m` в новые файлы AppDelegate.

## Проекты модернизации 0.9.6 1.0.0

1.  Установите Cordova 1.0.0.

2.  Сделайте резервную копию `AppDelegate.m` и `AppDelegate.h` в вашем проекте.

3.  Создайте новый проект. Вам нужно некоторые из активов от этого нового проекта.

4.  Скопируйте эти файлы из нового проекта в папке проекта 0.9.6-based на диске, заменив старые файлы (резервное копирование файлов сначала из шага 2 выше):
    
        AppDelegate.h
        AppDelegate.m
        MainViewController.h
        MainViewController.m
        MainViewController.xib
        

5.  Добавить все `MainViewController` файлы в ваш проект Xcode.

6.  Копия `www/phonegap-1.0.0.js` файл из нового проекта в ваш `www` каталог и удалить ваш `www/phonegap-0.9.6.js` файл.

7.  Обновить ссылку сценарий Кордова в ваш `www/index.html` файл (и любые другие файлы, которые содержат ссылку на сценарий) для указания на новый `phonegap-1.0.0.js` файл.

8.  Добавьте новую запись под `Plugins` в ваш `PhoneGap.plist` файл. Ключ `com.phonegap.battery` и значение`PGBattery`.

9.  Интегрировать любой код конкретного проекта, у вас есть в вашем резервные `AppDelegate.h` и `AppDelegate.m` в новые файлы AppDelegate.