# -*- coding: utf-8 -*-
#
# Copyright 2013 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

from __future__ import absolute_import

import signal

from testtools.matchers import Contains, Equals
from autopilot.matchers import Eventually

from autopilot.input import Keyboard

from cordova_ubuntu.tests import CordovaUbuntuTestCase

from time import sleep
from os import path, kill

class Alarm(Exception):
    pass

def alarm_handler(signum, frame):
    raise Alarm

TIMEOUT = 120

class TestMobileSpec(CordovaUbuntuTestCase):

    def test_mobilespec(self):
        web_view = self.get_webview()
        self.assertThat(web_view.loadProgress, Eventually(Equals(100)))
        # Click on "Automated tests" (index.html)
        web_view.slots.evalInPageUnsafe('document.getElementById("__automated").click();');
        self.assertThat(web_view.loadProgress, Eventually(Equals(100)))
        # Click on "Run all" (autotest/index.html)
        web_view.slots.evalInPageUnsafe('document.getElementById("__automated").click();');
        self.assertThat(web_view.loadProgress, Eventually(Equals(100)))
        # Wait until finished (autotest/pages/all.html)
        web_view.slots.evalInPageUnsafe("document.addEventListener('junitxml-finished', function (e) { setTimeout(navigator.app.closeApp, 1000); }, false);");
        # Detect window closed
        signal.signal(signal.SIGALRM, alarm_handler)
        signal.alarm(TIMEOUT) # Setup timeout
        finished = False
        try:
            while (self.app.process.poll() is None):
                # Process still running, sleep a bit
                sleep(1)
            signal.alarm(0)
            finished = True
        except Alarm:
            # Timeout reached
            pass
        self.assertThat(finished, Equals(True))
