import QtQuick 2.0
import QtWebKit 3.0
import QtWebKit.experimental 1.0
import "cordova_wrapper.js" as CordovaWrapper
import Ubuntu.Components 0.1
import Ubuntu.Components.Popups 0.1

Item {
    anchors.fill: parent
    state: "main"
    id: root
    signal completed
    property string wwwDir
    property string splashscreenPath
    property string inappbrowserUrl
    function exec(plugin, func, args) {
        CordovaWrapper.execMethod(plugin, func, args);
    }

    Component {
         id: notificationDialog
         Dialog {
             id: dialogue
             property string button1Text
             property string button2Text
             property string button3Text
             property bool promptVisible
             property string defaultPromptText
             TextInput {// FIXME: swith to TextField(TextField should support visible property)
                 id: prompt
                 text: defaultPromptText
                 visible: promptVisible
                 focus: true
             }
             Button {
                 text: button1Text
                 color: "orange"
                 onClicked: {
                     cordova.notificationDialogButtonPressed(1, prompt.text)
                     PopupUtils.close(dialogue)
                 }
             }
             Button {
                 text: button2Text
                 visible: button2Text.length > 0
                 color: "orange"
                 onClicked: {
                     cordova.notificationDialogButtonPressed(2, prompt.text)
                     PopupUtils.close(dialogue)
                 }
             }
             Button {
                 text: button3Text
                 visible: button3Text.length > 0
                 onClicked: {
                     cordova.notificationDialogButtonPressed(3, prompt.text)
                     PopupUtils.close(dialogue)
                 }
             }
         }
    }
    Rectangle {
        id: webViewContainer
        anchors.fill: parent
        WebView {
            id: webView
            anchors.fill: parent
            objectName: "webView"

            property string scheme: "file"
            experimental.preferences.navigatorQtObjectEnabled: true
            experimental.preferences.localStorageEnabled: true
            experimental.preferences.offlineWebApplicationCacheEnabled: true
            experimental.preferences.universalAccessFromFileURLsAllowed: true
            experimental.preferences.webGLEnabled: true
            experimental.databaseQuotaDialog: Item {
                Timer {
                    interval: 1
                    running: true
                    onTriggered: {
                        model.accept(model.expectedUsage)
                    }
                }
            }
            // port in QTWEBKIT_INSPECTOR_SERVER enviroment variable
            experimental.preferences.developerExtrasEnabled: true

            function evalInPageUnsafe(expr) {
                experimental.evaluateJavaScript('(function() { ' + expr + ' })();');
            }

            experimental.onMessageReceived: {
                if (message.data.length > 1000) {
                    console.debug("WebView received Message: " + message.data.substr(0, 900) + "...");
                } else {
                    console.debug("WebView received Message: " + message.data);
                }

                CordovaWrapper.messageHandler(message)
            }

            Component.onCompleted: {
                webView.url = cordova.mainUrl
            }

            onTitleChanged: {
                cordova.setTitle(webView.title)
            }

            onLoadingChanged: {
                if (loadRequest.status) {
                    root.completed()
                    cordova.loadFinished(true)
                }
                //TODO: check here for errors
            }

            Connections {
                target: cordova
                onJavaScriptExecNeeded: {
                    webView.experimental.evaluateJavaScript(js);
                }
                onPluginWantsToBeAdded: {
                    CordovaWrapper.addPlugin(pluginName, pluginObject)
                }
                onConfirm: {
		    PopupUtils.open(notificationDialog, root, { title: title,
                                                                text: message,
                                                                promptVisible: false,
                                                                button1Text: button1Name,
                                                                button2Text: button2Name,
                                                                button3Text: button3Name })
                }
                onPrompt: {
		    PopupUtils.open(notificationDialog, root, { title: title,
                                                                text: message,
                                                                promptVisible: true,
                                                                defaultPromptText: defaultText,
                                                                button1Text: button1Name,
                                                                button2Text: button2Name,
                                                                button3Text: button3Name })
                }
            }
        }
    }

    CaptureWidget {
        id: captureWidget
        anchors.fill: parent
        rotation: 180
    }

    Image {
        id: splashscreen
        anchors.fill: parent
        source: splashscreenPath
        visible: false
        smooth: true
        fillMode: Image.PreserveAspectFit
    }

    InAppBrowser {
        anchors.fill: parent
        id: inappbrowser
        url: root.inappbrowserUrl
    }

    states: [
        State {
            name: "main"
            PropertyChanges {
                target: webViewContainer
                visible: true
            }
            PropertyChanges {
                target: splashscreen
                visible: false
            }
            PropertyChanges {
                target: inappbrowser
                visible: false
            }
            PropertyChanges {
                target: captureWidget
                state: "off"
                rotation: 180
            }
        },
        State {
            name: "camera"
            PropertyChanges {
                target: webViewContainer
                visible: false
            }
            PropertyChanges {
                target: splashscreen
                visible: false
            }
            PropertyChanges {
                target: inappbrowser
                visible: false
            }
            PropertyChanges {
                target: captureWidget
                state: "camera"
                rotation: 0
            }
        },
        State {
            name: "recordVideo"
            PropertyChanges {
                target: webViewContainer
                visible: false
            }
            PropertyChanges {
                target: splashscreen
                visible: false
            }
            PropertyChanges {
                target: inappbrowser
                visible: false
            }
            PropertyChanges {
                target: captureWidget
                state: "videoRecording"
                rotation: 0
            }
        },
        State {
            name: "audio"
            PropertyChanges {
                target: webViewContainer
                visible: false
            }
            PropertyChanges {
                target: splashscreen
                visible: false
            }
            PropertyChanges {
                target: inappbrowser
                visible: false
            }
            PropertyChanges {
                target: captureWidget
                state: "audio"
                rotation: 0
            }
        },
        State {
            name: "splashscreen"
            PropertyChanges {
                target: webViewContainer
                visible: false
            }
            PropertyChanges {
                target: inappbrowser
                visible: false
            }
            PropertyChanges {
                target: splashscreen
                visible: true
            }
        },
        State {
            name: "InAppBrowser"
            PropertyChanges {
                target: webViewContainer
                visible: false
            }
            PropertyChanges {
                target: inappbrowser
                visible: true
            }
            PropertyChanges {
                target: splashscreen
                visible: false
            }
        }
    ]
    transitions: Transition {
        RotationAnimation { duration: 500; direction: RotationAnimation.Shortest }
    }
}
