/*
 *  Copyright 2011 Wolfgang Koller - http://www.gofg.at/
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef CONNECTION_H
#define CONNECTION_H

#include "../cplugin.h"

#include <QtSystemInfo>
#include <QtCore>

class Connection : public CPlugin {
    Q_OBJECT
public:
    explicit Connection(Cordova *cordova);

    virtual const QString fullName() override {
        return Connection::fullID();
    }

    virtual const QString shortName() override {
        return "Connection";
    }

    static const QString fullID() {
        return "com.cordova.Connection";
    }

public slots:
    void getType(int scId, int ecId);

private:
    void updateStatus();
    QSharedPointer<QNetworkInfo> m_systemNetworkInfo;
    int m_scId;
};

#endif
