/*
** $Id: html.h,v 1.6 2007/05/12 14:32:44 mrsam Exp $
*/
#ifndef	html_h
#define	html_h

/*
** Copyright 1998 - 1999 Double Precision, Inc.  See COPYING for
** distribution information.
*/



enum htmlstate {
	intext,			/* Initial value.  In plain text */
	seenlt,			/* Seen < */
	seenltbang,		/* Seen <! */
	seenltbangdash,		/* Seen <!- */
	intag,			/* Seen < but not <!, we're collecting the
				tag */

	incomment,		/* <!--, in a comment, have not seen any
				dashes */
	incommentseendash,	/* In a comment, seen - */
	incommentseendashdash,	/* In a comment, seen -- */

	skiptag			/* Ignore <!tag> */
	} ;

struct tagattrinfo {
	char *tagname;
	size_t tagnamelen;
	char *tagvalue;
	size_t tagvaluelen;

	char *atagstart;	/* Entire tag=value location */
	size_t ataglen;
	} ;

struct htmlfilter_info {

	enum htmlstate cur_state;
	unsigned instyletag;
	unsigned inscripttag;
	void *convertcid_arg;
	const char *washlink;
	const char *washlinkmailto;
	const char *contentbase;
	void (*htmlfiltered_func)(const char *, size_t);
	char *(*htmlconvertcid_func)(const char *, void *);

	char *tagbuf;
	size_t tagbufsize, tagbuflen;

	struct tagattrinfo *tagattr;
	size_t tagattrsize, tagattrlen;

};



extern struct htmlfilter_info *htmlfilter_alloc(void (*)(const char *, size_t));
extern void htmlfilter_free(struct htmlfilter_info *);

extern void htmlfilter(struct htmlfilter_info *,
		       const char *, size_t);
extern void htmlfilter_washlink(struct htmlfilter_info *,
				const char *p);
extern void htmlfilter_washlinkmailto(struct htmlfilter_info *,
				      const char *p);
extern void htmlfilter_convertcid(struct htmlfilter_info *,
				  char *(*)(const char *, void *), void *);
extern void htmlfilter_contentbase(struct htmlfilter_info *,
				   const char *);

#endif
