/*****************************************************************
 *
 *   rcfile.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

/*******************************
 * Debian Chinese Panel
 * rcfile
 *
 * Copyright (C) 2000 Kam Tik
 * Released under GPL
 * *****************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"
#include "defaults.h"

/* Variables for External Use */
gchar crxvt_command[STR_BUFFER_SIZE]=CRXVT_COMMAND;
gchar crxvt_command_gb[STR_BUFFER_SIZE]=CRXVT_COMMAND_GB;
gchar crxvt_bg[STR_BUFFER_SIZE]=CRXVT_BG;
gchar crxvt_fg[STR_BUFFER_SIZE]=CRXVT_FG;
gchar crxvt_fonts[STR_BUFFER_SIZE]=CRXVT_FONTS;
gchar crxvt_fonts_gb[STR_BUFFER_SIZE]=CRXVT_FONTS_GB;
gchar crxvt_im[STR_BUFFER_SIZE]=CRXVT_IM;
gboolean start_mainwin2=START_MAINWIN2;
gboolean xcin_hide=XCIN_HIDE;
gboolean disable_wm_ctrl=DISABLE_WM_CTRL;
gboolean overspot_use_fontset=OVERSPOT_USE_FONTSET;
gboolean overspot_window_only=OVERSPOT_WINDOW_ONLY;
gchar xcin23_command[STR_BUFFER_SIZE]=XCIN23_COMMAND;
gchar xcin23_in[STR_BUFFER_SIZE]=XCIN23_IN;
gchar gtk_font[STR_BUFFER_SIZE]=GTK_FONT;
gchar gtk_font_gb[STR_BUFFER_SIZE]=GTK_FONT_GB;
gchar locale[STR_BUFFER_SIZE]=LOCALE;
gchar wm_command[STR_BUFFER_SIZE];
gchar input_method[STR_BUFFER_SIZE]=INPUT_METHOD;
gboolean if_gb=IF_GB;
gboolean if_cv_wm=IF_CV_WM;
gboolean if_xa=IF_XA;
gboolean if_cv=IF_CV;
gboolean if_welcome=0;
gboolean if_not_warning=0;

gboolean if_float=IF_FLOAT;
gint coord_x=COORD_X;
gint coord_y=COORD_Y;

gchar version_server_name[STR_BUFFER_SIZE]=VERSION_SERVER_NAME;
gint version_port=VERSION_PORT;

/****************************************
 * Load configuration parameters
 * **************************************/
void loadconfig(void)
{
	FILE *f;
	gchar *rc_path;
	gchar str[1024];
	gchar option[1024];
	gchar value[1024];
	gchar *option_ptr;
	gchar *value_ptr=NULL;
	gint c,len; /* count & string length */

	rc_path = g_strconcat(getenv("HOME"),"/",RC_FILE_NAME,NULL);

	f = fopen(rc_path,"r");
	if(!f)
	{
		g_free(rc_path);
		saveconfig();
		/* 2nd parameter: 0 for big5, 1 for gb */
		save_gtk_fonts(GTK_FONT,0);
		save_gtk_fonts(GTK_FONT_GB,1);
		if_welcome = 1;
		return;
	}

	while(fgets(str,1024,f))
	{
		len = strlen(str);
		c = 0;

		/* skip space before string */
		while(str[c]==' ' && c < len) c++;
		/* skip lines */
		if(str[c]=='#') continue;
		if(str[c]=='\n') continue;
		if(str[c]==':') continue;

		/* point to start of first character of the option */
		option_ptr = str + c;

		/* end option */
		while(str[c]!=' ' && str[c]!='\n' && c < len) c++;
		str[c] = '\0';

		/* gets its value */
		if(c >= len) value[0]='\0';
		else
		{
			c++;
			while(str[c]==' ' && c < len) c++;
			value_ptr = str + c;
			while(str[c]!='\n' && c<len) c++;
			str[c] = '\0';
		}

		strcpy(option,option_ptr);
		strcpy(value,value_ptr);

		/**********************************
		 * OK, got option & value
		 * Please add options here!
		 * ********************************/

		/* crxvt options */
		if(!strcasecmp(option,"crxvt_command"))
			strcpy(crxvt_command,value);
		if(!strcasecmp(option,"crxvt_command_gb"))
			strcpy(crxvt_command_gb,value);
		if(!strcasecmp(option,"crxvt_bg")) strcpy(crxvt_bg,value);
		if(!strcasecmp(option,"crxvt_fg")) strcpy(crxvt_fg,value);
		if(!strcasecmp(option,"crxvt_fonts")) strcpy(crxvt_fonts,value);
		if(!strcasecmp(option,"crxvt_fonts_gb")) 
			strcpy(crxvt_fonts_gb,value);
		if(!strcasecmp(option,"crxvt_im")) strcpy(crxvt_im,value);
		/* xcin options */
		if(!strcasecmp(option,"start_mainwin2"))
			start_mainwin2 = atof(value);
		if(!strcasecmp(option,"xcin_hide"))
			xcin_hide = atof(value);
		if(!strcasecmp(option,"disable_wm_ctrl"))
			disable_wm_ctrl = atof(value);
		if(!strcasecmp(option,"overspot_use_fontset"))
			overspot_use_fontset = atof(value);
		if(!strcasecmp(option,"overspot_window_only"))
			overspot_window_only = atof(value);
		/* xcin2.3 options */
		if(!strcasecmp(option,"xcin23_command"))
			strcpy(xcin23_command,value);
		if(!strcasecmp(option,"xcin23_in"))
			strcpy(xcin23_in,value);
		/* gtk_fonts options */
		if(!strcasecmp(option,"gtk_font"))
			strcpy(gtk_font,value);
		if(!strcasecmp(option,"gtk_font_gb"))
			strcpy(gtk_font_gb,value);
		/* set_locale options */
		if(!strcasecmp(option, "locale"))
			strcpy(locale,value);
		if(!strcasecmp(option, "wm_command"))
			strcpy(wm_command,value);
		if(!strcasecmp(option, "input_method"))
			strcpy(input_method,value);
		if(!strcasecmp(option, "if_cv_wm"))
			if_cv_wm = atof(value);
		if(!strcasecmp(option, "if_xa"))
			if_xa = atof(value);
		if(!strcasecmp(option, "if_cv"))
			if_cv = atof(value);
		if(!strcasecmp(option, "if_float"))
			if_float = atof(value);
		if(!strcasecmp(option, "coord_x"))
			coord_x = atof(value);
		if(!strcasecmp(option, "coord_y"))
			coord_y = atof(value);
		if(!strcasecmp(option, "if_gb"))
			if_gb = atof(value);
		if(!strcasecmp(option, "if_not_warning"))
			if_not_warning = atof(value);
		if(!strcasecmp(option, "version_server_name"))
			strcpy(version_server_name,value);
		if(!strcasecmp(option, "version_port"))
			version_port = atof(value);
	}
	g_free(rc_path);
}

void saveconfig(void)
{
	FILE *f;
	gchar *rc_path;

	rc_path = g_strconcat(getenv("HOME"),"/",RC_FILE_NAME,NULL);

	f = fopen(rc_path,"w");
	if(!f)
	{
		printf("Error saving config file: %s\n",rc_path);
		printf("Does $HOME point to your home dir??\n");
		g_free(rc_path);
		return;
	}

	fprintf(f,"#######################################################\n");
	fprintf(f,"#                 Debian Chinese Panel                #\n");
	fprintf(f,"#                    Version %d.%d.%d                    #\n"
			,VERSION_MAJOR,VERSION_MINOR,VERSION_MICRO);
	fprintf(f,"#                                                     #\n");
	fprintf(f,"#  Nothing here need to be changed by hand            #\n");
	fprintf(f,"#  If you know what you're doing, just do it :)       #\n");
	fprintf(f,"#######################################################\n");
	fprintf(f,"\n");
	
	fprintf(f,"#### GB support ####\n");
	fprintf(f,"if_gb %d\n",if_gb);
	fprintf(f,"\n");
	
	fprintf(f,"#### crxvt ####\n");
	fprintf(f,"crxvt_command %s\n",crxvt_command);
	fprintf(f,"crxvt_command_gb %s\n",crxvt_command_gb);
	fprintf(f,"crxvt_bg %s\n",crxvt_bg);
	fprintf(f,"crxvt_fg %s\n",crxvt_fg);
	fprintf(f,"crxvt_fonts %s\n",crxvt_fonts);
	fprintf(f,"crxvt_fonts_gb %s\n",crxvt_fonts_gb);
	fprintf(f,"crxvt_im %s\n",crxvt_im);
	fprintf(f,"\n");

	fprintf(f,"#### xcin ####\n");
	fprintf(f,"start_mainwin2 %d\n",start_mainwin2);
	fprintf(f,"xcin_hide %d\n",xcin_hide);
	fprintf(f,"disable_wm_ctrl %d\n",disable_wm_ctrl);
	fprintf(f,"overspot_use_fontset %d\n",overspot_use_fontset);
	fprintf(f,"overspot_window_only %d\n",overspot_window_only);
	fprintf(f,"\n");

	fprintf(f,"#### xcin2.3 ####\n");
	fprintf(f,"xcin23_command %s\n",xcin23_command);
	fprintf(f,"xcin23_in %s\n",xcin23_in);
	fprintf(f,"\n");

	fprintf(f,"#### gtk_fonts ####\n");
	fprintf(f,"gtk_font %s\n",gtk_font);
	fprintf(f,"gtk_font_gb %s\n",gtk_font_gb);
	fprintf(f,"\n");

	fprintf(f,"#### set_locale ####\n");
	fprintf(f,"locale %s\n",locale);
	fprintf(f,"wm_command %s\n",wm_command);
	fprintf(f,"input_method %s\n",input_method);
	fprintf(f,"if_cv_wm %d\n",if_cv_wm);
	fprintf(f,"\n");

	fprintf(f,"#### xacv ####\n");
	fprintf(f,"if_xa %d\n",if_xa);
	fprintf(f,"if_cv %d\n",if_cv);
	fprintf(f,"\n");

	fprintf(f,"#### Option settings ####\n");
	fprintf(f,"if_float %d\n",if_float);
	fprintf(f,"coord_x %d\n",coord_x);
	fprintf(f,"coord_y %d\n",coord_y);
	fprintf(f,"if_not_warning %d\n",if_not_warning);
	fprintf(f,"version_server_name %s\n",version_server_name);
	fprintf(f,"version_port %d\n",version_port);
	fprintf(f,"\n");
	

	fprintf(f,"#######################################################\n");
	fprintf(f,"#                         EOF                         #\n");
	fprintf(f,"#######################################################");

	fclose(f);

	g_free(rc_path);
}
