/* $Id: sinfo_pfits.h,v 1.6 2012-03-22 15:26:10 amodigli Exp $
 *
 * This file is part of the NACO Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2012-03-22 15:26:10 $
 * $Revision: 1.6 $
 * $Name: not supported by cvs2svn $
 */

#ifndef SINFO_PFITS_H
#define SINFO_PFITS_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>

/*
#include <sinfo_dfs.h>
*/

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/

CPL_BEGIN_DECLS
const char * sinfo_pfits_get_rec1raw1name(const cpl_propertylist * plist) ;
const char * sinfo_pfits_get_band(const cpl_propertylist * plist);
float sinfo_pfits_get_pixelscale (const char * filename );
double sinfo_pfits_get_targ_alpha(const cpl_propertylist * plist);
double sinfo_pfits_get_targ_delta(const cpl_propertylist * plist);

/*
char * sinfo_pfits_get_rec1raw1name(const char * filename) ;
*/
int sinfo_pfits_get_expno(const cpl_propertylist *) ;
double  sinfo_pfits_get_exptime(const char *) ;
char * sinfo_pfits_get_mode(const cpl_propertylist *) ;

double sinfo_pfits_get_pixscale(const cpl_propertylist * plist);
double sinfo_pfits_get_exp_time(const cpl_propertylist* plist);
double sinfo_pfits_get_DEC(const cpl_propertylist * plist);
double sinfo_pfits_get_posangle(const cpl_propertylist * plist);
int sinfo_pfits_get_rom(const cpl_propertylist * propertylist);
const char * sinfo_pfits_get_ncorrs_name(const cpl_propertylist * plist) ;
const char * sinfo_pfits_get_date_obs(const cpl_propertylist * plist) ;
const char * sinfo_pfits_get_ins_setup(const cpl_propertylist * plist);
double sinfo_pfits_get_airmass_start(const cpl_propertylist * plist) ;
const char * sinfo_pfits_get_templateid(const cpl_propertylist * plist) ;
double sinfo_pfits_get_dit(const cpl_propertylist * plist) ;
int    sinfo_pfits_get_ndit(const cpl_propertylist * plist) ;
const char * sinfo_pfits_get_dpr_catg(const cpl_propertylist * plist) ;
const char * sinfo_pfits_get_dpr_tech(const cpl_propertylist * plist) ;
const char * sinfo_pfits_get_dpr_type(const cpl_propertylist * plist) ;
const char * sinfo_pfits_get_arcfile(const cpl_propertylist * plist) ;
double sinfo_pfits_get_ditndit(const char* name);
/* not used */
int sinfo_pfits_get_nodpos(const cpl_propertylist *) ;
double sinfo_pfits_get_ra(const cpl_propertylist *) ;
double sinfo_pfits_get_resol(const cpl_propertylist *) ;
const char * sinfo_pfits_get_starname(const cpl_propertylist *) ;
const char * sinfo_pfits_get_obs_id(const cpl_propertylist *) ;
const char * sinfo_pfits_get_instrument(const cpl_propertylist *) ;
const char * sinfo_pfits_get_filter_spec(const cpl_propertylist *) ;
const char * sinfo_pfits_get_filter_im(const cpl_propertylist *) ;
const char * sinfo_pfits_get_frame_type(const cpl_propertylist *) ;
int sinfo_pfits_get_numbexp(const cpl_propertylist *) ;
double sinfo_pfits_get_mjdobs(const cpl_propertylist *) ;
double sinfo_pfits_get_focus(const cpl_propertylist *) ;
double sinfo_pfits_get_cumoffsetx(const cpl_propertylist *) ;
double sinfo_pfits_get_cumoffsety(const cpl_propertylist *) ;
double sinfo_pfits_get_alpha(const cpl_propertylist *) ;
double sinfo_pfits_get_airmass_end(const cpl_propertylist *) ;
double sinfo_pfits_get_dec(const cpl_propertylist *) ;
double sinfo_pfits_get_wlen(const cpl_propertylist *) ;
double sinfo_pfits_get_delta(const cpl_propertylist *) ;
int sinfo_pfits_get_naxis1(const cpl_propertylist *) ;
int sinfo_pfits_get_naxis2(const cpl_propertylist *) ;
int sinfo_pfits_get_naxis3(const cpl_propertylist *) ;


double sinfo_pfits_get_crval1(const cpl_propertylist *) ;
double sinfo_pfits_get_crval2(const cpl_propertylist *) ;
double sinfo_pfits_get_crval3(const cpl_propertylist *) ;

double sinfo_pfits_get_crpix1(const cpl_propertylist *) ;
double sinfo_pfits_get_crpix2(const cpl_propertylist *) ;
double sinfo_pfits_get_crpix3(const cpl_propertylist *) ;

double sinfo_pfits_get_cdelt1(const cpl_propertylist *) ;
double sinfo_pfits_get_cdelt2(const cpl_propertylist *) ;
double sinfo_pfits_get_cdelt3(const cpl_propertylist *) ;


/* keys not existent */
int sinfo_pfits_get_chop_ncycles(const cpl_propertylist * plist) ;
double sinfo_pfits_get_monoc_pos(const cpl_propertylist *) ;
cpl_error_code
sinfo_plist_set_extra_keys(cpl_propertylist* plist,
			 const char* hduclas1,
			 const char* hduclas2,
			 const char* hduclas3,
			 const char* scidata,
			 const char* errdata,
			 const char* qualdata,
                         const int type);
CPL_END_DECLS

#endif
