# CPL_SET_PREFIX
#---------------
# Sets and the directory prefix for the package installation. If no
# directory prefix was given on the command line the default prefix
# is appended to the configure argument list and thus passed to
# the subdirs configure.
AC_DEFUN([CPL_SET_PREFIX],
[
  unset CDPATH
  # make $CPLDIR the default for the installation
  AC_PREFIX_DEFAULT(${CPLDIR:-/usr/local/cpl})

  if test "x$prefix" = "xNONE"; then
    prefix=$ac_default_prefix
    ac_configure_args="$ac_configure_args --prefix $prefix"
  fi
])


# CPL_CONFIG_VERSION(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([CPL_CONFIG_VERSION],
[
    cpl_version_string="$1"

    cpl_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    cpl_major_version=`echo "$cpl_version" | \
    sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    cpl_minor_version=`echo "$cpl_version" | \
    sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    cpl_micro_version=`echo "$cpl_version" | \
    sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$cpl_major_version"; then
        cpl_major_version=0
    fi

    if test -z "$cpl_minor_version"; then
        cpl_minor_version=0
    fi

    if test -z "$cpl_micro_version"; then
        cpl_micro_version=0
    fi

    CPL_VERSION="$cpl_version"
    CPL_VERSION_STRING="$cpl_version_string"
    CPL_MAJOR_VERSION=$cpl_major_version
    CPL_MINOR_VERSION=$cpl_minor_version
    CPL_MICRO_VERSION=$cpl_micro_version

    if test -z "$4"; then
        CPL_INTERFACE_AGE=0
    else
        CPL_INTERFACE_AGE="$4"
    fi

    CPL_BINARY_AGE=`expr 256 '*' $CPL_MINOR_VERSION + $CPL_MICRO_VERSION`
    CPL_BINARY_VERSION=`expr 65536 '*' $CPL_MAJOR_VERSION + $CPL_BINARY_AGE`

    AC_SUBST(CPL_VERSION)
    AC_SUBST(CPL_VERSION_STRING)
    AC_SUBST(CPL_MAJOR_VERSION)
    AC_SUBST(CPL_MINOR_VERSION)
    AC_SUBST(CPL_MICRO_VERSION)
    AC_SUBST(CPL_INTERFACE_AGE)
    AC_SUBST(CPL_BINARY_VERSION)
    AC_SUBST(CPL_BINARY_AGE)

    AC_DEFINE_UNQUOTED(CPL_MAJOR_VERSION, $CPL_MAJOR_VERSION,
                       [CPL major version number])
    AC_DEFINE_UNQUOTED(CPL_MINOR_VERSION, $CPL_MINOR_VERSION,
                       [CPL minor version number])
    AC_DEFINE_UNQUOTED(CPL_MICRO_VERSION, $CPL_MICRO_VERSION,
                       [CPL micro version number])
    AC_DEFINE_UNQUOTED(CPL_INTERFACE_AGE, $CPL_INTERFACE_AGE,
                       [CPL interface age])
    AC_DEFINE_UNQUOTED(CPL_BINARY_VERSION, $CPL_BINARY_VERSION,
                       [CPL binary version number])
    AC_DEFINE_UNQUOTED(CPL_BINARY_AGE, $CPL_BINARY_AGE,
                       [CPL binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])

    AC_CONFIG_COMMANDS([cplcore/cpl_version.h.in],
                       [cfgfile="cplcore/cpl_version.h.in"
                        cat > $cfgfile << _CPLEOF

_CPLEOF
                        echo '#define CPL_VERSION_STRING "'$version_string'"' >> $cfgfile
                        echo "#define CPL_VERSION_CODE $version_code" >> $cfgfile
                        cat >> $cfgfile << _CPLEOF

#define CPL_VERSION(major, minor, micro) \\
(((major) * 65536) + ((minor) * 256) + (micro))

_CPLEOF
                       ], [version_code=$CPL_BINARY_VERSION version_string=$CPL_VERSION_STRING])

])


# CPL_BASE_PATHS
#---------------
AC_DEFUN([CPL_BASE_PATHS],
[
    AC_MSG_CHECKING([for CPL])

    if test x"${prefix}" = xNONE; then
        cpl_prefix="$ac_default_prefix"
    else
        cpl_prefix="$prefix"
    fi

    if test x"$exec_prefix" = xNONE; then
        cpl_exec_prefix="$cpl_prefix"
        AC_MSG_RESULT([will be installed in $cpl_prefix])
    else
        cpl_exec_prefix="$exec_prefix"
        AC_MSG_RESULT([will be installed in $cpl_prefix and $cpl_exec_prefix])
    fi

    cpl_libraries="${cpl_exec_prefix}/lib"
    cpl_includes=${cpl_prefix}/include

    AC_SUBST(cpl_includes)
    AC_SUBST(cpl_libraries)

    CPLCORE_INCLUDES='-I$(top_srcdir)/cplcore -I$(top_builddir)/cplcore'
    CPLDRS_INCLUDES="-I\$(top_srcdir)/cpldrs -I\$(top_builddir)/cpldrs"
    CPLUI_INCLUDES='-I$(top_srcdir)/cplui -I$(top_builddir)/cplui'
    CPLDFS_INCLUDES='-I$(top_srcdir)/cpldfs -I$(top_builddir)/cpldfs'
    CPL_INCLUDES="$CPLDFS_INCLUDES $CPLUI_INCLUDES $CPLDRS_INCLUDES $CPLCORE_INCLUDES"

    CPL_LDFLAGS=""

    AC_SUBST(CPLCORE_INCLUDES)
    AC_SUBST(CPLDRS_INCLUDES)
    AC_SUBST(CPLUI_INCLUDES)
    AC_SUBST(CPLDFS_INCLUDES)
    AC_SUBST(CPL_LDFLAGS)

    CX_INCLUDES='-I$(top_srcdir)/libcext/cext -I$(top_builddir)/libcext/cext'
    CX_LDFLAGS=""

    AC_SUBST(CX_INCLUDES)
    AC_SUBST(CX_LDFLAGS)

    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes="$CPL_INCLUDES $CX_INCLUDES $WCS_INCLUDES $CFITSIO_INCLUDES $all_includes"
    all_includes="$EXTRA_INCLUDES $all_includes"
    all_ldflags="$EXTRA_LDFLAGS $all_ldflags"

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)

])


# CPL_SET_PATHS
#--------------
# Define auxiliary directories of the CPL tree.
AC_DEFUN([CPL_SET_PATHS],
[

    AC_REQUIRE([CPL_BASE_PATHS])

    if test -z "$configdir"; then
        configdir='${datadir}/${PACKAGE}/config'
    fi


    if test -z "$htmldir"; then
        htmldir='${datadir}/doc/${PACKAGE}/html'
    fi

    AC_SUBST(configdir)
    AC_SUBST(htmldir)


    # Define a preprocesor symbol for the application search paths

    config_dir="`eval echo $configdir`"
    config_dir="`eval echo $config_dir`"

    AC_DEFINE_UNQUOTED(CPL_CONFIG_DIR, "$config_dir",
                       [Directory prefix for system configuration files])

])


# CPL_EXPORT_DIRS(dir=directory-list)
#------------------------------------
# Add extra directories to the command line arguments when configuring
# subdirectories.
AC_DEFUN([CPL_EXPORT_DIRS],
[

    for d in $1; do
        eval cpl_propagate_dir="\$$d"
        ac_configure_args="$ac_configure_args $d='$cpl_propagate_dir'"
    done

])


# CPL_FUNC_GETOPT
#----------------
# Checks for GNU getopt_long declaration and function.
AC_DEFUN([CPL_FUNC_GETOPT],
[

    AH_TEMPLATE([HAVE_GETOPT_LONG],
                [Define if you have the `getopt_long' function])

    ESO_CHECK_FUNC(getopt_long, [#include <getopt.h>], HAVE_GETOPT_LONG)

    if test x"$ac_cv_func_getopt_long" = xno ||
       test x"$eso_cv_have_decl_getopt_long" = xno; then
        if test -n "$LIBTOOL"; then
            GETOPT="getopt.lo getopt1.lo"
        else
            GETOPT="getopt.$ac_objext getopt1.$ac_objext"
        fi
    fi

    AC_SUBST(GETOPT)

])


# CPL_CONFIG_FUNC()
#----------------------------------------------------------
# Setup creation of body of cpl_func.h
AC_DEFUN([CPL_CONFIG_FUNC],
[

    AC_LINK_IFELSE([
int main(void)
{
    return (int)__func__;
}],
                    cpl_cv_func_has_func=__func__,
                    cpl_cv_func_has_func='"\"\""',
                    cpl_cv_func_has_func='"\"\""')

    AC_CONFIG_COMMANDS([cplcore/cpl_func.h.in],
                       [cfgfile="cplcore/cpl_func.h.in"
                        echo "#define cpl_func $cpl_func_value" > $cfgfile
                       ], [cpl_func_value=$cpl_cv_func_has_func])

])


# CPL_PATH_JAVA
#--------------
# Checks for an existing java installation
AC_DEFUN([CPL_PATH_JAVA],
[

    AC_REQUIRE([AC_CANONICAL_BUILD])

    cpl_java_check_java="java"
    cpl_java_check_javac="javac"
    cpl_java_check_javah="javah"
    cpl_java_check_header="jni.h"
    cpl_java_check_header_md="jni_md.h"
    cpl_java_path=""

    AC_ARG_WITH(java,
                AC_HELP_STRING([--with-java],
                               [location where java is installed]),
                [
                    cpl_with_java=$withval
                ])

    AC_ARG_WITH(java-includes,
                AC_HELP_STRING([--with-java-includes],
                               [location of the java header files]),
                [
                    cpl_with_java_includes=$withval
                ])

    AC_ARG_WITH(java-includes-md,
                AC_HELP_STRING([--with-java-includes-md],
                               [location of the machine dependent java header files]),
                [
                    cpl_with_java_includes_md=$withval
                ])


    AC_MSG_CHECKING([for Java Development Kit])

    AC_ARG_VAR([JAVA], [Java application launcher])
    AC_ARG_VAR([JAVAC], [Java compiler command])
    AC_ARG_VAR([JAVAH], [Java C header and stub file generator])

    AC_CACHE_VAL([cpl_cv_path_java],
                 [
                     if test x"$cpl_with_java" != xno; then

                          if test -z "$cpl_with_java"; then
                              test -n "$JAVA_HOME" && cpl_java_dirs="$JAVA_HOME/bin $JAVA_HOME/Commands"
                          else
                              cpl_java_dirs="$cpl_with_java/bin $cpl_with_java/Commands"
                          fi

                          ESO_FIND_FILE($cpl_java_check_java, $cpl_java_dirs, cpl_java_path)

                      else
                        cpl_java_path="no"
                      fi

                      if test x"$cpl_java_path" = xno; then
                          cpl_cv_path_java="no"
                          JAVA=":"
                          JAVAC=":"
                      else
                          JAVA="$cpl_java_path/$cpl_java_check_java"

                          if test -x $cpl_java_path/$cpl_java_check_javac; then
                              JAVAC="$cpl_java_path/$cpl_java_check_javac"
                          else
                              JAVAC=":"
                          fi

                          if test -x $cpl_java_path/$cpl_java_check_javah; then
                              JAVAH="$cpl_java_path/$cpl_java_check_javah"
                          else
                              JAVAH=":"
                          fi

                          cpl_cv_path_java="`echo $cpl_java_path | sed -e 's;/bin$;;'`"
                          if test $cpl_cv_path_java = $cpl_java_path ; then
                              cpl_cv_path_java="`echo $cpl_java_path | sed -e 's;/Commands$;;'`"
                          fi
                      fi
                 ])

    AC_CACHE_VAL([cpl_cv_env_java_os],
                 [
                    if test x"$cpl_cv_path_java" = xno; then
                        cpl_cv_env_java_os="unknown"
                    else
                        case $build in
                        *-*-linux*)
                            cpl_cv_env_java_os="linux"
                            ;;
                        *-*-freebsd*)
                            cpl_cv_env_java_os="bsd"
                            ;;
                        *-*-solaris*)
                            cpl_cv_env_java_os="solaris"
                            ;;
                        *-*-hpux*)
                            cpl_cv_env_java_os="hp-ux"
                            ;;
                        *-*-irix*)
                            cpl_cv_env_java_os="irix"
                            ;;
                        *-*-aix*)
                            cpl_cv_env_java_os="aix"
                            ;;
                        *-*-sequent*)
                            cpl_cv_env_java_os="ptx"
                            ;;
                        *-*-os390*)
                            cpl_cv_env_java_os="os390"
                            ;;
                        *-*-os400*)
                            cpl_cv_env_java_os="os400"
                            ;;
                        *-apple-darwin*|*-apple-rhapsody*)
                            cpl_cv_env_java_os="darwin"
                            ;;
                        *-*-cygwin*|*-*-mingw*)
                            cpl_cv_env_java_os="win32"
                            ;;
                        *)
                            if test -d $cpl_cv_path_java/include/genunix; then
                                cpl_cv_env_java_os="genunix"
                            else
                                cpl_cv_env_java_os="unknown"
                            fi
                            ;;
                        esac
                    fi
                 ])

    AC_CACHE_VAL([cpl_cv_header_java],
                 [
                    if test x"$cpl_cv_path_java" = xno; then
                        cpl_java_includes="no"
                    else
                        if test -z "$cpl_with_java_includes"; then
                            cpl_java_incdirs="$cpl_cv_path_java/include $cpl_cv_path_java/Headers"
                        else
                            cpl_java_incdirs="$cpl_with_java_includes"
                        fi

                        ESO_FIND_FILE($cpl_java_check_header, $cpl_java_incdirs, cpl_java_includes)
                    fi

                    if test x"$cpl_java_includes" = xno; then
                        cpl_cv_header_java="no"
                    else
                        cpl_cv_header_java="$cpl_java_includes"
                    fi
                 ])


    AC_CACHE_VAL([cpl_cv_header_java_md],
                 [
                    if test x"$cpl_cv_path_java" = xno || test x"$cpl_cv_header_java" = xno; then
                        cpl_cv_header_java_md="no"
                    else
                        cpl_java_includes_md="no"

                        if test -z "$cpl_with_java_includes_md"; then

                            cpl_java_incdirs="$cpl_cv_header_java"

                            if test x"$cpl_cv_env_java_os" != xunknown; then
                                cpl_java_incdirs="$cpl_cv_header_java/$cpl_cv_env_java_os $cpl_java_incdirs"
                            fi

                            ESO_FIND_FILE($cpl_java_check_header_md, $cpl_java_incdirs, cpl_java_includes_md)
                        else
                            cpl_java_incdirs="$cpl_with_java_includes_md"
                            ESO_FIND_FILE($cpl_java_check_header_md, $cpl_java_incdirs, cpl_java_includes_md)
                        fi

                        cpl_cv_header_java_md="$cpl_java_includes_md"
                    fi
                 ])


    if test x"$cpl_cv_path_java" = xno; then
        AC_MSG_RESULT([no])
    else
        if test x"$cpl_cv_header_java" = xno || test x"$cpl_cv_header_java_md" = xno; then
            if test x"$cpl_cv_header_java" = xno; then
                if test x"$cpl_cv_header_java_md" = xno; then
                    cpl_notfound="$cpl_java_check_header and $cpl_java_check_header_md"
                else
                    cpl_notfound="$cpl_java_check_header"
                fi
            else
                cpl_notfound="$cpl_java_check_header_md"
            fi
            AC_MSG_RESULT([$cpl_cv_path_java, headers $cpl_java_notfound not found])
        else
            AC_MSG_RESULT([$cpl_cv_path_java, headers $cpl_cv_header_java, $cpl_cv_header_java_md])
        fi
    fi

    # Setup the Makefile symbols
    if test x"$cpl_cv_path_java" != xno; then
        
    
        if test -f "$cpl_cv_path_java/Commands/java" ; then
            JAVA="$cpl_cv_path_java/Commands/java"
        else
            JAVA="$cpl_cv_path_java/bin/java"
        fi

        if test x"$cpl_cv_header_java" != xno && test x"$cpl_cv_header_java_md" != xno; then
            JAVA_INCLUDES="-I$cpl_cv_header_java -I$cpl_cv_header_java_md"
        else
            JAVA_INCLUDES=""
        fi
    else
        JAVA=":"
        JAVA_INCLUDES=""
    fi

    AC_SUBST([JAVA])
    AC_SUBST([JAVAC])
    AC_SUBST([JAVAH])
    AC_SUBST([JAVA_INCLUDES])

])


# CPL_PATH_GASGANO
#------------------
# Checks for an existing Gasgano installation.
AC_DEFUN([CPL_PATH_GASGANO],
[

    cpl_gasgano_check_prog="gasgano"
    cpl_gasgano_prog="no"

    AC_ARG_WITH(gasgano,
                AC_HELP_STRING([--with-gasgano],
                               [location where Gasgano is installed]),
                [
                    cpl_with_gasgano=$withval
                ])



    AC_MSG_CHECKING([for $cpl_gasgano_check_prog])

    AC_CACHE_VAL([cpl_cv_path_gasgano],
                 [

                     if test x"$cpl_with_gasgano" != xno; then

                          if test -z "$cpl_with_gasgano"; then
                              cpl_gasgano_dirs="$HOME/gasgano/bin /opt/gasgano/bin /usr/local/gasgano/bin"

                              test -n "$GASGANODIR" && cpl_gasgano_dirs="$GASGANODIR/bin \
                                                                         $cpl_gasgano_dirs"
                          else
                              cpl_gasgano_dirs="$cpl_with_gasgano/bin"
                          fi

                          ESO_FIND_FILE($cpl_gasgano_check_prog, $cpl_gasgano_dirs,
                                        cpl_gasgano_prog)

                      fi

                      if test "x$cpl_gasgano_prog" = xno; then
                          cpl_cv_path_gasgano="no"
                      else
                          cpl_cv_path_gasgano="`echo $cpl_gasgano_prog | sed -e 's/\/bin$//'`"
                      fi
                 ])

    AC_CACHE_VAL([cpl_cv_prog_gasgano],
                 [
                     if test -n "$cpl_cv_path_gasgano"; then
                        if test -x "$cpl_cv_path_gasgano/bin/$cpl_gasgano_check_prog"; then
                            cpl_cv_prog_gasgano="$cpl_cv_path_gasgano/bin/$cpl_gasgano_check_prog"
                        else
                            cpl_cv_prog_gasgano="no"
                        fi
                     fi
                 ])

    if test x"$cpl_cv_prog_gasgano" = xno; then
        AC_MSG_RESULT([no])
    else
        AC_MSG_RESULT([$cpl_cv_prog_gasgano])
    fi

])


# CPL_CLASSPATH_GASGANO
#----------------------
# Checks for the location of the Gasgano jar files.
AC_DEFUN([CPL_CLASSPATH_GASGANO],
[

    AC_REQUIRE([CPL_PATH_GASGANO])

    AC_MSG_CHECKING([for gasgano jar files])

    cpl_gasgano_check_jar="gasgano.jar"
    cpl_gasgano_jarfiles="no"

    GASGANO_CLASSPATH=""


    AC_ARG_WITH(gasgano-classpath,
                AC_HELP_STRING([--with-gasgano-classpath],
                               [location where the Gasgano jar files are installed]),
                [
                    cpl_with_gasgano_jarfiles=$withval
                ])

    AC_CACHE_VAL([cpl_cv_classpath_gasgano],
                 [
                     if test x"$cpl_cv_path_gasgano" != xno; then

                         if test -z "$cpl_with_gasgano_jarfiles"; then
                             cpl_gasgano_jardirs="$cpl_cv_path_gasgano/share"
                         else
                             cpl_gasgano_jardirs="$cpl_with_gasgano_jarfiles"
                         fi

                         ESO_FIND_FILE($cpl_gasgano_check_jar, $cpl_gasgano_jardirs,
                                       cpl_gasgano_jarfiles)

                         if test "x$cpl_gasgano_jarfiles" = xno; then
                             cpl_cv_path_gasgano_jarfiles="no"
                         else
                             cpl_cv_path_gasgano_jarfiles="$cpl_gasgano_jarfiles"
                         fi

                     else
                         cpl_cv_path_gasgano_jarfiles="no"
                     fi
                 ])

    if test x"$cpl_cv_path_gasgano_jarfiles" = xno; then
        GASGANO_CLASSPATH=""
        AC_MSG_RESULT([no])
    else
        GASGANO_CLASSPATH=""
        for f in `ls -1 $cpl_cv_path_gasgano_jarfiles/*.jar`; do
            if test -z "$GASGANO_CLASSPATH"; then
                GASGANO_CLASSPATH="$f"
            else
                GASGANO_CLASSPATH="$GASGANO_CLASSPATH:$f"
            fi
        done
        AC_MSG_RESULT([$cpl_cv_path_gasgano_jarfiles])
    fi

    AC_SUBST([GASGANO_CLASSPATH])

])


# CPL_ENABLE_GASGANO
#------------------
# Check whether the Gasgano interface library should/can be built.
AC_DEFUN([CPL_ENABLE_GASGANO],
[

    AC_REQUIRE([CPL_PATH_JAVA])
    AC_REQUIRE([CPL_CLASSPATH_GASGANO])

    AC_ARG_ENABLE(gasgano,
                  AC_HELP_STRING([--enable-gasgano],
                                 [build the gasgano support library [[default=yes]]]),
                  cpl_enable_gasgano=$enableval,
                  cpl_enable_gasgano=yes)

    AC_MSG_CHECKING([whether the Gasgano interface library can be built])

    if test x"$cpl_enable_gasgano" != xyes; then
        cpl_gasgano_support="no"
        AC_MSG_RESULT([no])
    else
        if test -n "$JAVA_INCLUDES" && test -n "$GASGANO_CLASSPATH"; then
            cpl_gasgano_support="yes"
            AC_MSG_RESULT([yes])
        else
            cpl_gasgano_support="no"
            AC_MSG_RESULT([no])
        fi

    fi

    AM_CONDITIONAL([GASGANO_SUPPORT], [test x"$cpl_gasgano_support" = xyes])

    GASGANO_SHREXT=""
    if test x"$cpl_gasgano_support" = xyes; then
        case $cpl_cv_env_java_os in
        darwin)
            GASGANO_SHREXT="-shrext .jnilib"
            ;;
        *)
            ;;
        esac
    fi

    AC_SUBST([GASGANO_SHREXT])

])
