/* $Id: cpl_type.h,v 1.17 2010/11/11 09:23:18 llundin Exp $
 *
 * This file is part of the ESO Common Pipeline Library
 * Copyright (C) 2001-2005 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: llundin $
 * $Date: 2010/11/11 09:23:18 $
 * $Revision: 1.17 $
 * $Name: cpl-5_3_0-BRANCH $
 */

#ifndef CPL_TYPE_H
#define CPL_TYPE_H

#include <cpl_macros.h>


CPL_BEGIN_DECLS

/**
 * @ingroup cpl_type
 *
 * @brief
 *   The CPL type codes and flags.
 */

enum _cpl_type_ {

    /* flags */

    /**
     * Flag indicating whether a type is an array or a basic type.
     * @hideinitializer
     */
    CPL_TYPE_FLAG_ARRAY   = 1 << 0,

    /* Padded for future extensions */

    /* types */

    /**
     * Invalid or undetermined type.
     * @hideinitializer
     */
    CPL_TYPE_INVALID = 1 << 4,

    /**
     * Type code corresponding to type @c char.
     * @hideinitializer
     */
    CPL_TYPE_CHAR    = 1 << 5,

    /**
     * Type code corresponding to type @c unsigned char.
     * @hideinitializer
     */
    CPL_TYPE_UCHAR   = 1 << 6,

    /**
     * Type code corresponding to the boolean type.
     * @hideinitializer
     */
    CPL_TYPE_BOOL    = 1 << 7,

    /**
     * Type code corresponding to type @c int.
     * @hideinitializer
     */
    CPL_TYPE_INT     = 1 << 8,

    /**
     * Type code corresponding to type @c unsigned int.
     * @hideinitializer
     */
    CPL_TYPE_UINT    = 1 << 9,

    /**
     * Type code corresponding to type @c long.
     * @hideinitializer
     */
    CPL_TYPE_LONG    = 1 << 10,

    /**
     * Type code corresponding to type @c unsigned long.
     * @hideinitializer
     */
    CPL_TYPE_ULONG   = 1 << 11,

    /**
     * Type code corresponding to type @c float.
     * @hideinitializer
     */
    CPL_TYPE_FLOAT   = 1 << 12,

    /**
     * Type code corresponding to type @c double.
     * @hideinitializer
     */
    CPL_TYPE_DOUBLE  = 1 << 13,

    /**
     * Type code corresponding to a pointer type.
     * @hideinitializer
     */
    CPL_TYPE_POINTER = 1 << 14,

    /**
     * Type code corresponding to type @c float complex.
     * @hideinitializer
     */
    CPL_TYPE_COMPLEX = 1 << 15,

    /**
     * Type code to be used for inheritance of original FITS type.
     * @hideinitializer
     */
    CPL_TYPE_UNSPECIFIED = 1 << 16,

    /**
     * Type code corresponding to a character array.
     * @hideinitializer
     */
    CPL_TYPE_STRING  = (CPL_TYPE_CHAR | CPL_TYPE_FLAG_ARRAY),

    /**
     * Type code corresponding to type @c float complex.
     * @hideinitializer
     */
    CPL_TYPE_FLOAT_COMPLEX = (CPL_TYPE_FLOAT | CPL_TYPE_COMPLEX),

    /**
     * Type code corresponding to type @c double complex.
     * @hideinitializer
     */
    CPL_TYPE_DOUBLE_COMPLEX = (CPL_TYPE_DOUBLE | CPL_TYPE_COMPLEX)
};


/**
 * @ingroup cpl_type
 *
 * @brief
 *   The type code type.
 */

typedef enum _cpl_type_ cpl_type;


enum _cpl_boolean_ {
    CPL_FALSE = 0,
    CPL_TRUE = !CPL_FALSE
};

typedef enum _cpl_boolean_ cpl_boolean;


size_t cpl_type_get_sizeof(cpl_type type) CPL_ATTR_CONST;

const char * cpl_type_get_name(cpl_type type);

CPL_END_DECLS

#endif /* CPL_TYPE_H */
