/* $Id: cxdeque.h,v 1.2 2007/07/04 12:14:04 scastro Exp $
 *
 * This file is part of the ESO C Extension Library
 * Copyright (C) 2001-2006 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: scastro $
 * $Date: 2007/07/04 12:14:04 $
 * $Revision: 1.2 $
 * $Name: cpl-5_3_0-BRANCH $
 */

#ifndef CX_DEQUE_H
#define CX_DEQUE_H

#include <cxmemory.h>

CX_BEGIN_DECLS

typedef struct _cx_deque_ cx_deque;

typedef unsigned long cx_deque_const_iterator;
typedef unsigned long cx_deque_iterator;
typedef cxint (*cx_deque_compare) (cxcptr a, cxcptr b);


cx_deque *cx_deque_new(void);
void cx_deque_destroy(cx_deque *d, cx_free_func deallocate);

cxsize cx_deque_size(const cx_deque *d);
cxbool cx_deque_empty(const cx_deque *d);

cxptr cx_deque_get(const cx_deque *d, cx_deque_const_iterator indx);

cx_deque_iterator cx_deque_begin(const cx_deque *d);
cx_deque_iterator cx_deque_end(const cx_deque *d);
cx_deque_iterator cx_deque_next(const cx_deque *d, cx_deque_const_iterator i);


void cx_deque_push_back(cx_deque *d, cxptr what);
void cx_deque_push_front(cx_deque *d, cxptr what);
cx_deque_iterator cx_deque_erase(cx_deque *d, cx_deque_iterator indx, cx_free_func deallocate);
void cx_deque_insert(cx_deque *d, cx_deque_iterator indx, cxptr what);

void cx_deque_sort(cx_deque *d, cx_deque_compare compare);

CX_END_DECLS

#endif /* CX_DEQUE_H */

