/*
 * craftedrc.c
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <sys/types.h>
#include <regex.h>
#include <gtk/gtk.h>

gchar *data_path = NULL;

/*************************************************************************
*  find_matches
**************************************************************************/
gboolean find_matches(char *string, char *regex, char **results)
{
  int error_code;
  regex_t reg;
  regmatch_t pmatch[10];
  int i;

  error_code = regcomp(&reg, regex, REG_EXTENDED);
  if (error_code)
  {
    results[0] = "Error in Regcomp";
    return FALSE;
  }
  error_code = regexec(&reg, string, 10, pmatch, 0);
  switch (error_code)
  {
    case 0:
      break;

    case REG_NOMATCH:
      results[0] = "No match found";
      regfree(&reg);
      return FALSE;

    default:
      results[0] = "Internal error";
      regfree(&reg);
      return FALSE;
  }
  for (i=1 ; pmatch[i].rm_so != -1 ; i++)
  {
    results[i] = g_malloc(pmatch[i].rm_eo-pmatch[i].rm_so+1);
    memcpy(results[i], string+pmatch[i].rm_so, pmatch[i].rm_eo-pmatch[i].rm_so);
    results[i][pmatch[i].rm_eo-pmatch[i].rm_so] = 0;
  }
  results[i] = NULL;
  regfree(&reg);
  return TRUE;
}

/*************************************************************************
*  parse_rc
**************************************************************************/
void parse_rc(void)
{
  gchar *filename; 
  FILE  *fd;
  char  *read, buf[1024];
  
  filename = g_strdup_printf("%s/.craftedrc", g_get_home_dir());
  fd = fopen(filename, "r");
  g_free(filename);

  if (fd)
  {
    while (!feof(fd))
    {
      read = fgets(buf, 1000, fd);
      if (read)
      {
        char *res[12];

        g_strstrip(read);
        if (*read == '#') /* ignore lines beginning with a hash */
          continue;
        if (find_matches(read, "data_path[ \t]*=[ \t]*(/.*)", res))
        {
          if (data_path) g_free(data_path);
          data_path = res[1];
        }
      }
    }
    fclose(fd);
  }
}
