/* ui_misc.c - Various UI routines
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include "crank.h"

extern char *text;
extern GtkWidget *sourcearea;

/* Let the user interface perform any needed updates */
void yield_to_ui(void) {
    while (gtk_events_pending())
	gtk_main_iteration();
}

/* Refresh source textarea */
void display_source_text(void) {
    gtk_text_set_point(GTK_TEXT(sourcearea), 0);
    gtk_text_forward_delete(GTK_TEXT(sourcearea), gtk_text_get_length(GTK_TEXT(sourcearea)));
    gtk_text_insert(GTK_TEXT(sourcearea), NULL, NULL, NULL, text, strlen(text));
}
