/* xpms.h - xpm image data
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000, 2001 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#ifndef H_XPMS
#define H_XPMS


static char * open_xpm[] = {
    "24 24 5 1",
    "       c None",
    ".      c #000000",
    "+      c #99907B",
    "@      c #FFFEF7",
    "#      c #FFFFFF",
    "                        ",
    "                        ",
    "                        ",
    "                        ",
    "                        ",
    "              ..        ",
    "           ...++.       ",
    "    ..  ...++++@@#...   ",
    "   .++..++++@@@@..++.   ",
    "   .+++++@@@@@..++++.   ",
    "    .++@@@@@..++++++.   ",
    "    .++@@@..++++++++.   ",
    "     .+@@.++++++++++.   ",
    "     .++@.++++++++++.   ",
    "      .+@.++++++++++.   ",
    "      .++.++++++++..    ",
    "       .+.++++++..      ",
    "       .+.+++++.        ",
    "        ..+++..         ",
    "        ..+..           ",
    "         ..             ",
    "                        ",
    "                        ",
    "                        "};

static char * save_xpm[] = {
    "24 24 64 1",
    "       c None",
    ".      c #000000",
    "+      c #779FA8",
    "@      c #495A5E",
    "#      c #BFD1D5",
    "$      c #A8C1C5",
    "%      c #E4ECED",
    "&      c #FFFFFF",
    "*      c #EEF3F4",
    "=      c #E0E9EB",
    "-      c #87AAB2",
    ";      c #AEC4C9",
    ">      c #F5F8F9",
    ",      c #8BADB5",
    "'      c #3E4D50",
    ")      c #94B2B9",
    "!      c #CFDCDF",
    "~      c #E4ECEE",
    "{      c #788A8D",
    "]      c #EBF1F2",
    "^      c #E8EFF0",
    "/      c #F2F6F7",
    "(      c #607A7F",
    "_      c #F0F4F5",
    ":      c #536E75",
    "<      c #A0BCC1",
    "[      c #465E63",
    "}      c #4B575A",
    "|      c #557278",
    "1      c #A4ABAD",
    "2      c #EAEAEA",
    "3      c #E4E4E4",
    "4      c #606364",
    "5      c #C6CACC",
    "6      c #F3F3F3",
    "7      c #F1F1F1",
    "8      c #E7E7E7",
    "9      c #E1E1E1",
    "0      c #A9B2B4",
    "a      c #486166",
    "b      c #34464A",
    "c      c #729096",
    "d      c #BCC2C3",
    "e      c #F6F6F6",
    "f      c #57696D",
    "g      c #CFD8DA",
    "h      c #DEDEDE",
    "i      c #D8D8D8",
    "j      c #8C9394",
    "k      c #F2F2F2",
    "l      c #3A474A",
    "m      c #7EA4AC",
    "n      c #D5DADA",
    "o      c #E0E0E0",
    "p      c #B4B4B4",
    "q      c #657376",
    "r      c #D0D5D6",
    "s      c #E9E9E9",
    "t      c #A7B0B2",
    "u      c #D2D4D5",
    "v      c #899293",
    "w      c #484848",
    "x      c #DDDDDD",
    "y      c #8F9A9B",
    "                        ",
    "                        ",
    "                        ",
    "              ..        ",
    "            ..+@.       ",
    "          ..#$%+.       ",
    "        ..#$#&*+@.      ",
    "      ..#$#&&&&=+.      ",
    "    ..-;#&&&&&&>,'.     ",
    "   .);!&&&&&&&&&~+.     ",
    "   .{)]&&&&&&&&&^+@.    ",
    "    .$=&&&&&&&/=+++.    ",
    "    .(-]&&&&_=++::+@.   ",
    "     .<=&&_=++[}|+:+.   ",
    "     .(-^=++[1234+:+@.  ",
    "      .)++:567890a+[b.  ",
    "      .c-+defg3hij+'..  ",
    "       .)+:klmnopq..    ",
    "       .|++rstuvw.      ",
    "        .a+:xy..        ",
    "         .....          ",
    "                        ",
    "                        ",
    "                        "};

#ifdef NOT_USED
static char *text_xpm[] = {
    /* columns rows colors chars-per-pixel */
    "21 21 5 1",
    "  c Gray0",
    ". c #7b7b7b",
    "X c #d6d6d6",
    "o c Gray87",
    "O c Gray100",
    /* pixels */
    "....................O",
    ".                  XO",
    ". OOOOOOOOOOOOOOOOOXO",
    ". OOOOOOO OOOOOOOOOXO",
    ". OOOOOOO OOOOOOOOOXO",
    ". OO   OO o  OOo  OXO",
    ". O.OOO O  Oo O Oo XO",
    ". OO    O OOO O OOOXO",
    ". O OOO O OOO O OOOXO",
    ". O OOO O OOo O Oo XO",
    ". OO    O    OOo  OXO",
    ". OOOOOOOOOOOOOOOOOXO",
    ". OOOOO OOOOOOOOO  XO",
    ". OOOOO OO   OOO oOXO",
    ". OO    O oOo OO OOXO",
    ". O oOo O oOO O   OXO",
    ". O OOO O    OOO OOXO",
    ". O oOo O OOO.OO OOXO",
    ". OO    OO   OOO OOXO",
    ".XXXXXXXXXXXXXXXXXXXO",
    "OOOOOOOOOOOOOOOOOOOOO"
};
#endif
static char * new_xpm[] = {
    "24 24 89 1",
    "       c None",
    ".      c #000000",
    "+      c #ADAD9C",
    "@      c #959585",
    "#      c #DCDCC5",
    "$      c #DFDFC8",
    "%      c #242424",
    "&      c #A7A796",
    "*      c #D7D7C1",
    "=      c #D9D9C3",
    "-      c #DCDCC4",
    ";      c #DDDDC7",
    ">      c #E1E1CA",
    ",      c #A6A694",
    "'      c #D6D6BF",
    ")      c #D8D8C2",
    "!      c #DBDBC4",
    "~      c #DFDFC7",
    "{      c #E3E3CB",
    "]      c #B2B29F",
    "^      c #7C7C7C",
    "/      c #646464",
    "(      c #D5D5BD",
    "_      c #D5D5BF",
    ":      c #D7D7C0",
    "<      c #DADAC3",
    "[      c #DEDEC6",
    "}      c #E1E1C9",
    "|      c #E5E5CD",
    "1      c #E9E9D1",
    "2      c #343434",
    "3      c #E7E7E7",
    "4      c #373736",
    "5      c #B8B8A6",
    "6      c #D3D3BC",
    "7      c #D9D9C2",
    "8      c #DDDDC5",
    "9      c #E0E0C8",
    "0      c #E8E8D0",
    "a      c #ECECD4",
    "b      c #EEEED5",
    "c      c #ECECEC",
    "d      c #EDEDED",
    "e      c #3D3D37",
    "f      c #CECEB7",
    "g      c #E6E6CE",
    "h      c #EAEAD2",
    "i      c #F1F1D8",
    "j      c #A5A594",
    "k      c #EEEEE5",
    "l      c #3C3C3C",
    "m      c #8F8F80",
    "n      c #D0D0B9",
    "o      c #E4E4CB",
    "p      c #EAEAD1",
    "q      c #ECECD3",
    "r      c #EFEFD6",
    "s      c #F2F2D9",
    "t      c #F3F3DA",
    "u      c #EEEEE6",
    "v      c #505050",
    "w      c #929282",
    "x      c #D1D1B9",
    "y      c #E7E7CF",
    "z      c #EBEBD2",
    "A      c #F4F4DB",
    "B      c #F5F5DC",
    "C      c #969686",
    "D      c #D2D2BC",
    "E      c #E0E0C9",
    "F      c #E9E9D0",
    "G      c #EDEDD4",
    "H      c #F0F0D7",
    "I      c #BEBEAB",
    "J      c #797973",
    "K      c #D8D8C1",
    "L      c #DDDDC6",
    "M      c #98988F",
    "N      c #E4E4CC",
    "O      c #818174",
    "P      c #E2E2CA",
    "Q      c #BEBEAE",
    "R      c #4E4E4E",
    "S      c #828274",
    "T      c #EBEBD3",
    "U      c #BBBBA8",
    "V      c #CDCDB8",
    "W      c #4D4D45",
    "X      c #A6A696",
    "                        ",
    "                        ",
    "             .          ",
    "           ..+.         ",
    "         ..@#$%         ",
    "       ..&*=-;>.        ",
    "     ..,'**)!~{].       ",
    "    .^/'(_:<[}|12       ",
    "    .3456*789|0ab.      ",
    "    .cdef_!9g0hbij.     ",
    "    .kklmn9opqrist.     ",
    "    .uvwx-}yzbittAB.    ",
    "    ..CD!E{FGHtAABBI.   ",
    "    .JK7L>ypbitBBBBB).  ",
    "    .M!#$NyzbitBBBBBO.  ",
    "     .~9P|1qrsABBBB..   ",
    "     .Q||0hGHtABB<.     ",
    "      R01hGrstAsS.      ",
    "      .TaGriss<.        ",
    "       .rHis1j.         ",
    "       .UstVW.          ",
    "        .tX.            ",
    "         ..             ",
    "                        "};
#ifdef NOT_USED
static char *source_xpm[] = {
    "24 24 80 1",
    "       c None",
    ".      c #000000",
    "+      c #B2A97E",
    "@      c #B6AD81",
    "#      c #7A7356",
    "$      c #B0A77C",
    "%      c #B5AC80",
    "&      c #BAB184",
    "*      c #BBB284",
    "=      c #B6AD80",
    "-      c #ADA57B",
    ";      c #B7AE81",
    ">      c #BDB486",
    ",      c #837C5C",
    "'      c #B4AC80",
    ")      c #7C7557",
    "!      c #C0B687",
    "~      c #BEB586",
    "{      c #B1A87D",
    "]      c #B9B082",
    "^      c #C0B788",
    "/      c #AFA67B",
    "(      c #AFA77C",
    "_      c #BAB183",
    ":      c #BBB285",
    "<      c #BCB385",
    "[      c #C4BB8B",
    "}      c #C6BC8C",
    "|      c #C7BD8D",
    "1      c #C7BE8D",
    "2      c #C8BF8E",
    "3      c #C8BE8D",
    "4      c #C5BC8B",
    "5      c #C1B788",
    "6      c #B9B083",
    "7      c #CDC391",
    "8      c #D0C693",
    "9      c #D1C794",
    "0      c #D3C995",
    "a      c #CDC491",
    "b      c #C2B889",
    "c      c #CAC18F",
    "d      c #D5CB97",
    "e      c #D6CC97",
    "f      c #D6CC98",
    "g      c #D7CD98",
    "h      c #CEC491",
    "i      c #C2B98A",
    "j      c #CBC18F",
    "k      c #C1B889",
    "l      c #8A8261",
    "m      c #D4CA96",
    "n      c #C0B787",
    "o      c #80785A",
    "p      c #B9B183",
    "q      c #827C5B",
    "r      c #CFC592",
    "s      c #C7BD8C",
    "t      c #C3BA8A",
    "u      c #CAC08F",
    "v      c #D0C793",
    "w      c #7C7657",
    "x      c #D2C894",
    "y      c #D2C995",
    "z      c #CCC290",
    "A      c #C4BA8A",
    "B      c #D1C793",
    "C      c #CEC592",
    "D      c #C5BC8C",
    "E      c #CFC693",
    "F      c #C1B888",
    "G      c #BEB486",
    "H      c #C8BF8D",
    "I      c #C9C08F",
    "J      c #C9BF8E",
    "K      c #C5BB8B",
    "L      c #B2A97D",
    "M      c #C2B989",
    "N      c #BFB687",
    "O      c #B3AA7E",
    "                        ",
    "                        ",
    "                        ",
    "      ....              ",
    "     .+.@#.             ",
    "    .$%&*=-.            ",
    "    ..;>,$..            ",
    "    .-')!~@.  ...       ",
    "    ..{]~^.. ./({. .    ",
    "     .#._#._..&:<..@.   ",
    "      . ..>[}|1232456.  ",
    "          .2789009a2.   ",
    "         .bc9defge0h..  ",
    "        .]ij9ekl1gm83n. ",
    "        .*ic9dopqgmrs~. ",
    "        .<tu8mvwuxyzA*. ",
    "         ..3ax0rBxC3..  ",
    "          .DuhE8rz3F.   ",
    "         .Gt}HIJ1K^*L.  ",
    "          .~..MbN..O.   ",
    "           . .*_;. .    ",
    "              ...       ",
    "                        ",
    "                        "};

static char *vpaned_xpm[] = {
    /* columns rows colors chars-per-pixel */
    "21 21 4 1",
    "  c Gray0",
    ". c #7b7b7b",
    "X c #d6d6d6",
    "o c Gray100",
    /* pixels */
    "oooooooooooooooooooo ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXX.....XX. ",
    "oXXXXXXXXXXX.ooo..X. ",
    "o............ooo.... ",
    "            .ooo..   ",
    "oooooooooooo......oo ",
    "oXXXXXXXXXXXX.....X. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "oXXXXXXXXXXXXXXXXXX. ",
    "o................... ",
    "                     "
};
#endif
  /* XPM */
static char * arrows_ver_xpm[] = {
    "24 24 3 1",
    "       c None",
    ".      c #000000",
    "+      c #F8E008",
    "                        ",
    "                        ",
    "                        ",
    "                        ",
    "            .           ",
    "           .+.          ",
    "          .+++.         ",
    "         .+++++.        ",
    "        ....+....       ",
    "           .+.          ",
    "           .+.          ",
    "           .+.          ",
    "           .+.          ",
    "           .+.          ",
    "           .+.          ",
    "        ....+....       ",
    "         .+++++.        ",
    "          .+++.         ",
    "           .+.          ",
    "            .           ",
    "                        ",
    "                        ",
    "                        ",
    "                        "};


#endif

