/*
 *  File:       FixAry.h
 *  Summary:    Fixed size 2D vector class that asserts if you do something bad.
 *  Written by: Jesse Jones
 *
 *  Modified for Crawl Reference by $Author: dshaligram $ on $Date: 2006-12-07T07:51:48.088735Z $
 *
 *  Change History (most recent first):    
 *
 *         <1>     6/16/00    JDJ        Created 
 */

#ifndef FIXARY_H
#define FIXARY_H

#include "FixVec.h"


// ==========================================================================
//    class FixedArray
// ==========================================================================
template <class TYPE, int WIDTH, int HEIGHT> class FixedArray {

//-----------------------------------
//    Types
//
public:
    typedef TYPE            value_type;
    typedef TYPE&           reference;
    typedef const TYPE&     const_reference;
    typedef TYPE*           pointer;
    typedef const TYPE*     const_pointer;

    typedef unsigned long   size_type;
    typedef long            difference_type;

    typedef FixedVector<TYPE, HEIGHT> Column;  // operator[] needs to return one of these to avoid breaking client code (if inlining is on there won't be a speed hit)
    
//-----------------------------------
//    Initialization/Destruction
//
public:
                        ~FixedArray()                           {}
                            
                        FixedArray()                            {}

//-----------------------------------
//    API
//
public:
    // ----- Size -----
            bool        empty() const                              {return WIDTH == 0 || HEIGHT == 0;}
            int         size() const                               {return WIDTH*HEIGHT;}

            int         width() const                              {return WIDTH;}
            int         height() const                             {return HEIGHT;}
                        
    // ----- Access -----
            Column&       operator[](unsigned long index)          {return mData[index];}    
            const Column& operator[](unsigned long index) const    {return mData[index];}
            template<class Indexer> TYPE& operator () (const Indexer &i)
            {
                return mData[i.x][i.y];
            }

            template<class Indexer> const TYPE& operator () (const Indexer &i)
                const
            {
                return mData[i.x][i.y];
            }            
            
//-----------------------------------
//    Member Data
//
protected:
    FixedVector<Column, WIDTH>    mData;
};


#endif    // FIXARY_H
