"=====================================================================
" cream-menu-settings.vim
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2002-2004  Steve Hall
"
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
"
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
"
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.

function! Cream_menu_settings()
" functionalized so we can toggle texts based on state

	" remove menu and restore
	silent! unmenu &Settings
	silent! unmenu! &Settings


	" invisibles
		imenu <silent> 60.101 &Settings.&Show/Hide\ Invisibles<Tab>F4   <C-o>:call Cream_list_toggle("i")<CR>
		vmenu <silent> 60.102 &Settings.&Show/Hide\ Invisibles<Tab>F4   :<C-u>call Cream_list_toggle("v")<CR>
	anoremenu <silent> 60.103 &Settings.Line\ &Numbers\ (toggle)			:call Cream_linenumbers_toggle()<CR>

	" wrap
	anoremenu <silent> 60.104 &Settings.-SEP104-							<Nul>
	anoremenu <silent> 60.105 &Settings.&Word\ Wrap\ (toggle)<Tab>Ctrl+W	:call Cream_wrap("i")<CR>
	anoremenu <silent> 60.106 &Settings.A&uto\ Wrap\ (toggle)<Tab>Ctrl+E	:call Cream_autowrap("i")<CR>
	anoremenu <silent> 60.107 &Settings.&Set\ Wrap\ Width\.\.\.				:call Cream_autowrap_setwidth()<CR>
		imenu <silent> 60.108 &Settings.&Highlight\ Wrap\ Width\ (toggle)	<C-o>:call Cream_highlight_columns(g:CREAM_AUTOWRAP_WIDTH)<CR>
		vmenu <silent> 60.109 &Settings.&Highlight\ Wrap\ Width\ (toggle)	:<C-u>call Cream_highlight_columns(g:CREAM_AUTOWRAP_WIDTH)<CR>

	" tabs
	anoremenu <silent> 60.111 &Settings.-SEP111-							<Nul>
	anoremenu <silent> 60.112 &Settings.&Tabstop\ Width\.\.\.				:call Cream_tabstop()<CR>
	anoremenu <silent> 60.113 &Settings.Soft\ Ta&bstop\ Width\.\.\.			:call Cream_softtabstop()<CR>
		imenu <silent> 60.114 &Settings.Tab\ &Expansion\ (toggle)<Tab>Ctrl+T	<C-o>:call Cream_expandtab_toggle("i")<CR>
		vmenu <silent> 60.115 &Settings.Tab\ &Expansion\ (toggle)<Tab>Ctrl+T	:<C-u>call Cream_expandtab_toggle("v")<CR>
	anoremenu <silent> 60.116 &Settings.&Auto-indent\ (toggle)				:call Cream_autoindent_toggle()<CR>

	" syntax/highlighting
	anoremenu <silent> 60.121 &Settings.-SEP116-							<Nul>
		imenu <silent> 60.122 &Settings.Syntax\ Highlighting\ (toggle)		<C-o>:call Cream_syntax_toggle("i")<CR>
		vmenu <silent> 60.123 &Settings.Syntax\ Highlighting\ (toggle)		:<C-u>call Cream_syntax_toggle("v")<CR>
	anoremenu <silent> 60.124 &Settings.Highlight\ Find\ (toggle)			:call Cream_search_highlight_toggle()<CR>
	anoremenu <silent> 60.125 &Settings.Highlight\ Current\ Line\ (toggle)	:call Cream_highlight_currentline_toggle()<CR>


	"......................................................................
	" Filetypes

	function! Cream_menu_settings_filetypes()
	" *** called via VimEnter command on startup, so filetypes_list() is available ***
	" "menu-izes" the aviable filetypes

		let idx = 200
		execute "anoremenu \<silent> 60." . idx . " &Settings.-SEP200-  \<Nul>"
		let idx = idx + 1

		let myfiletypes = Cream_vim_syntax_list() . "\n"
		"let myfiletypes = Cream_get_filetypes() . "\n"
		" use destructive process, multvals too slow
		let i = 0	" itteration index
		while myfiletypes != ""
			let pos = stridx(myfiletypes, "\n")
			let myitem = strpart(myfiletypes, 0, pos)
			let myfiletypes = strpart(myfiletypes, pos + 1)
			let char1 = myitem[0]

			if     char1 =~? "[0-9]"
				let letters = "[0-9]"
			elseif char1 =~? "a"
				let letters = "[ABCDE].[A]"
			elseif char1 =~? "b"
				let letters = "[ABCDE].[B]"
			elseif char1 =~? "c"
				let char2 = myitem[1]
				if char2 =~? "[0-9a-m]"
					let letters = "[ABCDE].[C].[CA-CM]"
				else
					let letters = "[ABCDE].[C].[CN-CZ]"
				endif
			elseif char1 =~? "d"
				let letters = "[ABCDE].[D]"
			elseif char1 =~? "e"
				let letters = "[ABCDE].[E]"
			elseif char1 =~? "f"
				let letters = "[FGH].[F]"
			elseif char1 =~? "g"
				let letters = "[FGH].[G]"
			elseif char1 =~? "h"
				let letters = "[FGH].[H]"
			elseif char1 =~? "i"
				let letters = "[IJKL].[I]"
			elseif char1 =~? "j"
				let letters = "[IJKL].[J]"
			elseif char1 =~? "k"
				let letters = "[IJKL].[K]"
			elseif char1 =~? "l"
				let letters = "[IJKL].[L]"
			elseif char1 =~? "m"
				let char2 = myitem[1]
				if char2 =~? "[0-9a-m]"
					let letters = "[MNOP].[M].[MA-MM]"
				else
					let letters = "[MNOP].[M].[MN-MZ]"
				endif
			elseif char1 =~? "n"
				let letters = "[MNOP].[N]"
			elseif char1 =~? "o"
				let letters = "[MNOP].[O]"
			elseif char1 =~? "p"
				let char2 = myitem[1]
				if char2 =~? "[0-9a-m]"
					let letters = "[MNOP].[P].[PA-PM]"
				else
					let letters = "[MNOP].[P].[PN-PZ]"
				endif
			elseif char1 =~? "q"
				let letters = "[QRST].[Q]"
			elseif char1 =~? "r"
				let letters = "[QRST].[R]"
			elseif char1 =~? "s"
				let char2 = myitem[1]
				if     char2 =~? "[0-9a-k]"
					let letters = "[QRST].[S].[SA-SK]"
				elseif char2 =~? "[l-n]"
					let letters = "[QRST].[S].[SL-SN]"
				else
					let letters = "[QRST].[S].[SO-SZ]"
				endif
			elseif char1 =~? "t"
				let letters = "[QRST].[T]"
			elseif char1 =~? "[u-w]"
				let letters = "[UVW]"
			elseif char1 =~? "[x-z]"
				let letters = "[XYZ]"
			else
				"" error
				"call confirm(
				"        \ "Error: no char found in Cream_menu_settings_filetypes(). Quitting.\n" .
				"        \ "\n", "&Ok", 1, "Info")
				return
			endif

			let command = "anoremenu \<silent> 60." . (i + idx) . " &Settings.&Filetype." . letters . "." . myitem . "  :call Cream_filetype(\"" . myitem . "\")\<CR>"

			execute command

			let i = i + 1
		endwhile

	endfunction


	"......................................................................
	" Color

	if has("gui")

		" color themes, selection
		anoremenu <silent> 60.700 &Settings.-SEP700-								<Nul>
		anoremenu <silent> 60.701 &Settings.&Color\ Themes.Selection.Reverse\ Black\ (default)	:call Cream_colors_selection("reverseblack")<CR>
		anoremenu <silent> 60.702 &Settings.&Color\ Themes.Selection.Reverse\ Blue	:call Cream_colors_selection("reverseblue")<CR>
		anoremenu <silent> 60.703 &Settings.&Color\ Themes.Selection.Terminal		:call Cream_colors_selection("terminal")<CR>
		anoremenu <silent> 60.704 &Settings.&Color\ Themes.Selection.Navajo			:call Cream_colors_selection("navajo")<CR>
		anoremenu <silent> 60.705 &Settings.&Color\ Themes.Selection.Navajo-Night	:call Cream_colors_selection("navajo-night")<CR>
		anoremenu <silent> 60.706 &Settings.&Color\ Themes.Selection.Night			:call Cream_colors_selection("night")<CR>
		anoremenu <silent> 60.707 &Settings.&Color\ Themes.Selection.Vim			:call Cream_colors_selection("vim")<CR>
		anoremenu <silent> 60.708 &Settings.&Color\ Themes.Selection.Magenta		:call Cream_colors_selection("magenta")<CR>

		if exists("g:cream_dev")
			" experimental
			anoremenu <silent> 60.710 &Settings.&Color\ Themes.Selection.-Sep710-		<Nul>
			anoremenu <silent> 60.711 &Settings.&Color\ Themes.Selection.(experimental\ below)	<Nul>
			anoremenu <silent> 60.712 &Settings.&Color\ Themes.Selection.-Sep712-		<Nul>
			anoremenu <silent> 60.713 &Settings.&Color\ Themes.Selection.Lt\.\ Magenta	:call Cream_colors_selection("ltmagenta")<CR>
			anoremenu <silent> 60.714 &Settings.&Color\ Themes.Selection.Dk\.\ Magenta	:call Cream_colors_selection("dkmagenta")<CR>
			anoremenu <silent> 60.715 &Settings.&Color\ Themes.Selection.Magenta		:call Cream_colors_selection("magenta")<CR>
			anoremenu <silent> 60.716 &Settings.&Color\ Themes.Selection.Blue			:call Cream_colors_selection("blue")<CR>
			anoremenu <silent> 60.717 &Settings.&Color\ Themes.Selection.Orange			:call Cream_colors_selection("orange")<CR>
			anoremenu <silent> 60.718 &Settings.&Color\ Themes.Selection.Green			:call Cream_colors_selection("green")<CR>
			anoremenu <silent> 60.719 &Settings.&Color\ Themes.Selection.Gold			:call Cream_colors_selection("gold")<CR>
			anoremenu <silent> 60.720 &Settings.&Color\ Themes.Selection.Purple			:call Cream_colors_selection("purple")<CR>
			anoremenu <silent> 60.721 &Settings.&Color\ Themes.Selection.Wheat			:call Cream_colors_selection("wheat")<CR>
		endif

		" color schemes (Cream)
		anoremenu <silent> 60.740 &Settings.&Color\ Themes.-SEP740-				<Nul>
		anoremenu <silent> 60.741 &Settings.&Color\ Themes.Cream\ (default)		:call Cream_colors("cream")<CR>
		anoremenu <silent> 60.742 &Settings.&Color\ Themes.Black\ and\ White	:call Cream_colors("blackwhite")<CR>
		anoremenu <silent> 60.743 &Settings.&Color\ Themes.Chocolate\ Liquor	:call Cream_colors("chocolateliquor")<CR>
		anoremenu <silent> 60.744 &Settings.&Color\ Themes.Dawn					:call Cream_colors("dawn")<CR>
		anoremenu <silent> 60.745 &Settings.&Color\ Themes.Navajo				:call Cream_colors("navajo")<CR>
		anoremenu <silent> 60.746 &Settings.&Color\ Themes.Navajo-Night			:call Cream_colors("navajo-night")<CR>
		anoremenu <silent> 60.747 &Settings.&Color\ Themes.Night				:call Cream_colors("night")<CR>
		anoremenu <silent> 60.748 &Settings.&Color\ Themes.Ocean\ Deep			:call Cream_colors("oceandeep")<CR>
		anoremenu <silent> 60.749 &Settings.&Color\ Themes.Terminal\ (reverse)	:call Cream_colors("terminal")<CR>
		anoremenu <silent> 60.750 &Settings.&Color\ Themes.Zenburn				:call Cream_colors("zenburn")<CR>

		function! Cream_menu_colors()
		" color schemes (Vim's only! Ours are specifically "menu-ized" ;)
		" * This function is called via VimEnter autocmd so multvals is available.

			" this should be dev-only!
			if !exists("g:cream_dev")
				return
			else
				anoremenu <silent> 60.759 &Settings.&Color\ Themes.-SEP759-				<Nul>
				anoremenu <silent> 60.760 &Settings.&Color\ Themes.gVim\ themes\ (non-Cream):	<Nul>
			endif

			let mycolors = globpath(&runtimepath, "colors/*.vim")
			if strlen(mycolors) > 0
				let mycolors = mycolors . "\n"
			endif

			" menu each item
			let idx = 800
			let i = 0
			while i < MvNumberOfElements(mycolors, "\n")

				let mycolor = MvElementAt(mycolors, "\n", i)

				" name doesn't have path
				let mycolor = substitute(mycolor, '.*[/\\:]\([^/\\:]*\)\.vim', '\1', '')
				execute "anoremenu <silent> 60." . idx . ' &Settings.&Color\ Themes.\ \ ' . mycolor . " :colors " . mycolor . "\<CR>"

				let i = i + 1
			endwhile

		endfunction
        "" load on re-sets, not startup (multvals isn't avialable)
        "call Cream_menu_colors()

	endif

	" Syntax highlighting (removed)
	" * By default, add's a root "Syntax" menu when turned to manual.
	" * On/Off control is disabled because of the dependence other
	"   features have on it. (See the ToDo doc.)
	" * Should JustWork(tm). Why do we need control options?


	"----------------------------------------------------------------------
	" Preferences
	anoremenu <silent> 60.9000 &Settings.-Sep9000-		<Nul>

	if has("gui")
	anoremenu <silent> 60.9001 &Settings.P&references.Font\.\.\.	    			:call Cream_font_set()<CR>
	endif
	anoremenu <silent> 60.9002 &Settings.P&references.Toolbar\ (toggle)				:call Cream_toolbar()<CR>


	anoremenu <silent> 60.9010 &Settings.P&references.-Sep9010-		<Nul>
	if !exists("g:CREAM_LAST_BUFFER_FORGET") || g:CREAM_LAST_BUFFER_FORGET == 0
		anoremenu <silent> 60.9011 &Settings.P&references.Last\ File\ Restore\ Off	:call Cream_last_buffer_toggle()<CR>
	else
		anoremenu <silent> 60.9011 &Settings.P&references.Last\ File\ Restore\ On	:call Cream_last_buffer_toggle()<CR>
	endif
	if exists("g:CREAM_SINGLESERVER") && g:CREAM_SINGLESERVER == 1
		anoremenu <silent> 60.9012 &Settings.P&references.&Single-Session\ Mode\ Off	:call Cream_singleserver_toggle()<CR>
	else
		anoremenu <silent> 60.9012 &Settings.P&references.&Single-Session\ Mode\ On		:call Cream_singleserver_toggle()<CR>
	endif

	anoremenu <silent> 60.9020 &Settings.P&references.-Sep9020-		<Nul>
	if exists("g:CREAM_MOUSE_XSTYLE") && g:CREAM_MOUSE_XSTYLE == 1
		anoremenu <silent> 60.9021 &Settings.P&references.&Middle-Mouse\ Disabled	:call Cream_mouse_middle_toggle()<CR>
	else
		anoremenu <silent> 60.9021 &Settings.P&references.&Middle-Mouse\ Pastes  	:call Cream_mouse_middle_toggle()<CR>
	endif

	if exists("g:CREAM_BRACKETMATCH") && g:CREAM_BRACKETMATCH == 1
		anoremenu <silent> 60.9022 &Settings.P&references.Bracket\ Flashing\ Off	:call Cream_bracketmatch_toggle()<CR>
	else
		anoremenu <silent> 60.9022 &Settings.P&references.Bracket\ Flashing\ On		:call Cream_bracketmatch_toggle()<CR>
	endif
	anoremenu <silent> 60.9023 &Settings.P&references.Info\ Pop\ Options\.\.\.		:call Cream_pop_options()<CR>


	"......................................................................
	" Keymap

	if has("keymap")

		" get vim's list
		let maps = Cream_getfilelist($VIMRUNTIME . "/keymap/*.vim")
		if maps != ""
			anoremenu <silent> 60.9501 &Settings.P&references.-Sep910-	<Nul>

			" active indicator
			if has("win32")
			\ || &encoding == "latin1"
			\ || &encoding == "utf-8"
				let current = nr2char(187) . '\ '
			else
				let current = '>\ '
			endif

			" none
			if exists("g:CREAM_KEYMAP") && g:CREAM_KEYMAP == ""
				execute 'anoremenu <silent> 60.9502 &Settings.P&references.&Keymap.' . current . 'None :call Cream_keymap("")<CR>'
			else
				execute 'anoremenu <silent> 60.9502 &Settings.P&references.&Keymap.' . '\ \ \ ' . 'None :call Cream_keymap("")<CR>'
			endif
			" other
			let cnt = MvNumberOfElements(maps, "\n")
			let i = 0
			while i < cnt
				let mapp = MvElementAt(maps, "\n", i)
				let mapp = matchstr(mapp, 'keymap/\zs.*\ze\.vim')
				" cat string
				let idx = i
				while strlen(idx) < 2
					let idx = "0" . idx
				endwhile
				if exists("g:CREAM_KEYMAP") && g:CREAM_KEYMAP == mapp
					" if this map is active
					execute 'anoremenu <silent> 60.95' . idx . ' &Settings.P&references.&Keymap.' . current . mapp . ' :call Cream_keymap("' . mapp . '")<CR>'
				else
					" if this map isn't
					execute 'anoremenu <silent> 60.95' . idx . ' &Settings.P&references.&Keymap.' . '\ \ \ ' . mapp . ' :call Cream_keymap("' . mapp . '")<CR>'
				endif
				let i = i + 1
			endwhile

		endif

	endif

	"......................................................................

	anoremenu <silent> 60.9600 &Settings.P&references.-Sep920-	<Nul>

	" Expert mode
	anoremenu <silent> 60.9900 &Settings.P&references.&Expert\ Mode\.\.\.			:call Cream_expertmode_toggle()<CR>
	" Behavior
	anoremenu <silent> 60.9910 &Settings.P&references.&Behavior.&Cream\ (default)	:call Cream_behave_cream()<CR>
	anoremenu <silent> 60.9920 &Settings.P&references.&Behavior.&Cream\ Lite\.\.\.	:call Cream_behave_creamlite()<CR>
	anoremenu <silent> 60.9930 &Settings.P&references.&Behavior.&Vim\.\.\.			:call Cream_behave_vim()<CR>
	anoremenu <silent> 60.9940 &Settings.P&references.&Behavior.&Vi\.\.\.			:call Cream_behave_vi()<CR>


endfunction
call Cream_menu_settings()

