
/* PHP code {{{1
<?php

// PHP provides flexible variables when available. Default static
// values are provided immediately preceding if PHP is not available.

include("PHPClientSniffer.php");
$is = new sniffer;

// create style sheet with the correct font size
if ($is->NAME == "IE") {
	$font_size_large  = "small";
	$font_size_medium = "x-small";
	$font_size_small  = "xx-small";
	$font_size_xsmall = "xx-small";
	$font_size_xxsmall = "xx-small";
	$ul_padding_left = "0";
}
else {
	$font_size_large  = "large";
	$font_size_medium = "medium";
	$font_size_small  = "small";
	$font_size_xsmall = "x-small";
	$font_size_xxsmall = "xx-small";
	$ul_padding_left = "1em";
}

?>
*/

/* Common {{{1
*/

BODY {
	font-family: "Arial", "Helvetica", sans-serif;
	background-color: #eee;
	color: #fff;
	margin:		0;
	padding:    0;
	padding-top: 20px;
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
}

P,BR {
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
}

TD {
	vertical-align: top;
}

LI {
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
	margin-left: 0;
}

UL, OL {
	padding-left: 1em;
	<?php echo "padding-left: $ul_padding_left" ?>;
}

TT, PRE {
	font-family: "Andale Mono", "Courier New", "Courier", monospace;
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
}

CODE {
	font-family: "Andale Mono", "Courier New", "Courier", monospace;
	/*background-color: #f0f9fc;*/
	white-space: nowrap;
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
}

DIV {
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
}

FORM, INPUT, BUTTON {
	margin-top: 0;
	margin-bottom: 0;
	height: 1.8em;
}

BLOCKQUOTE {
	margin-left: 1em;
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
}

HR {
	height: 1px;
	margin-top: 0;
	margin-bottom: 0;
	border-top: 0px;	/* Mozilla work-around to eliminate "groove" */
}
IMG {border: 0;}

A:link	  {color: #fff; text-decoration: underline; font-weight:bold;}
A:visited {color: #fff; text-decoration: underline; font-weight:bold;}
A:hover   {color: #fff; text-decoration: none; font-weight:bold;}
A:active  {color: #fff; text-decoration: none; font-weight:bold;}

H1 {
	font-family: "Verdana", "Arial", "Helvetica", sans-serif;
	font-weight: bold;
	font-size: large;
	<?php echo "font-size: $font_size_large" ?>;
	vertical-align: top;
	margin-top: 0;
	color: #234;
}
H2 {
	font-weight: bolder;
	font-style: italic;
	font-size:	140%;
	margin-top: 0;
	padding-top: 0;
}
H3 {
	font-weight: bold;
	font-size:	130%;
	margin-top: 1.1em;
}
H4 {
	font-weight: bold;
	font-style: italic;
	font-size: 120%;
	margin-top: 2em;
	margin-bottom: 0;
}
H5 {
	font-size: 100%;
	font-weight: bold;
	margin-top: 1.3em;
	margin-bottom: 0;
}
H6 {
	font-size: 100%;
	font-weight: normal;
	font-style: italic;
	margin-left: 0.8em;
	margin-top: 1.3em;
	margin-bottom: 0;
}

/* Custom {{{1
*/

.main {
	border:	2px solid #e6e6e6;
	background-color:	#fff;
	width:	740;
	min-height:	450px;
	padding:	18px;
	padding-bottom:	5px;
	padding-top:	10px;
}

/* header */
.header {
	height:	28px;
	margin:	0px;
	padding:	5px;
	width:	100%;
}
.title {
	float:	left;
	padding-left:	0;
}

.logo {
	vertical-align:	middle;
	font-family:	'Verdana', sans-serif;
	font-size: large;
	<?php echo "font-size: $font_size_large" ?>;
	font-weight:	bold;
	letter-spacing: 0.2em;
	padding:		5px;
}
.logo:link    { background-color: transparent; color: #234; text-decoration: none;}
.logo:visited { background-color: transparent; color: #234; text-decoration: none;}
.logo:hover   { background-color: #eee;        color: #345; text-decoration: none;}
.logo:active  { background-color: #eee;        color: #345; text-decoration: none;}

.tagline {
	vertical-align:	middle;
	padding-top:	1px;
	color:	#679;
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
	font-weight: bold;
}

/* search */
.searchform {
	float:	right;
	margin-top:	2px;
	padding-right:	10px;
}
.searchbtn {
	font-size: xx-small;
	<?php echo "font-size: $font_size_xxsmall" ?>;
	height:	1.7em;
	vertical-align:	middle;
	width:	25%;
	font-family:	sans-serif;
	color:	#234;
	margin-bottom:	2px;
	background:	#fff;
}
.searchbox {
	font-size: xx-small;
	<?php echo "font-size: $font_size_xxsmall" ?>;
	height:	1.7em;
	width:	70%;
	vertical-align:	middle;
	color:	#234;
	font-family:	sans-serif;
	background-color:	#fff;
}


/* 4square */
.home, .feat, .down, .about {
	margin:		1px;
	padding:	20px;
	border:		5px solid #fff;
	color:		#fff;
	text-align:	left;
}
.home {
	float:		left;
	background-color:	#234;
}
.feat {
	float:		right;
	background-color:#882;
}
.down {
	float:		left;
	background-color:#473;
}
.about {
	float:		right;
	background-color:#754;
}

/* section titles */
.sectitleleft, .sectitleright {
	width:	100%;
	font-size: large;
	<?php echo "font-size: $font_size_large" ?>;
	margin:	0;
	margin-top:	0;
	margin-bottom:	1em;
	padding:	0;
	letter-spacing:	0.1em;
}
.sectitleleft {
	text-align:	left;
}
.sectitleright {
	text-align:	right;
}

A.sec {
	color: #fff;
}
A.sec:link {
	text-decoration: none;
}
A.sec:visited {
	text-decoration: none;
}
A.sec:hover {
	text-decoration: underline;
}
A.sec:active {
	text-decoration: underline;
}
A.secoff {
	color: #fff;
	font-weight: normal;
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
	letter-spacing:	0.1em;
}
A.secoff:link {
	text-decoration: none;
}
A.secoff:visited {
	text-decoration: none;
}
A.secoff:hover {
	text-decoration: underline;
}
A.secoff:active {
	text-decoration: underline;
}

/* footer */
.footer {
	width: 100%;
	vertical-align: middle;
	padding:	0;
	color:	#679;
}
.sflogo {
	vertical-align:	middle;
}


/* general markup */

.news-home, .news-about, .news-down {
	float:	right;
	width:	250px;
	padding:	1em;
	margin-top:		0;
	margin-left:	1em;
	margin-bottom:	1em;
}
.news-home  { background-color: #345; margin-top: -2em; }
.news-about { background-color: #865; }
.news-down  { background-color: #584; margin-top: -2em;}

.nolead {
	margin-top: 0;
}

.lesslead {
	margin-top: -1em;
}

.medium {
	font-size: medium;
	<?php echo "font-size: $font_size_medium" ?>;
}
.small {
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
}
.xsmall {
	font-size: x-small;
	<?php echo "font-size: $font_size_xsmall" ?>;
}
.xxsmall {
	font-size: xx-small;
	<?php echo "font-size: $font_size_xxsmall" ?>;
}

.byline {
	font-style: italic;
	font-size: small;
	<?php echo "font-size: $font_size_small" ?>;
	text-align: right;
	/* matches H4 bottom margin */
	margin-top: -1.3em;
}

/* 1}}}
 vim:foldmethod=marker:filetype=css
*/
