/* mkdatafile -- create a Crimson Fields data file
   Copyright (C) 2000-2004 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* takes two file names: icons BMP and output filename

   The data file is written in little-endian format.

   Creates a data file for Crimson Fields containing fonts and icons image data
*/

#include <stdio.h>
#include <stdlib.h>

#include "SDL.h"
#include "SDL_endian.h"

extern int save_image_data( const char *filename, int trans, SDL_RWops *out );

int main( int argc, char *argv[] ) {
  int status;
  SDL_RWops *out;
 
  if ( argc != 3 ) {
    fprintf(stderr, "Invalid number of arguments\n"
                    "Usage: %s <icons.bmp> <outfile>\n",
                    argv[0] );
    exit(-1);
  }


  if ( SDL_Init(0) < 0 ) {
    fprintf(stderr, "Couldn't init SDL: %s\n", SDL_GetError());
    exit(-1);
  }
  atexit(SDL_Quit);

  out = SDL_RWFromFile( argv[2], "wb" );
  if ( !out ) {
    fprintf(stderr, "Couldn't open output file %s\n", argv[5] );
    exit(-1);
  }

  /* icons */
  status = save_image_data( argv[1], 1, out );

  SDL_RWclose( out );
  return status;
}

