/* client.c */
void DoClient(ClientSocket *csocket);
int init_connection(char *host, int port);
void negotiate_connection(int sound);
/* commands.c */
void ReplyInfoCmd(char *buf, int len);
void SetupCmd(char *buf, int len);
void ExtendedInfoSetCmd(char *data, int len);
void AddMeFail(char *data, int len);
void AddMeSuccess(char *data, int len);
void GoodbyeCmd(char *data, int len);
void AnimCmd(unsigned char *data, int len);
void SmoothCmd(unsigned char *data, int len);
void DrawInfoCmd(char *data, int len);
void setTextManager(int type, ExtTextManager callback);
void DrawExtInfoCmd(char *data, int len);
void StatsCmd(unsigned char *data, int len);
void handle_query(char *data, int len);
void send_reply(const char *text);
void PlayerCmd(unsigned char *data, int len);
void item_actions(item *op);
void Item1Cmd(unsigned char *data, int len);
void Item2Cmd(unsigned char *data, int len);
void UpdateItemCmd(unsigned char *data, int len);
void DeleteItem(unsigned char *data, int len);
void DeleteInventory(unsigned char *data, int len);
void AddspellCmd(unsigned char *data, int len);
void UpdspellCmd(unsigned char *data, int len);
void DeleteSpell(unsigned char *data, int len);
void NewmapCmd(unsigned char *data, int len);
void Map1Cmd(unsigned char *data, int len);
void Map1aCmd(unsigned char *data, int len);
void Map2Cmd(unsigned char *data, int len);
void map_scrollCmd(char *data, int len);
int ExtSmooth(unsigned char *data, int len, int x, int y, int layer);
void MapExtendedCmd(unsigned char *data, int len);
void MagicMapCmd(unsigned char *data, int len);
void SinkCmd(unsigned char *data, int len);
void TickCmd(char *buf, int len);
/* image.c */
void init_common_cache_data(void);
void requestsmooth(int pnum);
void requestface(int pnum, char *facename);
void finish_face_cmd(int pnum, uint32 checksum, int has_sum, char *face, int faceset);
void reset_image_cache_data(void);
void FaceCmd(unsigned char *data, int len);
void Face1Cmd(unsigned char *data, int len);
void Face2Cmd(uint8 *data, int len);
void ImageCmd(uint8 *data, int len);
void Image2Cmd(uint8 *data, int len);
void display_newpng(long face, uint8 *buf, long buflen, int setnum);
void get_image_info(char *data, int len);
void get_image_sums(uint8 *data, int len);
/* init.c */
void VersionCmd(char *data, int len);
void SendVersion(ClientSocket csock);
void SendAddMe(ClientSocket csock);
void SendSetFaceMode(ClientSocket csock, int mode);
void init_client_vars(void);
void reset_player_data(void);
void reset_client_vars(void);
/* item.c */
void init_item_types(void);
uint8 get_type_from_name(const char *name);
void update_item_sort(item *it);
char *get_number(uint32 i);
void free_all_items(item *op);
item *locate_item(sint32 tag);
void remove_item(item *op);
void remove_item_inventory(item *op);
item *create_new_item(item *env, sint32 tag);
int num_free_items(void);
void set_item_values(item *op, char *name, sint32 weight, uint16 face, uint16 flags, uint16 anim, uint16 animspeed, uint32 nrof, uint16 type);
void toggle_locked(item *op);
void send_mark_obj(item *op);
item *player_item(void);
item *map_item(void);
void update_item(int tag, int loc, char *name, int weight, int face, int flags, int anim, int animspeed, uint32 nrof, int type);
void print_inventory(item *op);
void animate_objects(void);
/* mapdata.c */
void mapdata_init(void);
void mapdata_reset(void);
void mapdata_set_size(int viewx, int viewy);
int mapdata_is_inside(int x, int y);
void mapdata_set_face(int x, int y, int darkness, sint16 face0, sint16 face1, sint16 face2);
void mapdata_clear_space(int x, int y);
void mapdata_set_check_space(int x, int y);
void mapdata_set_darkness(int x, int y, int darkness);
void mapdata_set_smooth(int x, int y, int smooth, int layer);
void mapdata_set_face_layer(int x, int y, sint16 face, int layer);
void mapdata_set_anim_layer(int x, int y, uint16 anim, uint8 anim_speed, int layer);
void mapdata_scroll(int dx, int dy);
void mapdata_newmap(void);
sint16 mapdata_face(int x, int y, int layer);
sint16 mapdata_bigface(int x, int y, int layer, int *ww, int *hh);
sint16 mapdata_bigface_head(int x, int y, int layer, int *ww, int *hh);
void mapdata_animation(void);
/* metaserver.c */
int metaserver_get_info(char *metaserver, int meta_port);
void metaserver_show(int show_selection);
int metaserver_select(char *sel);
/* misc.c */
int make_path_to_dir(char *directory);
int make_path_to_file(char *filename);
char *strdup_local(const char *str);
int setLogListener(LogListener li);
void clearLogListener(void);
char *getLogTextRaw(LogLevel level, const char *origin, const char *message);
char *getLogText(const LogEntry *le);
void LOG(LogLevel level, const char *origin, const char *format, ...);
void purgePipe(ChildProcess *cp, int pipe);
void monitorChilds(void);
void logPipe(ChildProcess *child, LogLevel level, int pipe);
void unLogPipe(ChildProcess *child, int pipe);
void logChildPipe(ChildProcess *child, LogLevel level, int flag);
void unLogChildPipe(ChildProcess *child, int flag);
ChildProcess *raiseChild(char *name, int flag);
/* newsocket.c */
void SockList_Init(SockList *sl, char *buf);
void SockList_AddChar(SockList *sl, char c);
void SockList_AddShort(SockList *sl, uint16 data);
void SockList_AddInt(SockList *sl, uint32 data);
void SockList_AddString(SockList *sl, const char *str);
int SockList_Send(SockList *sl, int fd);
char GetChar_String(const unsigned char *data);
int GetInt_String(const unsigned char *data);
sint64 GetInt64_String(const unsigned char *data);
short GetShort_String(const unsigned char *data);
int SockList_ReadPacket(int fd, SockList *sl, int len);
int cs_print_string(int fd, const char *str, ...);
/* p_cmd.c */
/* player.c */
void new_player(long tag, char *name, long weight, long face);
void look_at(int x, int y);
void client_send_apply(int tag);
void client_send_examine(int tag);
void client_send_move(int loc, int tag, int nrof);
void move_player(int dir);
void stop_fire(void);
void clear_fire_run(void);
void clear_fire(void);
void clear_run(void);
void fire_dir(int dir);
void stop_run(void);
void run_dir(int dir);
int send_command(const char *command, int repeat, int must_send);
void CompleteCmd(unsigned char *data, int len);
void command_take(const char *command, const char *cpnext);
/* script.c */
