/*
 *  declarations for config-table & mount-table utilities for cryptmount
 *  $Revision: 222 $, $Date: 2008-10-03 12:31:16 +0100 (Fri, 03 Oct 2008) $
 *  (C)Copyright 2005-2008, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef _TABLES_H
#define _TABLES_H


struct cment;

typedef struct tgtstat
{
    char *ident;            /* unique identifying name of target */
    unsigned long uid;      /* user-ID responsible for mounting filesystem */

    struct tgtstat *nx;     /* form into linked list */
} tgtstat_t;


struct cment *alloc_cment(const struct cment *prototype);
const struct cment *get_cment(const struct cment *head, const char *ident);
void free_cment(struct cment *ent);

struct cment *parse_config(const char *cfgname);
struct cment *parse_config_fd(int fd);
void free_config(struct cment **head);

tgtstat_t *alloc_tgtstatus(const struct cment *ent);
tgtstat_t *get_tgtstatus(const struct cment *ent);
tgtstat_t *get_all_tgtstatus();
int put_tgtstatus(const struct cment *ent, const tgtstat_t *tstat);
void free_tgtstatus(tgtstat_t *tstat);

#endif  /* _TABLES_H */

/*
 *  tables.h
 *  (C)Copyright 2005-2008, RW Penney
 */
