<CsoundSynthesizer>
<CsOptions>
; Select audio/midi flags here according to platform
; Audio out   Audio in    No messages
-odac           -iadc     -d     ;;;RT audio I/O
; For Non-realtime ouput leave only the line below:
; -o nlfilt.wav -W ;;; for file output any platform
</CsOptions>
<CsInstruments>

; Initialize the global variables.
sr = 44100
kr = 4410
ksmps = 10
nchnls = 1

; Instrument #1 - an unfiltered noise waveform.
instr 1
  ; Generate a white noise signal.
  asig rand 20000

  out asig
endin


; Instrument #2 - a filtered noise waveform.
instr 2
  ; Generate a white noise signal.
  asig rand 20000
ka = p4
kb = p5
kd = p6
kC = p7
kL = p8

  afilt nlfilt asig, ka, kb, kd, kC, kL

  ; Clip the filtered signal's amplitude to 85 dB.
  a1 clip afilt, 2, ampdb(85)
  out a1
endin


</CsInstruments>
<CsScore>

; Play Instrument #1 for two seconds.
i 1 0 2
; non-linear effect
i 2 2 2 0 0 .8 .5 20
; low=paas with non-linear
i 2 + 2 .4 .2 .7 .11 200
; high-pass with non-linear
i 2 + 2 .35 -.3 .95 .1 200
; high-pass with non-linear
i 2 + 2 .7 .1 .9 .2 100
e


</CsScore>
</CsoundSynthesizer>
