/*  cssed (c) Iago Rubio 2003-2004
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <expat.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <gtk/gtk.h>
#include <string.h>

#ifndef WIN32
# include <sys/mman.h>
#endif


#ifdef WITH_TERMINAL
# include <vte/vte.h>
#endif

#include "cssedwindow.h"
#include "xmlparser.h"
#include "callbacks.h"
#include "support.h"
#include "debug.h"

/* old spat stuff needed for BSD like machines as MacOsX*/
#ifndef XML_STATUS_OK
   #define XML_STATUS_OK    1
   #define XML_STATUS_ERROR 0
#endif

/* protos */
static void
fill_tree_view_start_tag_cb (void* data, const char *el, const char **attr);
static void
fill_tree_view_end_tag_cb (void *data, const char *el);

/* globals */
int depth;

/* parse the css definition, it don't validates against the DTD
	so ANY well formed XML will be parsed. Take in account that
	you can put garbled values on the treeview if you parse
	a not cssed related XML doc, resulting in a real mess !!
	// FIXME: change me to accept a filename as parameter.
*/
void
parse_css_definition_and_fill_tree_view( Tcssed_tp_data* data )
{
	CssedWindow* window;
	gchar* userfile = NULL; // Keep compiler happy
	gchar* systemfile;
	GtkTreeView* treeview ;
	gchar* err ;
	XML_Parser p;
	GError* error = NULL;
#ifdef WIN32
	gchar* map;
	gchar* allocated;
#else
	void* map;
	int filedes;
	struct stat ststat;
	int _retval;
	gchar* home;
	gchar* globalfile;
#endif
	window = CSSED_WINDOW(data->window);
	treeview = GTK_TREE_VIEW( cssed_window_get_css_definition_treeview ( window ) );



#ifdef WIN32
	systemfile = "data\\cssed-def.xml";
#else  // _WIN32
	globalfile = PACKAGE_DATA_DIR "/" PACKAGE "/data/cssed-def.xml";
	// check if the user have a local definition file
	home = getenv("HOME");

	if( home != NULL ){
		userfile = g_strconcat(home,"/.cssed/cssed-def.xml",NULL);
		if( g_file_test(userfile,G_FILE_TEST_IS_REGULAR| G_FILE_TEST_EXISTS) ){
			systemfile = userfile;
		}else{
			systemfile = globalfile;
		}
	}else{
		systemfile = globalfile;
	}
#endif

	DBGMSG("Will try to use: %s\n", systemfile );

#ifdef WIN32
	if( g_file_get_contents(systemfile, &map, NULL,  &error ) ){
		p = XML_ParserCreate (NULL);
		if (!p)
		{
			cssed_error_message( _("Cannot allocate memory for XML parser !!!") , _("Error") );
			return;
		}
		XML_SetElementHandler (p, fill_tree_view_start_tag_cb, fill_tree_view_end_tag_cb);
		XML_SetUserData( p, (void *) data);
		allocated = g_strdup( map );
		if (XML_Parse (p, (char*) allocated, strlen( allocated ), 1) == XML_STATUS_ERROR)
		{
			err = g_strdup_printf( _("The CSS definition XML file is bogus,\nParse error at line %d:\n%s\n"),
										XML_GetCurrentLineNumber (p),
										XML_ErrorString (XML_GetErrorCode (p)) );
			cssed_error_message	(err,_("Configuration error") );
			g_free(err);
		}
		g_free( allocated );
		XML_ParserFree(p);
	}else{
		cssed_error_message( _("Cannot read file\n") , _("Error") );
	}
#else  // _WIN32
	_retval = stat( systemfile , &ststat );

	if( _retval != 0 ){
		cssed_error_message( "Cannot stat on CSS definitions file !!!" , "Error" );
  	}else{
		if( S_ISREG( ststat.st_mode ) ){
	  		if( (filedes = open(systemfile, O_RDONLY)) < 0){
				cssed_error_message( "Cannot open CSS definitions file !!!" , "Error" );
	  		}else{
				if( (map = mmap(0,ststat.st_size, PROT_READ, MAP_SHARED, filedes, 0)) == MAP_FAILED ){
		  			cssed_error_message( "Cannot map CSS definitions file to memory !!!" , "Error" );
		  			close(filedes);
					return;
				}else{
					p = XML_ParserCreate (NULL);
					if (!p)
					{
						cssed_error_message( "Cannot allocate memory for XML parser !!!" , "Error" );
						munmap(map,ststat.st_size );
						close(filedes);
						return;
					}

					XML_SetElementHandler (p, fill_tree_view_start_tag_cb, fill_tree_view_end_tag_cb);
					XML_SetUserData( p, (void *) data);

					if (XML_Parse (p, (char*) map, ststat.st_size, 1) == XML_STATUS_ERROR)
					{
						err = g_strdup_printf("The CSS definiton XML file is bogus,\nParse error at line %d:\n%s\n",
													XML_GetCurrentLineNumber (p),
						 							XML_ErrorString (XML_GetErrorCode (p)) );
						cssed_error_message	(err,"Configuration error" );
						g_free(err);
					}
				}
				munmap(map,ststat.st_size);
				close(filedes);
			}
		}
	}
#endif // _WIN32

	if( userfile ) g_free(userfile);
}

static void
fill_tree_view_start_tag_cb (void* data, const char *el, const char **attr)
{
	gint i;
	gchar* err_depth;
	GtkWidget* tree;
	GtkTreeStore *model;
	//GtkWidget *treeview;
	GtkTreeIter* toplevel, *child, *third;
	CssedWindow* window;
	Tcssed_tp_data* tp_data = (Tcssed_tp_data*) data;
	//gchar* keywordslist;
	gchar* key_copy;

	window = CSSED_WINDOW(tp_data->window);

	toplevel =	tp_data->first_col;
	child =  	tp_data->second_col;
	third =  	tp_data->thrid_col;
	model =  	tp_data->store;

	tree = cssed_window_get_css_definition_treeview ( window );

	switch( depth ){
		case 0: // in depth 0 we've got the imp def and name
				for (i = 0; attr[i]; i += 2)
				{
					if( strcmp( attr[i], "implementation")==0){
						gtk_tree_store_append (model, toplevel, NULL);
						gtk_tree_store_set(model, toplevel, depth, attr[i + 1], -1);
					}
				}
		break;
		case 1: // in depth 1 will find reserved words ( properties )
				for (i = 0; attr[i]; i += 2)
				{
					if( strcmp( attr[i], "name")==0){
						gtk_tree_store_append (model, child, toplevel);
						gtk_tree_store_set (model, child, depth, attr[i + 1] , -1);
						// add to keywordlist
						key_copy = g_strdup( cssed_window_get_keyword_list( window ) );
						cssed_window_set_keyword_list(  window, g_strjoin (" ",key_copy, attr[i + 1], NULL ) );
						g_free( key_copy );
					}
				}
		break;
		case 2: // in depth 3 there are the properties valid values
				for (i = 0; attr[i]; i += 2)
				{
					if( strcmp( attr[i], "name")==0){
						gtk_tree_store_append (model, third, child);
						gtk_tree_store_set (model, third, depth, attr[i + 1], -1);
					}
				}
		break;
		default:
				// it must go out here
				err_depth = g_strdup_printf(
						_("<span color='brown'>* Bad XML definition file depth %d at element \"%s\". Max depth must be 3.</span>"),
						depth, el);
				cssed_window_output_write( window, err_depth );
				g_free(err_depth);
		break;
	}
	depth++;
}

static void
fill_tree_view_end_tag_cb (void *data, const char *el)
{
	depth--;
}
